/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestReplicationUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationUtil.class);
    private static TableName TABLE_A = TableName.valueOf((String)"replication", (String)"testA");
    private static TableName TABLE_B = TableName.valueOf((String)"replication", (String)"testB");

    @Test
    public void testContainsWithReplicatingAll() {
        ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl builder = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl();
        HashMap<TableName, Object> tableCfs = new HashMap<TableName, Object>();
        HashSet<String> namespaces = new HashSet<String>();
        builder.setReplicateAllUserTables(true);
        ReplicationPeerConfig peerConfig = builder.build();
        Assert.assertTrue((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        builder.setExcludeNamespaces(null);
        tableCfs = new HashMap();
        builder.setReplicateAllUserTables(true);
        builder.setExcludeTableCFsMap(tableCfs);
        peerConfig = builder.build();
        Assert.assertTrue((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        tableCfs = new HashMap();
        tableCfs.put(TABLE_B, null);
        builder.setReplicateAllUserTables(true);
        builder.setExcludeTableCFsMap(tableCfs);
        peerConfig = builder.build();
        Assert.assertTrue((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        tableCfs = new HashMap();
        tableCfs.put(TABLE_A, null);
        builder.setReplicateAllUserTables(true);
        builder.setExcludeTableCFsMap(tableCfs);
        peerConfig = builder.build();
        Assert.assertFalse((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        builder.setExcludeTableCFsMap(null);
        namespaces = new HashSet();
        builder.setReplicateAllUserTables(true);
        builder.setExcludeNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertTrue((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        namespaces = new HashSet();
        namespaces.add("default");
        builder.setReplicateAllUserTables(true);
        builder.setExcludeNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertTrue((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        namespaces = new HashSet();
        namespaces.add("replication");
        builder.setReplicateAllUserTables(true);
        builder.setExcludeNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertFalse((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("replication");
        tableCfs.put(TABLE_A, null);
        builder.setReplicateAllUserTables(true);
        builder.setExcludeTableCFsMap(tableCfs);
        builder.setExcludeNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertFalse((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("default");
        tableCfs.put(TABLE_A, null);
        builder.setReplicateAllUserTables(true);
        builder.setExcludeTableCFsMap(tableCfs);
        builder.setExcludeNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertFalse((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("replication");
        tableCfs.put(TABLE_B, null);
        builder.setReplicateAllUserTables(true);
        builder.setExcludeTableCFsMap(tableCfs);
        builder.setExcludeNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertFalse((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
    }

    @Test
    public void testContainsWithoutReplicatingAll() {
        ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl builder = new ReplicationPeerConfig.ReplicationPeerConfigBuilderImpl();
        HashMap<TableName, Object> tableCfs = new HashMap<TableName, Object>();
        HashSet<String> namespaces = new HashSet<String>();
        builder.setReplicateAllUserTables(false);
        ReplicationPeerConfig peerConfig = builder.build();
        Assert.assertFalse((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        builder.setReplicateAllUserTables(false);
        builder.setTableCFsMap(tableCfs);
        peerConfig = builder.build();
        Assert.assertFalse((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        tableCfs = new HashMap();
        tableCfs.put(TABLE_B, null);
        builder.setReplicateAllUserTables(false);
        builder.setTableCFsMap(tableCfs);
        peerConfig = builder.build();
        Assert.assertFalse((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        tableCfs = new HashMap();
        tableCfs.put(TABLE_A, null);
        builder.setReplicateAllUserTables(false);
        builder.setTableCFsMap(tableCfs);
        peerConfig = builder.build();
        Assert.assertTrue((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        builder.setTableCFsMap(null);
        builder.setReplicateAllUserTables(false);
        builder.setNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertFalse((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        namespaces = new HashSet();
        namespaces.add("default");
        builder.setReplicateAllUserTables(false);
        builder.setNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertFalse((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        namespaces = new HashSet();
        namespaces.add("replication");
        builder.setReplicateAllUserTables(false);
        builder.setNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertTrue((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("replication");
        tableCfs.put(TABLE_A, null);
        builder.setReplicateAllUserTables(false);
        builder.setTableCFsMap(tableCfs);
        builder.setNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertTrue((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("default");
        tableCfs.put(TABLE_A, null);
        builder.setReplicateAllUserTables(false);
        builder.setTableCFsMap(tableCfs);
        builder.setNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertTrue((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
        namespaces = new HashSet();
        tableCfs = new HashMap();
        namespaces.add("replication");
        tableCfs.put(TABLE_B, null);
        builder.setReplicateAllUserTables(false);
        builder.setTableCFsMap(tableCfs);
        builder.setNamespaces(namespaces);
        peerConfig = builder.build();
        Assert.assertTrue((boolean)ReplicationUtils.contains((ReplicationPeerConfig)peerConfig, (TableName)TABLE_A));
    }
}

