/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.util.Arrays;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.http.HttpServerUtil;
import org.apache.hadoop.hbase.rest.RESTServer;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.util.StringUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRESTTestingUtility {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseRESTTestingUtility.class);
    private int testServletPort;
    private Server server;

    public int getServletPort() {
        return this.testServletPort;
    }

    public void startServletContainer(Configuration conf) throws Exception {
        Object[] filterClasses;
        if (this.server != null) {
            LOG.error("ServletContainer already running");
            return;
        }
        RESTServlet.getInstance((Configuration)conf, (UserProvider)UserProvider.instantiate((Configuration)conf));
        ResourceConfig app = new ResourceConfig().packages(new String[]{"org.apache.hadoop.hbase.rest"}).register(JacksonJaxbJsonProvider.class);
        ServletHolder sh = new ServletHolder((Servlet)new ServletContainer(app));
        this.server = new Server(0);
        LOG.info("configured " + ServletContainer.class.getName());
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendDateHeader(false);
        httpConfig.setSendServerVersion(false);
        ServerConnector serverConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        serverConnector.setPort(this.testServletPort);
        this.server.addConnector((Connector)serverConnector);
        ServletContextHandler ctxHandler = new ServletContextHandler((HandlerContainer)this.server, "/", 1);
        ctxHandler.addServlet(sh, "/*");
        for (String string : filterClasses = conf.getStrings("hbase.rest.filter.classes", ArrayUtils.EMPTY_STRING_ARRAY)) {
            String string2 = string.trim();
            ctxHandler.addFilter(string2, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        LOG.info("Loaded filter classes :" + Arrays.toString(filterClasses));
        conf.set(RESTServer.REST_CSRF_BROWSER_USERAGENTS_REGEX_KEY, ".*");
        RESTServer.addCSRFFilter((ServletContextHandler)ctxHandler, (Configuration)conf);
        HttpServerUtil.constrainHttpMethods((ServletContextHandler)ctxHandler, (boolean)true);
        this.server.start();
        this.testServletPort = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        LOG.info("started " + this.server.getClass().getName() + " on port " + this.testServletPort);
    }

    public void shutdownServletContainer() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server = null;
                RESTServlet.stop();
            }
            catch (Exception e) {
                LOG.warn(StringUtils.stringifyException((Throwable)e));
            }
        }
    }
}

