/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.StorageClusterStatusModel;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RestTests.class, MediumTests.class})
public class TestStatusResource {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStatusResource.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestStatusResource.class);
    private static final byte[] META_REGION_NAME = Bytes.toBytes((String)(TableName.META_TABLE_NAME + ",,1"));
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;
    private static JAXBContext context;
    private static Configuration conf;

    private static void validate(StorageClusterStatusModel model) {
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((String)(model.getRegions() + ">= 1"), (model.getRegions() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((model.getRequests() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((model.getAverageLoad() >= 0.0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)model.getLiveNodes());
        Assert.assertNotNull((Object)model.getDeadNodes());
        Assert.assertFalse((boolean)model.getLiveNodes().isEmpty());
        boolean foundMeta = false;
        for (StorageClusterStatusModel.Node node : model.getLiveNodes()) {
            Assert.assertNotNull((Object)node.getName());
            Assert.assertTrue((node.getStartCode() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((node.getRequests() >= 0L ? 1 : 0) != 0);
            for (StorageClusterStatusModel.Node.Region region : node.getRegions()) {
                if (!Bytes.equals((byte[])region.getName(), (byte[])META_REGION_NAME)) continue;
                foundMeta = true;
            }
        }
        Assert.assertTrue((boolean)foundMeta);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster(1, 1);
        TEST_UTIL.createTable(TableName.valueOf((String)"TestStatusResource"), Bytes.toBytes((String)"D"));
        TEST_UTIL.createTable(TableName.valueOf((String)"TestStatusResource2"), Bytes.toBytes((String)"D"));
        REST_TEST_UTIL.startServletContainer(conf);
        Cluster cluster = new Cluster();
        cluster.add("localhost", REST_TEST_UTIL.getServletPort());
        client = new Client(cluster);
        context = JAXBContext.newInstance((Class[])new Class[]{StorageClusterStatusModel.class});
        TEST_UTIL.waitFor(6000L, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return TEST_UTIL.getMiniHBaseCluster().getClusterStatus().getAverageLoad() > 0.0;
            }
        });
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGetClusterStatusXML() throws IOException, JAXBException {
        Response response = client.get("/status/cluster", "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        StorageClusterStatusModel model = (StorageClusterStatusModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        TestStatusResource.validate(model);
    }

    @Test
    public void testGetClusterStatusPB() throws IOException {
        Response response = client.get("/status/cluster", "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        StorageClusterStatusModel model = new StorageClusterStatusModel();
        model.getObjectFromMessage(response.getBody());
        TestStatusResource.validate(model);
        response = client.get("/status/cluster", "application/protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/protobuf", (Object)response.getHeader("content-type"));
        model = new StorageClusterStatusModel();
        model.getObjectFromMessage(response.getBody());
        TestStatusResource.validate(model);
    }
}

