/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, SmallTests.class})
public class TestCellModel
extends TestModelBase<CellModel> {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCellModel.class);
    private static final long TIMESTAMP = 1245219839331L;
    private static final byte[] COLUMN = Bytes.toBytes((String)"testcolumn");
    private static final byte[] VALUE = Bytes.toBytes((String)"testvalue");

    public TestCellModel() throws Exception {
        super(CellModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Cell column=\"dGVzdGNvbHVtbg==\" timestamp=\"1245219839331\">dGVzdHZhbHVl</Cell>";
        this.AS_PB = "Egp0ZXN0Y29sdW1uGOO6i+eeJCIJdGVzdHZhbHVl";
        this.AS_JSON = "{\"column\":\"dGVzdGNvbHVtbg==\",\"timestamp\":1245219839331,\"$\":\"dGVzdHZhbHVl\"}";
    }

    @Override
    protected CellModel buildTestModel() {
        CellModel model = new CellModel();
        model.setColumn(COLUMN);
        model.setTimestamp(1245219839331L);
        model.setValue(VALUE);
        return model;
    }

    @Override
    protected void checkModel(CellModel model) {
        Assert.assertTrue((boolean)Bytes.equals((byte[])model.getColumn(), (byte[])COLUMN));
        Assert.assertTrue((boolean)Bytes.equals((byte[])model.getValue(), (byte[])VALUE));
        Assert.assertTrue((boolean)model.hasUserTimestamp());
        Assert.assertEquals((long)1245219839331L, (long)model.getTimestamp());
    }

    @Override
    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    @Override
    public void testFromXML() throws Exception {
        this.checkModel((CellModel)this.fromXML(this.AS_XML));
    }

    @Override
    public void testFromPB() throws Exception {
        this.checkModel((CellModel)this.fromPB(this.AS_PB));
    }

    @Test
    public void testEquals() throws Exception {
        CellModel cellModel1 = this.buildTestModel();
        CellModel cellModel2 = this.buildTestModel();
        Assert.assertEquals((Object)cellModel1, (Object)cellModel2);
        CellModel cellModel3 = new CellModel();
        Assert.assertFalse((boolean)cellModel1.equals((Object)cellModel3));
    }

    @Test
    public void testToString() throws Exception {
        String expectedColumn = ToStringBuilder.reflectionToString((Object)COLUMN, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        CellModel cellModel = this.buildTestModel();
        System.out.println(cellModel);
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)cellModel.toString(), (CharSequence)expectedColumn));
    }
}

