/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.rest.model.ColumnSchemaModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, SmallTests.class})
public class TestColumnSchemaModel
extends TestModelBase<ColumnSchemaModel> {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestColumnSchemaModel.class);
    protected static final String COLUMN_NAME = "testcolumn";
    protected static final boolean BLOCKCACHE = true;
    protected static final int BLOCKSIZE = 16384;
    protected static final String BLOOMFILTER = "NONE";
    protected static final String COMPRESSION = "GZ";
    protected static final boolean IN_MEMORY = false;
    protected static final int TTL = 86400;
    protected static final int VERSIONS = 1;

    public TestColumnSchemaModel() throws Exception {
        super(ColumnSchemaModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ColumnSchema name=\"testcolumn\" BLOCKSIZE=\"16384\" BLOOMFILTER=\"NONE\" BLOCKCACHE=\"true\" COMPRESSION=\"GZ\" VERSIONS=\"1\" TTL=\"86400\" IN_MEMORY=\"false\"/>";
        this.AS_JSON = "{\"name\":\"testcolumn\",\"BLOCKSIZE\":\"16384\",\"BLOOMFILTER\":\"NONE\",\"BLOCKCACHE\":\"true\",\"COMPRESSION\":\"GZ\",\"VERSIONS\":\"1\",\"TTL\":\"86400\",\"IN_MEMORY\":\"false\"}";
    }

    @Override
    protected ColumnSchemaModel buildTestModel() {
        ColumnSchemaModel model = new ColumnSchemaModel();
        model.setName(COLUMN_NAME);
        model.__setBlocksize(16384);
        model.__setBloomfilter(BLOOMFILTER);
        model.__setBlockcache(true);
        model.__setCompression(COMPRESSION);
        model.__setVersions(1);
        model.__setTTL(86400);
        model.__setInMemory(false);
        return model;
    }

    @Override
    protected void checkModel(ColumnSchemaModel model) {
        Assert.assertEquals((String)"name", (Object)COLUMN_NAME, (Object)model.getName());
        Assert.assertEquals((String)"block cache", (Object)true, (Object)model.__getBlockcache());
        Assert.assertEquals((String)"block size", (long)16384L, (long)model.__getBlocksize());
        Assert.assertEquals((String)"bloomfilter", (Object)BLOOMFILTER, (Object)model.__getBloomfilter());
        Assert.assertTrue((String)"compression", (boolean)model.__getCompression().equalsIgnoreCase(COMPRESSION));
        Assert.assertEquals((String)"in memory", (Object)false, (Object)model.__getInMemory());
        Assert.assertEquals((String)"ttl", (long)86400L, (long)model.__getTTL());
        Assert.assertEquals((String)"versions", (long)1L, (long)model.__getVersions());
    }

    @Override
    @Test
    public void testFromPB() throws Exception {
    }
}

