/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.ResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RowResource
extends ResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(RowResource.class);
    private static final String CHECK_PUT = "put";
    private static final String CHECK_DELETE = "delete";
    private static final String CHECK_APPEND = "append";
    private static final String CHECK_INCREMENT = "increment";
    private TableResource tableResource;
    private RowSpec rowspec;
    private String check = null;
    private boolean returnResult = false;

    public RowResource(TableResource tableResource, String rowspec, String versions, String check, String returnResult) throws IOException {
        this.tableResource = tableResource;
        this.rowspec = new RowSpec(rowspec);
        if (versions != null) {
            this.rowspec.setMaxVersions(Integer.parseInt(versions));
        }
        this.check = check;
        if (returnResult != null) {
            this.returnResult = Boolean.valueOf(returnResult);
        }
    }

    @GET
    @Produces(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        MultivaluedMap params = uriInfo.getQueryParameters();
        try {
            ResultGenerator generator = ResultGenerator.fromRowSpec(this.tableResource.getName(), this.rowspec, null, !params.containsKey((Object)"nocache"));
            if (!generator.hasNext()) {
                this.servlet.getMetrics().incrementFailedGetRequests(1);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
            }
            int count = 0;
            CellSetModel model = new CellSetModel();
            Cell value = (Cell)generator.next();
            byte[] rowKey = CellUtil.cloneRow((Cell)value);
            RowModel rowModel = new RowModel(rowKey);
            do {
                if (!Bytes.equals((byte[])CellUtil.cloneRow((Cell)value), (byte[])rowKey)) {
                    model.addRow(rowModel);
                    rowKey = CellUtil.cloneRow((Cell)value);
                    rowModel = new RowModel(rowKey);
                }
                rowModel.addCell(new CellModel(CellUtil.cloneFamily((Cell)value), CellUtil.cloneQualifier((Cell)value), value.getTimestamp(), CellUtil.cloneValue((Cell)value)));
            } while (++count <= this.rowspec.getMaxValues() && (value = (Cell)generator.next()) != null);
            model.addRow(rowModel);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return Response.ok((Object)model).build();
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return this.processException(e);
        }
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response getBinary(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream");
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (!this.rowspec.hasColumns() || this.rowspec.getColumns().length > 1) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Default 'GET' method only works if there is exactly 1 column in the row. Using the 'Accept' header with one of these formats lets you retrieve the entire row if it has multiple columns: text/xml, application/json, application/x-protobuf, application/protobuf\r\n").build();
        }
        MultivaluedMap params = uriInfo.getQueryParameters();
        try {
            ResultGenerator generator = ResultGenerator.fromRowSpec(this.tableResource.getName(), this.rowspec, null, !params.containsKey((Object)"nocache"));
            if (!generator.hasNext()) {
                this.servlet.getMetrics().incrementFailedGetRequests(1);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Not found\r\n").build();
            }
            Cell value = (Cell)generator.next();
            Response.ResponseBuilder response = Response.ok((Object)CellUtil.cloneValue((Cell)value));
            response.header("X-Timestamp", (Object)value.getTimestamp());
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return this.processException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response update(CellSetModel model, boolean replace) {
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        if (CHECK_PUT.equalsIgnoreCase(this.check)) {
            return this.checkAndPut(model);
        }
        if (CHECK_DELETE.equalsIgnoreCase(this.check)) {
            return this.checkAndDelete(model);
        }
        if (CHECK_APPEND.equalsIgnoreCase(this.check)) {
            return this.append(model);
        }
        if (CHECK_INCREMENT.equalsIgnoreCase(this.check)) {
            return this.increment(model);
        }
        if (this.check != null && this.check.length() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("Invalid check value '" + this.check + "'" + "\r\n")).build();
        }
        Table table = null;
        try {
            List<RowModel> rows = model.getRows();
            ArrayList<Put> puts = new ArrayList<Put>();
            for (RowModel row : rows) {
                byte[] key = row.getKey();
                if (key == null) {
                    key = this.rowspec.getRow();
                }
                if (key == null) {
                    this.servlet.getMetrics().incrementFailedPutRequests(1);
                    Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Row key not specified.\r\n").build();
                    return response;
                }
                Put put = new Put(key);
                int i = 0;
                for (CellModel cell : row.getCells()) {
                    byte[] col = cell.getColumn();
                    if (col == null) {
                        try {
                            col = this.rowspec.getColumns()[i++];
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            col = null;
                        }
                    }
                    if (col == null) {
                        this.servlet.getMetrics().incrementFailedPutRequests(1);
                        Response e = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column found to be null.\r\n").build();
                        return e;
                    }
                    byte[][] parts = CellUtil.parseColumn((byte[])col);
                    if (parts.length != 2) {
                        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                        return response;
                    }
                    put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(parts[0]).setQualifier(parts[1]).setTimestamp(cell.getTimestamp()).setType(Cell.Type.Put).setValue(cell.getValue()).build());
                }
                puts.add(put);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("PUT " + put.toString());
            }
            table = this.servlet.getTable(this.tableResource.getName());
            table.put(puts);
            Response.ResponseBuilder response = Response.ok();
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            Response response2 = response.build();
            return response2;
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            Response response = this.processException(e);
            return response;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {
                    LOG.debug("Exception received while closing the table", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response updateBinary(byte[] message, HttpHeaders headers, boolean replace) {
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        Table table = null;
        try {
            byte[] row = this.rowspec.getRow();
            byte[][] columns = this.rowspec.getColumns();
            byte[] column = null;
            if (columns != null) {
                column = columns[0];
            }
            long timestamp = Long.MAX_VALUE;
            List vals = headers.getRequestHeader("X-Row");
            if (vals != null && !vals.isEmpty()) {
                row = Bytes.toBytes((String)((String)vals.get(0)));
            }
            if ((vals = headers.getRequestHeader("X-Column")) != null && !vals.isEmpty()) {
                column = Bytes.toBytes((String)((String)vals.get(0)));
            }
            if ((vals = headers.getRequestHeader("X-Timestamp")) != null && !vals.isEmpty()) {
                timestamp = Long.parseLong((String)vals.get(0));
            }
            if (column == null) {
                this.servlet.getMetrics().incrementFailedPutRequests(1);
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column found to be null.\r\n").build();
                return response;
            }
            Put put = new Put(row);
            byte[][] parts = CellUtil.parseColumn((byte[])column);
            if (parts.length != 2) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                return response;
            }
            put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(parts[0]).setQualifier(parts[1]).setTimestamp(timestamp).setType(Cell.Type.Put).setValue(message).build());
            table = this.servlet.getTable(this.tableResource.getName());
            table.put(put);
            if (LOG.isTraceEnabled()) {
                LOG.trace("PUT " + put.toString());
            }
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            Response response = this.processException(e);
            return response;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {
                    LOG.debug("Exception received while closing the table", (Throwable)ioe);
                }
            }
        }
    }

    @PUT
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response put(CellSetModel model, @Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("PUT " + uriInfo.getAbsolutePath() + " " + uriInfo.getQueryParameters());
        }
        return this.update(model, true);
    }

    @PUT
    @Consumes(value={"application/octet-stream"})
    public Response putBinary(byte[] message, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("PUT " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream");
        }
        return this.updateBinary(message, headers, true);
    }

    @POST
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response post(CellSetModel model, @Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("POST " + uriInfo.getAbsolutePath() + " " + uriInfo.getQueryParameters());
        }
        return this.update(model, false);
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    public Response postBinary(byte[] message, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("POST " + uriInfo.getAbsolutePath() + " as " + "application/octet-stream");
        }
        return this.updateBinary(message, headers, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    public Response delete(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("DELETE " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        Delete delete = null;
        delete = this.rowspec.hasTimestamp() ? new Delete(this.rowspec.getRow(), this.rowspec.getTimestamp()) : new Delete(this.rowspec.getRow());
        for (byte[] column : this.rowspec.getColumns()) {
            byte[][] split = CellUtil.parseColumn((byte[])column);
            if (this.rowspec.hasTimestamp()) {
                if (split.length == 1) {
                    delete.addFamily(split[0], this.rowspec.getTimestamp());
                    continue;
                }
                if (split.length == 2) {
                    delete.addColumns(split[0], split[1], this.rowspec.getTimestamp());
                    continue;
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
            }
            if (split.length == 1) {
                delete.addFamily(split[0]);
                continue;
            }
            if (split.length == 2) {
                delete.addColumns(split[0], split[1]);
                continue;
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
        }
        Table table = null;
        try {
            table = this.servlet.getTable(this.tableResource.getName());
            table.delete(delete);
            this.servlet.getMetrics().incrementSucessfulDeleteRequests(1);
            if (LOG.isTraceEnabled()) {
                LOG.trace("DELETE " + delete.toString());
            }
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            Response response = this.processException(e);
            return response;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {
                    LOG.debug("Exception received while closing the table", (Throwable)ioe);
                }
            }
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response checkAndPut(CellSetModel model) {
        Table table = null;
        try {
            Object valueToPutCell2;
            table = this.servlet.getTable(this.tableResource.getName());
            if (model.getRows().size() != 1) {
                this.servlet.getMetrics().incrementFailedPutRequests(1);
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Number of rows specified is not 1.\r\n").build();
                return response;
            }
            RowModel rowModel = model.getRows().get(0);
            byte[] key = rowModel.getKey();
            if (key == null) {
                key = this.rowspec.getRow();
            }
            List<CellModel> cellModels = rowModel.getCells();
            int cellModelCount = cellModels.size();
            if (key == null || cellModelCount <= 1) {
                this.servlet.getMetrics().incrementFailedPutRequests(1);
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Either row key is null or no data found for columns specified.\r\n").build();
                return response;
            }
            Put put = new Put(key);
            CellModel valueToCheckCell = cellModels.get(cellModelCount - 1);
            byte[] valueToCheckColumn = valueToCheckCell.getColumn();
            byte[][] valueToPutParts = CellUtil.parseColumn((byte[])valueToCheckColumn);
            if (valueToPutParts.length == 2 && valueToPutParts[1].length > 0) {
                valueToPutCell2 = null;
                int n = cellModelCount - 1;
                for (int i = 0; i < n; ++i) {
                    CellModel cell = cellModels.get(i);
                    byte[] col = cell.getColumn();
                    if (col == null) {
                        this.servlet.getMetrics().incrementFailedPutRequests(1);
                        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column found to be null.\r\n").build();
                        return response;
                    }
                    byte[][] parts = CellUtil.parseColumn((byte[])col);
                    if (parts.length != 2) {
                        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request\r\n").build();
                        return response;
                    }
                    put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(parts[0]).setQualifier(parts[1]).setTimestamp(cell.getTimestamp()).setType(Cell.Type.Put).setValue(cell.getValue()).build());
                    if (!Bytes.equals((byte[])col, (byte[])valueToCheckCell.getColumn())) continue;
                    valueToPutCell2 = cell;
                }
                if (valueToPutCell2 == null) {
                    this.servlet.getMetrics().incrementFailedPutRequests(1);
                    Response i = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: The column to put and check do not match.\r\n").build();
                    return i;
                }
            } else {
                this.servlet.getMetrics().incrementFailedPutRequests(1);
                Response valueToPutCell2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column incorrectly specified.\r\n").build();
                return valueToPutCell2;
            }
            boolean retValue = table.checkAndMutate(key, valueToPutParts[0]).qualifier(valueToPutParts[1]).ifEquals(valueToCheckCell.getValue()).thenPut(put);
            if (LOG.isTraceEnabled()) {
                LOG.trace("CHECK-AND-PUT " + put.toString() + ", returns " + retValue);
            }
            if (!retValue) {
                this.servlet.getMetrics().incrementFailedPutRequests(1);
                valueToPutCell2 = Response.status((Response.Status)Response.Status.NOT_MODIFIED).type("text/plain").entity((Object)"Value not Modified\r\n").build();
                return valueToPutCell2;
            }
            Response.ResponseBuilder response = Response.ok();
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            Response response2 = response.build();
            return response2;
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            Response response = this.processException(e);
            return response;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {
                    LOG.debug("Exception received while closing the table", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response checkAndDelete(CellSetModel model) {
        Table table = null;
        Delete delete = null;
        try {
            boolean retValue;
            byte[][] parts;
            table = this.servlet.getTable(this.tableResource.getName());
            if (model.getRows().size() != 1) {
                this.servlet.getMetrics().incrementFailedDeleteRequests(1);
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Number of rows specified is not 1.\r\n").build();
                return response;
            }
            RowModel rowModel = model.getRows().get(0);
            byte[] key = rowModel.getKey();
            if (key == null) {
                key = this.rowspec.getRow();
            }
            if (key == null) {
                this.servlet.getMetrics().incrementFailedDeleteRequests(1);
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Row key found to be null.\r\n").build();
                return response;
            }
            List<CellModel> cellModels = rowModel.getCells();
            int cellModelCount = cellModels.size();
            delete = new Delete(key);
            CellModel valueToDeleteCell = rowModel.getCells().get(cellModelCount - 1);
            byte[] valueToDeleteColumn = valueToDeleteCell.getColumn();
            if (valueToDeleteColumn == null) {
                try {
                    valueToDeleteColumn = this.rowspec.getColumns()[0];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.servlet.getMetrics().incrementFailedDeleteRequests(1);
                    Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column not specified for check.\r\n").build();
                    if (table != null) {
                        try {
                            table.close();
                        }
                        catch (IOException ioe) {
                            LOG.debug("Exception received while closing the table", (Throwable)ioe);
                        }
                    }
                    return response;
                }
            }
            if (cellModelCount > 1) {
                int n = cellModelCount - 1;
                for (int i = 0; i < n; ++i) {
                    CellModel cell = cellModels.get(i);
                    byte[] col = cell.getColumn();
                    if (col == null) {
                        this.servlet.getMetrics().incrementFailedPutRequests(1);
                        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column found to be null.\r\n").build();
                        return response;
                    }
                    parts = CellUtil.parseColumn((byte[])col);
                    if (parts.length == 1) {
                        delete.addFamily(parts[0], cell.getTimestamp());
                        continue;
                    }
                    if (parts.length == 2) {
                        delete.addColumn(parts[0], parts[1], cell.getTimestamp());
                        continue;
                    }
                    this.servlet.getMetrics().incrementFailedDeleteRequests(1);
                    Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column to delete incorrectly specified.\r\n").build();
                    return response;
                }
            }
            if ((parts = CellUtil.parseColumn((byte[])valueToDeleteColumn)).length == 2) {
                if (parts[1].length != 0) {
                    if (cellModelCount == 1) {
                        delete.addColumns(parts[0], parts[1]);
                    }
                    retValue = table.checkAndMutate(key, parts[0]).qualifier(parts[1]).ifEquals(valueToDeleteCell.getValue()).thenDelete(delete);
                } else {
                    if (cellModelCount == 1) {
                        delete.addColumns(parts[0], Bytes.toBytes((String)""));
                    }
                    retValue = table.checkAndMutate(key, parts[0]).ifEquals(valueToDeleteCell.getValue()).thenDelete(delete);
                }
            } else {
                this.servlet.getMetrics().incrementFailedDeleteRequests(1);
                Response i = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column to check incorrectly specified.\r\n").build();
                return i;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("CHECK-AND-DELETE " + delete.toString() + ", returns " + retValue);
            }
            if (!retValue) {
                this.servlet.getMetrics().incrementFailedDeleteRequests(1);
                Response i = Response.status((Response.Status)Response.Status.NOT_MODIFIED).type("text/plain").entity((Object)" Delete check failed.\r\n").build();
                return i;
            }
            Response.ResponseBuilder response = Response.ok();
            this.servlet.getMetrics().incrementSucessfulDeleteRequests(1);
            Response response2 = response.build();
            return response2;
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            Response response = this.processException(e);
            return response;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {
                    LOG.debug("Exception received while closing the table", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response append(CellSetModel model) {
        Table table = null;
        Append append = null;
        try {
            table = this.servlet.getTable(this.tableResource.getName());
            if (model.getRows().size() != 1) {
                this.servlet.getMetrics().incrementFailedAppendRequests(1);
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Number of rows specified is not 1.\r\n").build();
                return response;
            }
            RowModel rowModel = model.getRows().get(0);
            byte[] key = rowModel.getKey();
            if (key == null) {
                key = this.rowspec.getRow();
            }
            if (key == null) {
                this.servlet.getMetrics().incrementFailedAppendRequests(1);
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Row key found to be null.\r\n").build();
                return response;
            }
            append = new Append(key);
            append.setReturnResults(this.returnResult);
            int i = 0;
            for (CellModel cell : rowModel.getCells()) {
                byte[] col = cell.getColumn();
                if (col == null) {
                    try {
                        col = this.rowspec.getColumns()[i++];
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        col = null;
                    }
                }
                if (col == null) {
                    this.servlet.getMetrics().incrementFailedAppendRequests(1);
                    Response e = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column found to be null.\r\n").build();
                    return e;
                }
                byte[][] parts = CellUtil.parseColumn((byte[])col);
                if (parts.length != 2) {
                    this.servlet.getMetrics().incrementFailedAppendRequests(1);
                    Response ioe = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column incorrectly specified.\r\n").build();
                    return ioe;
                }
                append.add(parts[0], parts[1], cell.getValue());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("APPEND " + append.toString());
            }
            Result result = table.append(append);
            if (this.returnResult) {
                if (result.isEmpty()) {
                    CellModel cell;
                    this.servlet.getMetrics().incrementFailedAppendRequests(1);
                    cell = Response.status((Response.Status)Response.Status.NOT_MODIFIED).type("text/plain").entity((Object)"Append return empty.\r\n").build();
                    return cell;
                }
                CellSetModel rModel = new CellSetModel();
                RowModel rRowModel = new RowModel(result.getRow());
                for (Cell cell : result.listCells()) {
                    rRowModel.addCell(new CellModel(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), cell.getTimestamp(), CellUtil.cloneValue((Cell)cell)));
                }
                rModel.addRow(rRowModel);
                this.servlet.getMetrics().incrementSucessfulAppendRequests(1);
                Response response = Response.ok((Object)rModel).build();
                return response;
            }
            this.servlet.getMetrics().incrementSucessfulAppendRequests(1);
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedAppendRequests(1);
            Response response = this.processException(e);
            return response;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {
                    LOG.debug("Exception received while closing the table" + table.getName(), (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response increment(CellSetModel model) {
        Table table = null;
        Increment increment = null;
        try {
            Object parts;
            table = this.servlet.getTable(this.tableResource.getName());
            if (model.getRows().size() != 1) {
                this.servlet.getMetrics().incrementFailedIncrementRequests(1);
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Number of rows specified is not 1.\r\n").build();
                return response;
            }
            RowModel rowModel = model.getRows().get(0);
            byte[] key = rowModel.getKey();
            if (key == null) {
                key = this.rowspec.getRow();
            }
            if (key == null) {
                this.servlet.getMetrics().incrementFailedIncrementRequests(1);
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Row key found to be null.\r\n").build();
                return response;
            }
            increment = new Increment(key);
            increment.setReturnResults(this.returnResult);
            int i = 0;
            for (CellModel cell : rowModel.getCells()) {
                byte[] col = cell.getColumn();
                if (col == null) {
                    try {
                        col = this.rowspec.getColumns()[i++];
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        col = null;
                    }
                }
                if (col == null) {
                    this.servlet.getMetrics().incrementFailedIncrementRequests(1);
                    Response e = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column found to be null.\r\n").build();
                    return e;
                }
                parts = CellUtil.parseColumn((byte[])col);
                if (((byte[][])parts).length != 2) {
                    this.servlet.getMetrics().incrementFailedIncrementRequests(1);
                    Response ioe = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Bad request: Column incorrectly specified.\r\n").build();
                    return ioe;
                }
                increment.addColumn(parts[0], parts[1], Long.parseLong(Bytes.toStringBinary((byte[])cell.getValue())));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("INCREMENT " + increment.toString());
            }
            Result result = table.increment(increment);
            if (this.returnResult) {
                if (result.isEmpty()) {
                    CellModel cell;
                    this.servlet.getMetrics().incrementFailedIncrementRequests(1);
                    cell = Response.status((Response.Status)Response.Status.NOT_MODIFIED).type("text/plain").entity((Object)"Increment return empty.\r\n").build();
                    return cell;
                }
                CellSetModel rModel = new CellSetModel();
                RowModel rRowModel = new RowModel(result.getRow());
                parts = result.listCells().iterator();
                while (parts.hasNext()) {
                    Cell cell = (Cell)parts.next();
                    rRowModel.addCell(new CellModel(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), cell.getTimestamp(), CellUtil.cloneValue((Cell)cell)));
                }
                rModel.addRow(rowModel);
                this.servlet.getMetrics().incrementSucessfulIncrementRequests(1);
                parts = Response.ok((Object)rModel).build();
                return parts;
            }
            Response.ResponseBuilder response = Response.ok();
            this.servlet.getMetrics().incrementSucessfulIncrementRequests(1);
            Response response2 = response.build();
            return response2;
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedIncrementRequests(1);
            Response response = this.processException(e);
            return response;
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ioe) {
                    LOG.debug("Exception received while closing the table " + table.getName(), (Throwable)ioe);
                }
            }
        }
    }
}

