/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.model.StorageClusterStatusModel;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StorageClusterStatusResource
extends ResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(StorageClusterStatusResource.class);
    static CacheControl cacheControl = new CacheControl();

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            ClusterMetrics status = this.servlet.getAdmin().getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS, ClusterMetrics.Option.DEAD_SERVERS));
            StorageClusterStatusModel model = new StorageClusterStatusModel();
            model.setRegions(status.getRegionCount());
            model.setRequests(status.getRequestCount());
            model.setAverageLoad(status.getAverageLoad());
            for (Map.Entry entry : status.getLiveServerMetrics().entrySet()) {
                ServerName sn = (ServerName)entry.getKey();
                ServerMetrics load = (ServerMetrics)entry.getValue();
                StorageClusterStatusModel.Node node = model.addLiveNode(sn.getHostname() + ":" + Integer.toString(sn.getPort()), sn.getStartcode(), (int)load.getUsedHeapSize().get(Size.Unit.MEGABYTE), (int)load.getMaxHeapSize().get(Size.Unit.MEGABYTE));
                node.setRequests(load.getRequestCount());
                for (RegionMetrics region : load.getRegionMetrics().values()) {
                    node.addRegion(region.getRegionName(), region.getStoreCount(), region.getStoreFileCount(), (int)region.getStoreFileSize().get(Size.Unit.MEGABYTE), (int)region.getMemStoreSize().get(Size.Unit.MEGABYTE), (long)region.getStoreFileIndexSize().get(Size.Unit.KILOBYTE), region.getReadRequestCount(), region.getWriteRequestCount(), (int)region.getStoreFileRootLevelIndexSize().get(Size.Unit.KILOBYTE), (int)region.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE), (int)region.getBloomFilterSize().get(Size.Unit.KILOBYTE), region.getCompactingCellCount(), region.getCompactedCellCount());
                }
            }
            for (ServerName name : status.getDeadServerNames()) {
                model.addDeadNode(name.toString());
            }
            Response.ResponseBuilder response = Response.ok((Object)model);
            response.cacheControl(cacheControl);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

