/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.model.TableRegionModel;
import org.apache.hadoop.hbase.rest.protobuf.generated.TableInfoMessage;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.yetus.audience.InterfaceAudience;

@XmlRootElement(name="TableInfo")
@InterfaceAudience.Private
public class TableInfoModel
implements Serializable,
ProtobufMessageHandler {
    private static final long serialVersionUID = 1L;
    private String name;
    private List<TableRegionModel> regions = new ArrayList<TableRegionModel>();

    public TableInfoModel() {
    }

    public TableInfoModel(String name) {
        this.name = name;
    }

    public void add(TableRegionModel region) {
        this.regions.add(region);
    }

    public TableRegionModel get(int index) {
        return this.regions.get(index);
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @XmlElement(name="Region")
    public List<TableRegionModel> getRegions() {
        return this.regions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRegions(List<TableRegionModel> regions) {
        this.regions = regions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TableRegionModel aRegion : this.regions) {
            sb.append(aRegion.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public byte[] createProtobufOutput() {
        TableInfoMessage.TableInfo.Builder builder = TableInfoMessage.TableInfo.newBuilder();
        builder.setName(this.name);
        for (TableRegionModel aRegion : this.regions) {
            TableInfoMessage.TableInfo.Region.Builder regionBuilder = TableInfoMessage.TableInfo.Region.newBuilder();
            regionBuilder.setName(aRegion.getName());
            regionBuilder.setId(aRegion.getId());
            regionBuilder.setStartKey(ByteStringer.wrap((byte[])aRegion.getStartKey()));
            regionBuilder.setEndKey(ByteStringer.wrap((byte[])aRegion.getEndKey()));
            regionBuilder.setLocation(aRegion.getLocation());
            builder.addRegions(regionBuilder);
        }
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        TableInfoMessage.TableInfo.Builder builder = TableInfoMessage.TableInfo.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])message);
        this.setName(builder.getName());
        for (TableInfoMessage.TableInfo.Region region : builder.getRegionsList()) {
            this.add(new TableRegionModel(builder.getName(), region.getId(), region.getStartKey().toByteArray(), region.getEndKey().toByteArray(), region.getLocation()));
        }
        return this;
    }
}

