/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.File;
import java.net.URL;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.RESTServer;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.token.TokenProvider;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestSecureRESTServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecureRESTServer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSecureRESTServer.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST = new HBaseRESTTestingUtility();
    private static MiniHBaseCluster CLUSTER;
    private static final String HOSTNAME = "localhost";
    private static final String CLIENT_PRINCIPAL = "client";
    private static final String SPNEGO_SERVICE_PRINCIPAL = "HTTP/localhost";
    private static final String REST_SERVER_PRINCIPAL = "rest";
    private static final String SERVICE_PRINCIPAL = "hbase/localhost";
    private static URL baseUrl;
    private static MiniKdc KDC;
    private static RESTServer server;
    private static File restServerKeytab;
    private static File clientKeytab;
    private static File serviceKeytab;

    @BeforeClass
    public static void setupServer() throws Exception {
        File target = new File(System.getProperty("user.dir"), "target");
        Assert.assertTrue((boolean)target.exists());
        File keytabDir = new File(target, TestSecureRESTServer.class.getSimpleName() + "_keytabs");
        if (keytabDir.exists()) {
            FileUtils.deleteDirectory((File)keytabDir);
        }
        keytabDir.mkdirs();
        serviceKeytab = new File(keytabDir, "hbase.service.keytab");
        restServerKeytab = new File(keytabDir, "spnego.keytab");
        clientKeytab = new File(keytabDir, "client.keytab");
        final Configuration conf = TEST_UTIL.getConfiguration();
        KDC = TEST_UTIL.setupMiniKdc(serviceKeytab);
        KDC.createPrincipal(clientKeytab, new String[]{CLIENT_PRINCIPAL});
        KDC.createPrincipal(serviceKeytab, new String[]{SERVICE_PRINCIPAL});
        KDC.createPrincipal(restServerKeytab, new String[]{SPNEGO_SERVICE_PRINCIPAL, REST_SERVER_PRINCIPAL});
        HBaseKerberosUtils.setPrincipalForTesting((String)("hbase/localhost@" + KDC.getRealm()));
        HBaseKerberosUtils.setKeytabFileForTesting((String)serviceKeytab.getAbsolutePath());
        conf.set("hbase.master.keytab.file", serviceKeytab.getAbsolutePath());
        conf.set("hbase.regionserver.hostname", HOSTNAME);
        conf.set("hbase.master.hostname", HOSTNAME);
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)conf, (String)("hbase/localhost@" + KDC.getRealm()), (String)("HTTP/localhost@" + KDC.getRealm()));
        TestSecureRESTServer.setHdfsSecuredConfiguration(conf);
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{TokenProvider.class.getName(), AccessController.class.getName()});
        conf.setStrings("hbase.coprocessor.master.classes", new String[]{AccessController.class.getName()});
        conf.setStrings("hbase.coprocessor.regionserver.classes", new String[]{AccessController.class.getName()});
        conf.setBoolean("hbase.security.exec.permission.checks", true);
        conf.set("hbase.superuser", "hbase");
        conf.set("hadoop.proxyuser.rest.hosts", "*");
        conf.set("hadoop.proxyuser.rest.users", "*");
        UserGroupInformation.setConfiguration((Configuration)conf);
        TestSecureRESTServer.updateKerberosConfiguration(conf, REST_SERVER_PRINCIPAL, SPNEGO_SERVICE_PRINCIPAL, restServerKeytab);
        TEST_UTIL.startMiniCluster(StartMiniClusterOption.builder().numMasters(1).numRegionServers(1).numZkServers(1).build());
        UserGroupInformation restUser = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)REST_SERVER_PRINCIPAL, (String)restServerKeytab.getAbsolutePath());
        restUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                REST_TEST.startServletContainer(conf);
                return null;
            }
        });
        baseUrl = new URL("http://localhost:" + REST_TEST.getServletPort());
        LOG.info("HTTP server started: " + baseUrl);
        TEST_UTIL.waitTableAvailable(TableName.valueOf((String)"hbase:acl"));
        UserGroupInformation superuser = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)SERVICE_PRINCIPAL, (String)serviceKeytab.getAbsolutePath());
        superuser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
                    AccessControlClient.grant((Connection)conn, (String)TestSecureRESTServer.REST_SERVER_PRINCIPAL, (Permission.Action[])new Permission.Action[]{Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE});
                }
                catch (Throwable t) {
                    if (t instanceof Exception) {
                        throw (Exception)t;
                    }
                    throw new Exception(t);
                }
                return null;
            }
        });
    }

    @AfterClass
    public static void stopServer() throws Exception {
        try {
            if (null != server) {
                server.stop();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop info server", (Throwable)e);
        }
        try {
            if (CLUSTER != null) {
                CLUSTER.shutdown();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop HBase cluster", (Throwable)e);
        }
        try {
            if (null != KDC) {
                KDC.stop();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop mini KDC", (Throwable)e);
        }
    }

    private static void setHdfsSecuredConfiguration(Configuration conf) throws Exception {
        conf.set("dfs.namenode.kerberos.principal", "hbase/localhost@" + KDC.getRealm());
        conf.set("dfs.namenode.keytab.file", serviceKeytab.getAbsolutePath());
        conf.set("dfs.datanode.kerberos.principal", "hbase/localhost@" + KDC.getRealm());
        conf.set("dfs.datanode.keytab.file", serviceKeytab.getAbsolutePath());
        conf.set("dfs.web.authentication.kerberos.principal", "HTTP/localhost@" + KDC.getRealm());
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        File keystoresDir = new File(TEST_UTIL.getDataTestDir("keystore").toUri().getPath());
        keystoresDir.mkdirs();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSecureRESTServer.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir.getAbsolutePath(), (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.setBoolean("ignore.secure.ports.for.testing", true);
    }

    private static void updateKerberosConfiguration(Configuration conf, String serverPrincipal, String spnegoPrincipal, File serverKeytab) {
        KerberosName.setRules((String)"DEFAULT");
        conf.set("hbase.security.authentication", "kerberos");
        conf.set("hbase.rest.authentication.type", "kerberos");
        conf.set("hbase.rest.kerberos.principal", serverPrincipal);
        conf.set("hbase.rest.authentication.kerberos.principal", spnegoPrincipal);
        conf.set("hbase.rest.keytab.file", serverKeytab.getAbsolutePath());
        conf.set("hbase.rest.authentication.kerberos.keytab", serverKeytab.getAbsolutePath());
    }

    @Test
    public void testPositiveAuthorization() throws Exception {
        UserGroupInformation superuser = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)SERVICE_PRINCIPAL, (String)serviceKeytab.getAbsolutePath());
        final TableName table = TableName.valueOf((String)"publicTable");
        superuser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
                    TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)table).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f1")).build();
                    conn.getAdmin().createTable(desc);
                    try (Table t = conn.getTable(table);){
                        Put p = new Put(Bytes.toBytes((String)"a"));
                        p.addColumn(Bytes.toBytes((String)"f1"), new byte[0], Bytes.toBytes((String)"1"));
                        t.put(p);
                    }
                    AccessControlClient.grant((Connection)conn, (String)TestSecureRESTServer.CLIENT_PRINCIPAL, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new Exception(e);
                }
                return null;
            }
        });
        Pair<CloseableHttpClient, HttpClientContext> pair = this.getClient();
        final CloseableHttpClient client = (CloseableHttpClient)pair.getFirst();
        final HttpClientContext context = (HttpClientContext)pair.getSecond();
        final HttpGet get = new HttpGet(new URL("http://localhost:" + REST_TEST.getServletPort()).toURI() + "/" + table + "/a");
        get.addHeader("Accept", "application/json");
        UserGroupInformation user = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)CLIENT_PRINCIPAL, (String)clientKeytab.getAbsolutePath());
        String jsonResponse = (String)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)get, (HttpContext)context);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    Assert.assertEquals((String)response.getStatusLine().toString(), (long)200L, (long)statusCode);
                    HttpEntity entity = response.getEntity();
                    String string = EntityUtils.toString((HttpEntity)entity);
                    return string;
                }
            }
        });
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel model = (CellSetModel)mapper.readValue(jsonResponse, CellSetModel.class);
        Assert.assertEquals((long)1L, (long)model.getRows().size());
        RowModel row = (RowModel)model.getRows().get(0);
        Assert.assertEquals((Object)"a", (Object)Bytes.toString((byte[])row.getKey()));
        Assert.assertEquals((long)1L, (long)row.getCells().size());
        CellModel cell = (CellModel)row.getCells().get(0);
        Assert.assertEquals((Object)"1", (Object)Bytes.toString((byte[])cell.getValue()));
    }

    @Test
    public void testNegativeAuthorization() throws Exception {
        Pair<CloseableHttpClient, HttpClientContext> pair = this.getClient();
        final CloseableHttpClient client = (CloseableHttpClient)pair.getFirst();
        final HttpClientContext context = (HttpClientContext)pair.getSecond();
        StringEntity entity = new StringEntity("{\"name\":\"test\", \"ColumnSchema\":[{\"name\":\"f\"}]}", ContentType.APPLICATION_JSON);
        final HttpPut put = new HttpPut("http://localhost:" + REST_TEST.getServletPort() + "/test/schema");
        put.setEntity((HttpEntity)entity);
        UserGroupInformation unprivileged = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)CLIENT_PRINCIPAL, (String)clientKeytab.getAbsolutePath());
        unprivileged.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)put, (HttpContext)context);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    Assert.assertEquals((String)("Got response: " + EntityUtils.toString((HttpEntity)entity)), (long)403L, (long)statusCode);
                }
                return null;
            }
        });
    }

    private Pair<CloseableHttpClient, HttpClientContext> getClient() {
        PoolingHttpClientConnectionManager pool = new PoolingHttpClientConnectionManager();
        HttpHost host = new HttpHost(HOSTNAME, REST_TEST.getServletPort());
        Registry authRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, true)).build();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)EmptyCredentials.INSTANCE);
        BasicAuthCache authCache = new BasicAuthCache();
        CloseableHttpClient client = HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authRegistry).setConnectionManager((HttpClientConnectionManager)pool).build();
        HttpClientContext context = HttpClientContext.create();
        context.setTargetHost(host);
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        context.setAuthSchemeRegistry((Lookup)authRegistry);
        context.setAuthCache((AuthCache)authCache);
        return new Pair((Object)client, (Object)context);
    }

    private static class EmptyCredentials
    implements Credentials {
        public static final EmptyCredentials INSTANCE = new EmptyCredentials();

        private EmptyCredentials() {
        }

        public String getPassword() {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }
    }
}

