/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RestTests.class, MediumTests.class})
public class TestSecurityHeadersFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecurityHeadersFilter.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;

    @After
    public void tearDown() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testDefaultValues() throws Exception {
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        String path = "/version/cluster";
        Response response = client.get(path);
        Assert.assertThat((Object)response.getCode(), (Matcher)IsEqual.equalTo((Object)200));
        Assert.assertThat((String)"Header 'X-Content-Type-Options' is missing from Rest response", (Object)response.getHeader("X-Content-Type-Options"), (Matcher)Is.is((Matcher)CoreMatchers.not((Object)null)));
        Assert.assertThat((String)"Header 'X-Content-Type-Options' has invalid default value", (Object)response.getHeader("X-Content-Type-Options"), (Matcher)IsEqual.equalTo((Object)"nosniff"));
        Assert.assertThat((String)"Header 'X-XSS-Protection' is missing from Rest response", (Object)response.getHeader("X-XSS-Protection"), (Matcher)Is.is((Matcher)CoreMatchers.not((Object)null)));
        Assert.assertThat((String)"Header 'X-XSS-Protection' has invalid default value", (Object)response.getHeader("X-XSS-Protection"), (Matcher)IsEqual.equalTo((Object)"1; mode=block"));
        Assert.assertThat((String)"Header 'Strict-Transport-Security' should be missing from Rest response,but it's present", (Object)response.getHeader("Strict-Transport-Security"), (Matcher)Is.is((Object)null));
        Assert.assertThat((String)"Header 'Content-Security-Policy' should be missing from Rest response,but it's present", (Object)response.getHeader("Content-Security-Policy"), (Matcher)Is.is((Object)null));
    }

    @Test
    public void testHstsAndCspSettings() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.http.filter.hsts.value", "max-age=63072000;includeSubDomains;preload");
        TEST_UTIL.getConfiguration().set("hbase.http.filter.csp.value", "default-src https: data: 'unsafe-inline' 'unsafe-eval'");
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        String path = "/version/cluster";
        Response response = client.get(path);
        Assert.assertThat((Object)response.getCode(), (Matcher)IsEqual.equalTo((Object)200));
        Assert.assertThat((String)"Header 'Strict-Transport-Security' is missing from Rest response", (Object)response.getHeader("Strict-Transport-Security"), (Matcher)Is.is((Matcher)CoreMatchers.not((Object)null)));
        Assert.assertThat((String)"Header 'Strict-Transport-Security' has invalid value", (Object)response.getHeader("Strict-Transport-Security"), (Matcher)IsEqual.equalTo((Object)"max-age=63072000;includeSubDomains;preload"));
        Assert.assertThat((String)"Header 'Content-Security-Policy' is missing from Rest response", (Object)response.getHeader("Content-Security-Policy"), (Matcher)Is.is((Matcher)CoreMatchers.not((Object)null)));
        Assert.assertThat((String)"Header 'Content-Security-Policy' has invalid value", (Object)response.getHeader("Content-Security-Policy"), (Matcher)IsEqual.equalTo((Object)"default-src https: data: 'unsafe-inline' 'unsafe-eval'"));
    }
}

