/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.SAXParserFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.TestScannerResource;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RestTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@Category(value={RestTests.class, MediumTests.class})
public class TestTableScan {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableScan.class);
    private static final TableName TABLE = TableName.valueOf((String)"TestScanResource");
    private static final String CFA = "a";
    private static final String CFB = "b";
    private static final String COLUMN_1 = "a:1";
    private static final String COLUMN_2 = "b:2";
    private static final String COLUMN_EMPTY = "a:";
    private static Client client;
    private static int expectedRows1;
    private static int expectedRows2;
    private static int expectedRows3;
    private static Configuration conf;
    private static final HBaseTestingUtility TEST_UTIL;
    private static final HBaseRESTTestingUtility REST_TEST_UTIL;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.rest.custom.filters", "CustomFilter:" + CustomFilter.class.getName());
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(conf);
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        Admin admin = TEST_UTIL.getAdmin();
        if (!admin.tableExists(TABLE)) {
            HTableDescriptor htd = new HTableDescriptor(TABLE);
            htd.addFamily(new HColumnDescriptor(CFA));
            htd.addFamily(new HColumnDescriptor(CFB));
            admin.createTable((TableDescriptor)htd);
            expectedRows1 = TestScannerResource.insertData(conf, TABLE, COLUMN_1, 1.0);
            expectedRows2 = TestScannerResource.insertData(conf, TABLE, COLUMN_2, 0.5);
            expectedRows3 = TestScannerResource.insertData(conf, TABLE, COLUMN_EMPTY, 1.0);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.getAdmin().disableTable(TABLE);
        TEST_UTIL.getAdmin().deleteTable(TABLE);
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSimpleScannerXML() throws IOException, JAXBException {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("limit=10");
        Response response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CellSetModel.class});
        Unmarshaller ush = ctx.createUnmarshaller();
        CellSetModel model = (CellSetModel)ush.unmarshal(response.getStream());
        int count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)10L, (long)count);
        this.checkRowsNotNull(model);
        builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        model = (CellSetModel)ush.unmarshal(response.getStream());
        count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)expectedRows1, (long)count);
        this.checkRowsNotNull(model);
        builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("startrow=aaa");
        builder.append("&");
        builder.append("endrow=aay");
        response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = (CellSetModel)ush.unmarshal(response.getStream());
        count = TestScannerResource.countCellSet(model);
        RowModel startRow = (RowModel)model.getRows().get(0);
        Assert.assertEquals((Object)"aaa", (Object)Bytes.toString((byte[])startRow.getKey()));
        RowModel endRow = (RowModel)model.getRows().get(model.getRows().size() - 1);
        Assert.assertEquals((Object)"aax", (Object)Bytes.toString((byte[])endRow.getKey()));
        Assert.assertEquals((long)24L, (long)count);
        this.checkRowsNotNull(model);
        builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("startrow=aaa");
        builder.append("&");
        builder.append("limit=15");
        response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        model = (CellSetModel)ush.unmarshal(response.getStream());
        startRow = (RowModel)model.getRows().get(0);
        Assert.assertEquals((Object)"aaa", (Object)Bytes.toString((byte[])startRow.getKey()));
        count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)15L, (long)count);
        this.checkRowsNotNull(model);
    }

    @Test
    public void testSimpleScannerJson() throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("limit=2");
        Response response = client.get("/" + TABLE + builder.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel model = (CellSetModel)mapper.readValue(response.getStream(), CellSetModel.class);
        int count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)2L, (long)count);
        this.checkRowsNotNull(model);
        builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=b:2");
        response = client.get("/" + TABLE + builder.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        model = (CellSetModel)mapper.readValue(response.getStream(), CellSetModel.class);
        count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)expectedRows2, (long)count);
        this.checkRowsNotNull(model);
        builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("startrow=aaa");
        builder.append("&");
        builder.append("endrow=aay");
        response = client.get("/" + TABLE + builder.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = (CellSetModel)mapper.readValue(response.getStream(), CellSetModel.class);
        RowModel startRow = (RowModel)model.getRows().get(0);
        Assert.assertEquals((Object)"aaa", (Object)Bytes.toString((byte[])startRow.getKey()));
        RowModel endRow = (RowModel)model.getRows().get(model.getRows().size() - 1);
        Assert.assertEquals((Object)"aax", (Object)Bytes.toString((byte[])endRow.getKey()));
        count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)24L, (long)count);
        this.checkRowsNotNull(model);
    }

    @Test
    public void testScanUsingListenerUnmarshallerXML() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("limit=10");
        Response response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ClientSideCellSetModel.class, RowModel.class, CellModel.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        final ClientSideCellSetModel.Listener listener = new ClientSideCellSetModel.Listener(){

            @Override
            public void handleRowModel(ClientSideCellSetModel helper, RowModel row) {
                Assert.assertTrue((row.getKey() != null ? 1 : 0) != 0);
                Assert.assertTrue((row.getCells().size() > 0 ? 1 : 0) != 0);
            }
        };
        unmarshaller.setListener(new Unmarshaller.Listener(){

            public void beforeUnmarshal(Object target, Object parent) {
                if (target instanceof ClientSideCellSetModel) {
                    ((ClientSideCellSetModel)target).setCellSetModelListener(listener);
                }
            }

            public void afterUnmarshal(Object target, Object parent) {
                if (target instanceof ClientSideCellSetModel) {
                    ((ClientSideCellSetModel)target).setCellSetModelListener(null);
                }
            }
        });
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XMLReader reader = factory.newSAXParser().getXMLReader();
        reader.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
        Assert.assertFalse((boolean)ClientSideCellSetModel.listenerInvoked);
        reader.parse(new InputSource(response.getStream()));
        Assert.assertTrue((boolean)ClientSideCellSetModel.listenerInvoked);
    }

    @Test
    public void testStreamingJSON() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("startrow=aaa");
        builder.append("&");
        builder.append("endrow=aay");
        Response response = client.get("/" + TABLE + builder.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        int count = 0;
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        JsonFactory jfactory = new JsonFactory((ObjectCodec)mapper);
        JsonParser jParser = jfactory.createJsonParser(response.getStream());
        boolean found = false;
        while (jParser.nextToken() != JsonToken.END_OBJECT) {
            if (jParser.getCurrentToken() == JsonToken.START_OBJECT && found) {
                RowModel row = (RowModel)jParser.readValueAs(RowModel.class);
                Assert.assertNotNull((Object)row.getKey());
                for (int i = 0; i < row.getCells().size(); ++i) {
                    if (count == 0) {
                        Assert.assertEquals((Object)"aaa", (Object)Bytes.toString((byte[])row.getKey()));
                    }
                    if (count == 23) {
                        Assert.assertEquals((Object)"aax", (Object)Bytes.toString((byte[])row.getKey()));
                    }
                    ++count;
                }
                jParser.skipChildren();
                continue;
            }
            found = jParser.getCurrentToken() == JsonToken.START_ARRAY;
        }
        Assert.assertEquals((long)24L, (long)count);
    }

    @Test
    public void testSimpleScannerProtobuf() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("limit=15");
        Response response = client.get("/" + TABLE + builder.toString(), "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        int rowCount = this.readProtobufStream(response.getStream());
        Assert.assertEquals((long)15L, (long)rowCount);
        builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("startrow=aaa");
        builder.append("&");
        builder.append("endrow=aay");
        response = client.get("/" + TABLE + builder.toString(), "application/x-protobuf");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        rowCount = this.readProtobufStream(response.getStream());
        Assert.assertEquals((long)24L, (long)rowCount);
    }

    private void checkRowsNotNull(CellSetModel model) {
        for (RowModel row : model.getRows()) {
            Assert.assertTrue((row.getKey() != null ? 1 : 0) != 0);
            Assert.assertTrue((row.getCells().size() > 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readProtobufStream(InputStream inputStream) throws IOException {
        DataInputStream stream = new DataInputStream(inputStream);
        CellSetModel model = null;
        int rowCount = 0;
        try {
            byte[] lengthBytes;
            int readBytes;
            while ((readBytes = stream.read(lengthBytes = new byte[2])) != -1) {
                Assert.assertEquals((long)2L, (long)readBytes);
                short length = Bytes.toShort((byte[])lengthBytes);
                byte[] cellset = new byte[length];
                stream.read(cellset);
                model = new CellSetModel();
                model.getObjectFromMessage(cellset);
                this.checkRowsNotNull(model);
                rowCount += TestScannerResource.countCellSet(model);
            }
        }
        catch (EOFException exp) {
            exp.printStackTrace();
        }
        finally {
            stream.close();
        }
        return rowCount;
    }

    @Test
    public void testScanningUnknownColumnJson() throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:test");
        Response response = client.get("/" + TABLE + builder.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel model = (CellSetModel)mapper.readValue(response.getStream(), CellSetModel.class);
        int count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testSimpleFilter() throws IOException, JAXBException {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("startrow=aaa");
        builder.append("&");
        builder.append("endrow=aay");
        builder.append("&");
        builder.append("filter=" + URLEncoder.encode("PrefixFilter('aab')", "UTF-8"));
        Response response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CellSetModel.class});
        Unmarshaller ush = ctx.createUnmarshaller();
        CellSetModel model = (CellSetModel)ush.unmarshal(response.getStream());
        int count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((Object)"aab", (Object)new String(((CellModel)((RowModel)model.getRows().get(0)).getCells().get(0)).getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testQualifierAndPrefixFilters() throws IOException, JAXBException {
        StringBuilder builder = new StringBuilder();
        builder.append("/abc*");
        builder.append("?");
        builder.append("filter=" + URLEncoder.encode("QualifierFilter(=,'binary:1')", "UTF-8"));
        Response response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CellSetModel.class});
        Unmarshaller ush = ctx.createUnmarshaller();
        CellSetModel model = (CellSetModel)ush.unmarshal(response.getStream());
        int count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((Object)"abc", (Object)new String(((CellModel)((RowModel)model.getRows().get(0)).getCells().get(0)).getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testCompoundFilter() throws IOException, JAXBException {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("filter=" + URLEncoder.encode("PrefixFilter('abc') AND QualifierFilter(=,'binary:1')", "UTF-8"));
        Response response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CellSetModel.class});
        Unmarshaller ush = ctx.createUnmarshaller();
        CellSetModel model = (CellSetModel)ush.unmarshal(response.getStream());
        int count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((Object)"abc", (Object)new String(((CellModel)((RowModel)model.getRows().get(0)).getCells().get(0)).getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testCustomFilter() throws IOException, JAXBException {
        StringBuilder builder = new StringBuilder();
        builder.append("/a*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("filter=" + URLEncoder.encode("CustomFilter('abc')", "UTF-8"));
        Response response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CellSetModel.class});
        Unmarshaller ush = ctx.createUnmarshaller();
        CellSetModel model = (CellSetModel)ush.unmarshal(response.getStream());
        int count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((Object)"abc", (Object)new String(((CellModel)((RowModel)model.getRows().get(0)).getCells().get(0)).getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testNegativeCustomFilter() throws IOException, JAXBException {
        StringBuilder builder = new StringBuilder();
        builder.append("/b*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("filter=" + URLEncoder.encode("CustomFilter('abc')", "UTF-8"));
        Response response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CellSetModel.class});
        Unmarshaller ush = ctx.createUnmarshaller();
        CellSetModel model = (CellSetModel)ush.unmarshal(response.getStream());
        int count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testReversed() throws IOException, JAXBException {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("startrow=aaa");
        builder.append("&");
        builder.append("endrow=aay");
        Response response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{CellSetModel.class});
        Unmarshaller ush = ctx.createUnmarshaller();
        CellSetModel model = (CellSetModel)ush.unmarshal(response.getStream());
        int count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)24L, (long)count);
        List rowModels = model.getRows().subList(1, count);
        builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("startrow=aay");
        builder.append("&");
        builder.append("endrow=aaa");
        builder.append("&");
        builder.append("reversed=true");
        response = client.get("/" + TABLE + builder.toString(), "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        model = (CellSetModel)ush.unmarshal(response.getStream());
        count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)24L, (long)count);
        List reversedRowModels = model.getRows().subList(1, count);
        Collections.reverse(reversedRowModels);
        Assert.assertEquals((long)rowModels.size(), (long)reversedRowModels.size());
        for (int i = 0; i < rowModels.size(); ++i) {
            RowModel rowModel = (RowModel)rowModels.get(i);
            RowModel reversedRowModel = (RowModel)reversedRowModels.get(i);
            Assert.assertEquals((Object)new String(rowModel.getKey(), "UTF-8"), (Object)new String(reversedRowModel.getKey(), "UTF-8"));
            Assert.assertEquals((Object)new String(((CellModel)rowModel.getCells().get(0)).getValue(), "UTF-8"), (Object)new String(((CellModel)reversedRowModel.getCells().get(0)).getValue(), "UTF-8"));
        }
    }

    @Test
    public void testColumnWithEmptyQualifier() throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:");
        Response response = client.get("/" + TABLE + builder.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        ObjectMapper mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel model = (CellSetModel)mapper.readValue(response.getStream(), CellSetModel.class);
        int count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)expectedRows3, (long)count);
        this.checkRowsNotNull(model);
        RowModel startRow = (RowModel)model.getRows().get(0);
        Assert.assertEquals((Object)"aaa", (Object)Bytes.toString((byte[])startRow.getKey()));
        Assert.assertEquals((long)1L, (long)startRow.getCells().size());
        builder = new StringBuilder();
        builder.append("/*");
        builder.append("?");
        builder.append("column=a:1");
        builder.append("&");
        builder.append("column=a:");
        response = client.get("/" + TABLE + builder.toString(), "application/json");
        Assert.assertEquals((long)200L, (long)response.getCode());
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        mapper = new JacksonJaxbJsonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        model = (CellSetModel)mapper.readValue(response.getStream(), CellSetModel.class);
        count = TestScannerResource.countCellSet(model);
        Assert.assertEquals((long)(expectedRows1 + expectedRows3), (long)count);
        this.checkRowsNotNull(model);
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        REST_TEST_UTIL = new HBaseRESTTestingUtility();
    }

    @XmlRootElement(name="CellSet")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ClientSideCellSetModel
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XmlElement(name="Row")
        private List<RowModel> row;
        static boolean listenerInvoked = false;

        public void setCellSetModelListener(final Listener l) {
            this.row = l == null ? null : new ArrayList<RowModel>(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean add(RowModel o) {
                    l.handleRowModel(this, o);
                    listenerInvoked = true;
                    return false;
                }
            };
        }

        public static interface Listener {
            public void handleRowModel(ClientSideCellSetModel var1, RowModel var2);
        }
    }

    public static class CustomFilter
    extends PrefixFilter {
        private byte[] key = null;

        public CustomFilter(byte[] key) {
            super(key);
        }

        public boolean filterRowKey(byte[] buffer, int offset, int length) {
            int cmp = Bytes.compareTo((byte[])buffer, (int)offset, (int)length, (byte[])this.key, (int)0, (int)this.key.length);
            return cmp != 0;
        }

        public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
            byte[] prefix = ParseFilter.removeQuotesFromByteArray((byte[])filterArguments.get(0));
            return new CustomFilter(prefix);
        }
    }
}

