/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.provider.consumer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Consumes(value={"application/x-protobuf", "application/protobuf"})
@InterfaceAudience.Private
public class ProtobufMessageBodyConsumer
implements MessageBodyReader<ProtobufMessageHandler> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufMessageBodyConsumer.class);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ProtobufMessageHandler.class.isAssignableFrom(type);
    }

    public ProtobufMessageHandler readFrom(Class<ProtobufMessageHandler> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException, WebApplicationException {
        ProtobufMessageHandler obj = null;
        try {
            int read;
            obj = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            do {
                if ((read = inputStream.read(buffer, 0, buffer.length)) <= 0) continue;
                baos.write(buffer, 0, read);
            } while (read > 0);
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.getClass() + ": read " + baos.size() + " bytes from " + inputStream);
            }
            obj = obj.getObjectFromMessage(baos.toByteArray());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return obj;
    }
}

