/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupableBalancer;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.LinkedListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RSGroupBasedLoadBalancer
implements RSGroupableBalancer {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupBasedLoadBalancer.class);
    private Configuration config;
    private ClusterMetrics clusterStatus;
    private MasterServices masterServices;
    private volatile RSGroupInfoManager rsGroupInfoManager;
    private LoadBalancer internalBalancer;

    @InterfaceAudience.Private
    public RSGroupBasedLoadBalancer() {
    }

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public void setClusterMetrics(ClusterMetrics sm) {
        this.clusterStatus = sm;
    }

    public void setMasterServices(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    public List<RegionPlan> balanceCluster(TableName tableName, Map<ServerName, List<RegionInfo>> clusterState) throws HBaseIOException {
        return this.balanceCluster(clusterState);
    }

    public List<RegionPlan> balanceCluster(Map<ServerName, List<RegionInfo>> clusterState) throws HBaseIOException {
        if (!this.isOnline()) {
            throw new ConstraintException(RSGroupInfoManager.RSGROUP_TABLE_NAME + " is not online, unable to perform balance");
        }
        Map<ServerName, List<RegionInfo>> correctedState = this.correctAssignments(clusterState);
        ArrayList<RegionPlan> regionPlans = new ArrayList<RegionPlan>();
        List<RegionInfo> misplacedRegions = correctedState.get(LoadBalancer.BOGUS_SERVER_NAME);
        for (RegionInfo regionInfo : misplacedRegions) {
            ServerName serverName = this.findServerForRegion(clusterState, regionInfo);
            regionPlans.add(new RegionPlan(regionInfo, serverName, null));
        }
        try {
            HashSet<ServerName> processedServers = new HashSet<ServerName>();
            for (RSGroupInfo rsgroup : this.rsGroupInfoManager.listRSGroups()) {
                HashMap<ServerName, List<RegionInfo>> groupClusterState = new HashMap<ServerName, List<RegionInfo>>();
                HashMap<TableName, HashMap<ServerName, List<RegionInfo>>> groupClusterLoad = new HashMap<TableName, HashMap<ServerName, List<RegionInfo>>>();
                for (ServerName server : clusterState.keySet()) {
                    if (processedServers.contains(server) || !rsgroup.containsServer(server.getAddress())) continue;
                    List<RegionInfo> regionsOnServer = correctedState.get(server);
                    groupClusterState.put(server, regionsOnServer);
                    processedServers.add(server);
                }
                groupClusterLoad.put(HConstants.ENSEMBLE_TABLE_NAME, groupClusterState);
                this.internalBalancer.setClusterLoad(groupClusterLoad);
                List groupPlans = this.internalBalancer.balanceCluster(groupClusterState);
                if (groupPlans == null) continue;
                regionPlans.addAll(groupPlans);
            }
        }
        catch (IOException exp) {
            LOG.warn("Exception while balancing cluster.", (Throwable)exp);
            regionPlans.clear();
        }
        return regionPlans;
    }

    public Map<ServerName, List<RegionInfo>> roundRobinAssignment(List<RegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        HashMap assignments = Maps.newHashMap();
        ArrayListMultimap regionMap = ArrayListMultimap.create();
        ArrayListMultimap serverMap = ArrayListMultimap.create();
        this.generateGroupMaps(regions, servers, (ListMultimap<String, RegionInfo>)regionMap, (ListMultimap<String, ServerName>)serverMap);
        for (String groupKey : regionMap.keySet()) {
            Map result;
            if (regionMap.get((Object)groupKey).size() <= 0 || (result = this.internalBalancer.roundRobinAssignment(regionMap.get((Object)groupKey), serverMap.get((Object)groupKey))) == null) continue;
            if (result.containsKey(LoadBalancer.BOGUS_SERVER_NAME) && assignments.containsKey(LoadBalancer.BOGUS_SERVER_NAME)) {
                ((List)assignments.get(LoadBalancer.BOGUS_SERVER_NAME)).addAll((Collection)result.get(LoadBalancer.BOGUS_SERVER_NAME));
                continue;
            }
            assignments.putAll(result);
        }
        return assignments;
    }

    public Map<ServerName, List<RegionInfo>> retainAssignment(Map<RegionInfo, ServerName> regions, List<ServerName> servers) throws HBaseIOException {
        try {
            String groupName;
            TreeMap<ServerName, List<RegionInfo>> assignments = new TreeMap<ServerName, List<RegionInfo>>();
            ArrayListMultimap groupToRegion = ArrayListMultimap.create();
            Set<RegionInfo> misplacedRegions = this.getMisplacedRegions(regions);
            for (RegionInfo region : regions.keySet()) {
                if (misplacedRegions.contains(region)) continue;
                groupName = this.rsGroupInfoManager.getRSGroupOfTable(region.getTable());
                if (groupName == null) {
                    LOG.info("Group not found for table " + region.getTable() + ", using default");
                    groupName = "default";
                }
                groupToRegion.put((Object)groupName, (Object)region);
            }
            for (String key : groupToRegion.keySet()) {
                TreeMap<RegionInfo, ServerName> currentAssignmentMap = new TreeMap<RegionInfo, ServerName>();
                List regionList = groupToRegion.get((Object)key);
                RSGroupInfo info = this.rsGroupInfoManager.getRSGroup(key);
                List<ServerName> candidateList = this.filterOfflineServers(info, servers);
                for (RegionInfo region : regionList) {
                    currentAssignmentMap.put(region, regions.get(region));
                }
                if (candidateList.size() <= 0) continue;
                assignments.putAll(this.internalBalancer.retainAssignment(currentAssignmentMap, candidateList));
            }
            for (RegionInfo region : misplacedRegions) {
                RSGroupInfo info;
                List<ServerName> candidateList;
                ServerName server;
                groupName = this.rsGroupInfoManager.getRSGroupOfTable(region.getTable());
                if (groupName == null) {
                    LOG.info("Group not found for table " + region.getTable() + ", using default");
                    groupName = "default";
                }
                if ((server = this.internalBalancer.randomAssignment(region, candidateList = this.filterOfflineServers(info = this.rsGroupInfoManager.getRSGroup(groupName), servers))) != null) {
                    if (!assignments.containsKey(server)) {
                        assignments.put(server, new ArrayList());
                    }
                    ((List)assignments.get(server)).add(region);
                    continue;
                }
                if (!assignments.containsKey(LoadBalancer.BOGUS_SERVER_NAME)) {
                    assignments.put(LoadBalancer.BOGUS_SERVER_NAME, new ArrayList());
                }
                ((List)assignments.get(LoadBalancer.BOGUS_SERVER_NAME)).add(region);
            }
            return assignments;
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to do online retain assignment", (Throwable)e);
        }
    }

    public ServerName randomAssignment(RegionInfo region, List<ServerName> servers) throws HBaseIOException {
        LinkedListMultimap regionMap = LinkedListMultimap.create();
        LinkedListMultimap serverMap = LinkedListMultimap.create();
        this.generateGroupMaps(Lists.newArrayList((Object[])new RegionInfo[]{region}), servers, (ListMultimap<String, RegionInfo>)regionMap, (ListMultimap<String, ServerName>)serverMap);
        List filteredServers = serverMap.get(regionMap.keySet().iterator().next());
        return this.internalBalancer.randomAssignment(region, filteredServers);
    }

    private void generateGroupMaps(List<RegionInfo> regions, List<ServerName> servers, ListMultimap<String, RegionInfo> regionMap, ListMultimap<String, ServerName> serverMap) throws HBaseIOException {
        try {
            for (RegionInfo region : regions) {
                String groupName = this.rsGroupInfoManager.getRSGroupOfTable(region.getTable());
                if (groupName == null) {
                    LOG.info("Group not found for table " + region.getTable() + ", using default");
                    groupName = "default";
                }
                regionMap.put((Object)groupName, (Object)region);
            }
            for (String groupKey : regionMap.keySet()) {
                RSGroupInfo info = this.rsGroupInfoManager.getRSGroup(groupKey);
                serverMap.putAll((Object)groupKey, this.filterOfflineServers(info, servers));
                if (serverMap.get((Object)groupKey).size() >= 1) continue;
                serverMap.put((Object)groupKey, (Object)LoadBalancer.BOGUS_SERVER_NAME);
            }
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to generate group maps", (Throwable)e);
        }
    }

    private List<ServerName> filterOfflineServers(RSGroupInfo RSGroupInfo2, List<ServerName> onlineServers) {
        if (RSGroupInfo2 != null) {
            return this.filterServers(RSGroupInfo2.getServers(), onlineServers);
        }
        LOG.warn("RSGroup Information found to be null. Some regions might be unassigned.");
        return Collections.EMPTY_LIST;
    }

    private List<ServerName> filterServers(Set<Address> servers, List<ServerName> onlineServers) {
        ArrayList<ServerName> finalList = new ArrayList<ServerName>();
        for (ServerName onlineServer : onlineServers) {
            if (!servers.contains(onlineServer.getAddress())) continue;
            finalList.add(onlineServer);
        }
        return finalList;
    }

    @VisibleForTesting
    public Set<RegionInfo> getMisplacedRegions(Map<RegionInfo, ServerName> regions) throws IOException {
        HashSet<RegionInfo> misplacedRegions = new HashSet<RegionInfo>();
        for (Map.Entry<RegionInfo, ServerName> region : regions.entrySet()) {
            RegionInfo regionInfo = region.getKey();
            ServerName assignedServer = region.getValue();
            String groupName = this.rsGroupInfoManager.getRSGroupOfTable(regionInfo.getTable());
            if (groupName == null) {
                LOG.info("Group not found for table " + regionInfo.getTable() + ", using default");
                groupName = "default";
            }
            RSGroupInfo info = this.rsGroupInfoManager.getRSGroup(groupName);
            if (assignedServer == null) {
                LOG.debug("There is no assigned server for {}", region);
                continue;
            }
            RSGroupInfo otherInfo = this.rsGroupInfoManager.getRSGroupOfServer(assignedServer.getAddress());
            if (info == null && otherInfo == null) {
                LOG.warn("Couldn't obtain rs group information for {} on {}", region, (Object)assignedServer);
                continue;
            }
            if (info != null && info.containsServer(assignedServer.getAddress())) continue;
            LOG.debug("Found misplaced region: " + regionInfo.getRegionNameAsString() + " on server: " + assignedServer + " found in group: " + otherInfo + " outside of group: " + (info == null ? "UNKNOWN" : info.getName()));
            misplacedRegions.add(regionInfo);
        }
        return misplacedRegions;
    }

    private ServerName findServerForRegion(Map<ServerName, List<RegionInfo>> existingAssignments, RegionInfo region) {
        for (Map.Entry<ServerName, List<RegionInfo>> entry : existingAssignments.entrySet()) {
            if (!entry.getValue().contains(region)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Could not find server for region " + region.getShortNameToLog());
    }

    private Map<ServerName, List<RegionInfo>> correctAssignments(Map<ServerName, List<RegionInfo>> existingAssignments) throws HBaseIOException {
        TreeMap<ServerName, List<RegionInfo>> correctAssignments = new TreeMap<ServerName, List<RegionInfo>>();
        correctAssignments.put(LoadBalancer.BOGUS_SERVER_NAME, new LinkedList());
        for (Map.Entry<ServerName, List<RegionInfo>> assignments : existingAssignments.entrySet()) {
            ServerName sName = assignments.getKey();
            correctAssignments.put(sName, new LinkedList());
            List<RegionInfo> regions = assignments.getValue();
            for (RegionInfo region : regions) {
                RSGroupInfo targetRSGInfo = null;
                try {
                    String groupName = this.rsGroupInfoManager.getRSGroupOfTable(region.getTable());
                    if (groupName == null) {
                        LOG.info("Group not found for table " + region.getTable() + ", using default");
                        groupName = "default";
                    }
                    targetRSGInfo = this.rsGroupInfoManager.getRSGroup(groupName);
                }
                catch (IOException exp) {
                    LOG.debug("RSGroup information null for region of table " + region.getTable(), (Throwable)exp);
                }
                if (targetRSGInfo == null || !targetRSGInfo.containsServer(sName.getAddress())) {
                    ((List)correctAssignments.get(LoadBalancer.BOGUS_SERVER_NAME)).add(region);
                    continue;
                }
                ((List)correctAssignments.get(sName)).add(region);
            }
        }
        return correctAssignments;
    }

    public void initialize() throws HBaseIOException {
        try {
            if (this.rsGroupInfoManager == null) {
                List cps = this.masterServices.getMasterCoprocessorHost().findCoprocessors(RSGroupAdminEndpoint.class);
                if (cps.size() != 1) {
                    String msg = "Expected one implementation of GroupAdminEndpoint but found " + cps.size();
                    LOG.error(msg);
                    throw new HBaseIOException(msg);
                }
                this.rsGroupInfoManager = ((RSGroupAdminEndpoint)cps.get(0)).getGroupInfoManager();
                if (this.rsGroupInfoManager == null) {
                    String msg = "RSGroupInfoManager hasn't been initialized";
                    LOG.error(msg);
                    throw new HBaseIOException(msg);
                }
                this.rsGroupInfoManager.start();
            }
        }
        catch (IOException e) {
            throw new HBaseIOException("Failed to initialize GroupInfoManagerImpl", (Throwable)e);
        }
        Class balancerKlass = this.config.getClass("hbase.rsgroup.grouploadbalancer.class", StochasticLoadBalancer.class, LoadBalancer.class);
        this.internalBalancer = (LoadBalancer)ReflectionUtils.newInstance((Class)balancerKlass, (Configuration)this.config);
        this.internalBalancer.setMasterServices(this.masterServices);
        this.internalBalancer.setClusterMetrics(this.clusterStatus);
        this.internalBalancer.setConf(this.config);
        this.internalBalancer.initialize();
    }

    public boolean isOnline() {
        if (this.rsGroupInfoManager == null) {
            return false;
        }
        return this.rsGroupInfoManager.isOnline();
    }

    public void setClusterLoad(Map<TableName, Map<ServerName, List<RegionInfo>>> clusterLoad) {
    }

    public void regionOnline(RegionInfo regionInfo, ServerName sn) {
    }

    public void regionOffline(RegionInfo regionInfo) {
    }

    public void onConfigurationChange(Configuration conf) {
    }

    public void stop(String why) {
    }

    public boolean isStopped() {
        return false;
    }

    @VisibleForTesting
    public void setRsGroupInfoManager(RSGroupInfoManager rsGroupInfoManager) {
        this.rsGroupInfoManager = rsGroupInfoManager;
    }

    public void postMasterStartupInitialize() {
        this.internalBalancer.postMasterStartupInitialize();
    }

    public void updateBalancerStatus(boolean status) {
        this.internalBalancer.updateBalancerStatus(status);
    }
}

