/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupAdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdmin;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupProtobufUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RSGroupAdminClient
implements RSGroupAdmin {
    private RSGroupAdminProtos.RSGroupAdminService.BlockingInterface stub;
    private Admin admin;

    public RSGroupAdminClient(Connection conn) throws IOException {
        this.admin = conn.getAdmin();
        this.stub = RSGroupAdminProtos.RSGroupAdminService.newBlockingStub((BlockingRpcChannel)this.admin.coprocessorService());
    }

    @Override
    public RSGroupInfo getRSGroupInfo(String groupName) throws IOException {
        try {
            RSGroupAdminProtos.GetRSGroupInfoResponse resp = this.stub.getRSGroupInfo(null, RSGroupAdminProtos.GetRSGroupInfoRequest.newBuilder().setRSGroupName(groupName).build());
            if (resp.hasRSGroupInfo()) {
                return RSGroupProtobufUtil.toGroupInfo(resp.getRSGroupInfo());
            }
            return null;
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    @Override
    public RSGroupInfo getRSGroupInfoOfTable(TableName tableName) throws IOException {
        RSGroupAdminProtos.GetRSGroupInfoOfTableRequest request = RSGroupAdminProtos.GetRSGroupInfoOfTableRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)tableName)).build();
        try {
            RSGroupAdminProtos.GetRSGroupInfoOfTableResponse resp = this.stub.getRSGroupInfoOfTable(null, request);
            if (resp.hasRSGroupInfo()) {
                return RSGroupProtobufUtil.toGroupInfo(resp.getRSGroupInfo());
            }
            return null;
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    @Override
    public void moveServers(Set<Address> servers, String targetGroup) throws IOException {
        HashSet hostPorts = Sets.newHashSet();
        for (Address el : servers) {
            hostPorts.add(HBaseProtos.ServerName.newBuilder().setHostName(el.getHostname()).setPort(el.getPort()).build());
        }
        RSGroupAdminProtos.MoveServersRequest request = RSGroupAdminProtos.MoveServersRequest.newBuilder().setTargetGroup(targetGroup).addAllServers(hostPorts).build();
        try {
            this.stub.moveServers(null, request);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    @Override
    public void moveTables(Set<TableName> tables, String targetGroup) throws IOException {
        RSGroupAdminProtos.MoveTablesRequest.Builder builder = RSGroupAdminProtos.MoveTablesRequest.newBuilder().setTargetGroup(targetGroup);
        for (TableName tableName : tables) {
            builder.addTableName(ProtobufUtil.toProtoTableName((TableName)tableName));
            if (this.admin.tableExists(tableName)) continue;
            throw new TableNotFoundException(tableName);
        }
        try {
            this.stub.moveTables(null, builder.build());
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    @Override
    public void addRSGroup(String groupName) throws IOException {
        RSGroupAdminProtos.AddRSGroupRequest request = RSGroupAdminProtos.AddRSGroupRequest.newBuilder().setRSGroupName(groupName).build();
        try {
            this.stub.addRSGroup(null, request);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    @Override
    public void removeRSGroup(String name) throws IOException {
        RSGroupAdminProtos.RemoveRSGroupRequest request = RSGroupAdminProtos.RemoveRSGroupRequest.newBuilder().setRSGroupName(name).build();
        try {
            this.stub.removeRSGroup(null, request);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    @Override
    public boolean balanceRSGroup(String groupName) throws IOException {
        RSGroupAdminProtos.BalanceRSGroupRequest request = RSGroupAdminProtos.BalanceRSGroupRequest.newBuilder().setRSGroupName(groupName).build();
        try {
            return this.stub.balanceRSGroup(null, request).getBalanceRan();
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    @Override
    public List<RSGroupInfo> listRSGroups() throws IOException {
        try {
            List<RSGroupProtos.RSGroupInfo> resp = this.stub.listRSGroupInfos(null, RSGroupAdminProtos.ListRSGroupInfosRequest.getDefaultInstance()).getRSGroupInfoList();
            ArrayList<RSGroupInfo> result = new ArrayList<RSGroupInfo>(resp.size());
            for (RSGroupProtos.RSGroupInfo entry : resp) {
                result.add(RSGroupProtobufUtil.toGroupInfo(entry));
            }
            return result;
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    @Override
    public RSGroupInfo getRSGroupOfServer(Address hostPort) throws IOException {
        RSGroupAdminProtos.GetRSGroupInfoOfServerRequest request = RSGroupAdminProtos.GetRSGroupInfoOfServerRequest.newBuilder().setServer(HBaseProtos.ServerName.newBuilder().setHostName(hostPort.getHostname()).setPort(hostPort.getPort()).build()).build();
        try {
            RSGroupAdminProtos.GetRSGroupInfoOfServerResponse resp = this.stub.getRSGroupInfoOfServer(null, request);
            if (resp.hasRSGroupInfo()) {
                return RSGroupProtobufUtil.toGroupInfo(resp.getRSGroupInfo());
            }
            return null;
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    @Override
    public void moveServersAndTables(Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
        RSGroupAdminProtos.MoveServersAndTablesRequest.Builder builder = RSGroupAdminProtos.MoveServersAndTablesRequest.newBuilder().setTargetGroup(targetGroup);
        for (Address el : servers) {
            builder.addServers(HBaseProtos.ServerName.newBuilder().setHostName(el.getHostname()).setPort(el.getPort()).build());
        }
        for (TableName tableName : tables) {
            builder.addTableName(ProtobufUtil.toProtoTableName((TableName)tableName));
            if (this.admin.tableExists(tableName)) continue;
            throw new TableNotFoundException(tableName);
        }
        try {
            this.stub.moveServersAndTables(null, builder.build());
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }

    @Override
    public void removeServers(Set<Address> servers) throws IOException {
        HashSet hostPorts = Sets.newHashSet();
        for (Address el : servers) {
            hostPorts.add(HBaseProtos.ServerName.newBuilder().setHostName(el.getHostname()).setPort(el.getPort()).build());
        }
        RSGroupAdminProtos.RemoveServersRequest request = RSGroupAdminProtos.RemoveServersRequest.newBuilder().addAllServers(hostPorts).build();
        try {
            this.stub.removeServers(null, request);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException((Exception)((Object)e));
        }
    }
}

