/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import ch.cern.hbase.thirdparty.com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Version;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestRSGroupsKillRS
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsKillRS.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsKillRS.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsKillRS.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsKillRS.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testKillRS() throws Exception {
        RSGroupInfo appInfo = this.addGroup("appInfo", 1);
        TableName tableName = TableName.valueOf((String)"Group_ns", (String)this.name.getMethodName());
        admin.createNamespace(NamespaceDescriptor.create((String)tableName.getNamespaceAsString()).addConfiguration("hbase.rsgroup.name", appInfo.getName()).build());
        final TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f")).build();
        admin.createTable(desc);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsKillRS.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
        final ServerName targetServer = this.getServerName((Address)appInfo.getServers().iterator().next());
        Assert.assertEquals((long)1L, (long)admin.getRegions(targetServer).size());
        try {
            admin.stopRegionServer(targetServer.getAddress().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !TestRSGroupsBase.cluster.getClusterMetrics().getLiveServerMetrics().containsKey(targetServer);
            }
        });
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !TestRSGroupsBase.cluster.getClusterMetrics().getRegionStatesInTransition().isEmpty();
            }
        });
        HashSet newServers = Sets.newHashSet();
        newServers.add(rsGroupAdmin.getRSGroupInfo("default").getServers().iterator().next());
        rsGroupAdmin.moveServers((Set)newServers, appInfo.getName());
        admin.disableTable(tableName);
        admin.enableTable(tableName);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.cluster.getClusterMetrics().getRegionStatesInTransition().isEmpty();
            }
        });
        ServerName targetServer1 = this.getServerName((Address)newServers.iterator().next());
        Assert.assertEquals((long)1L, (long)admin.getRegions(targetServer1).size());
        Assert.assertEquals((Object)tableName, (Object)((RegionInfo)admin.getRegions(targetServer1).get(0)).getTable());
    }

    @Test
    public void testKillAllRSInGroup() throws Exception {
        String groupName = "my_group";
        int groupRSCount = 2;
        this.addGroup(groupName, groupRSCount);
        Table t = TEST_UTIL.createMultiRegionTable(this.tableName, Bytes.toBytes((String)"f"), 5);
        TEST_UTIL.loadTable(t, Bytes.toBytes((String)"f"));
        HashSet<TableName> toAddTables = new HashSet<TableName>();
        toAddTables.add(this.tableName);
        rsGroupAdmin.moveTables(toAddTables, groupName);
        Assert.assertTrue((boolean)rsGroupAdmin.getRSGroupInfo(groupName).getTables().contains(this.tableName));
        TEST_UTIL.waitTableAvailable(this.tableName, 30000L);
        Set servers = rsGroupAdmin.getRSGroupInfo(groupName).getServers();
        Assert.assertEquals((long)2L, (long)servers.size());
        LOG.debug("group servers {}", (Object)servers);
        for (Object tr : master.getAssignmentManager().getRegionStates().getRegionsOfTable(this.tableName)) {
            Assert.assertTrue((boolean)servers.contains(((ServerName)master.getAssignmentManager().getRegionStates().getRegionAssignments().get(tr)).getAddress()));
        }
        ArrayList<ServerName> gsn = new ArrayList<ServerName>();
        for (Address address : servers) {
            gsn.add(this.getServerName(address));
        }
        Assert.assertEquals((long)2L, (long)gsn.size());
        for (Map.Entry entry : master.getAssignmentManager().getRegionStates().getRegionAssignments().entrySet()) {
            if (!((RegionInfo)entry.getKey()).getTable().equals((Object)this.tableName)) continue;
            LOG.debug("move region {} from {} to {}", new Object[]{((RegionInfo)entry.getKey()).getRegionNameAsString(), entry.getValue(), gsn.get(1 - gsn.indexOf(entry.getValue()))});
            TEST_UTIL.moveRegionAndWait((RegionInfo)entry.getKey(), (ServerName)gsn.get(1 - gsn.indexOf(entry.getValue())));
            break;
        }
        TEST_UTIL.waitTableAvailable(this.tableName, 30000L);
        for (Address address : rsGroupAdmin.getRSGroupInfo(groupName).getServers()) {
            TEST_UTIL.getMiniHBaseCluster().stopRegionServer(this.getServerName(address));
        }
        Threads.sleep((long)10000L);
        Assert.assertEquals((long)(4 - gsn.size()), (long)TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size());
        TEST_UTIL.getMiniHBaseCluster().startRegionServer(((ServerName)gsn.get(0)).getHostname(), ((ServerName)gsn.get(0)).getPort());
        Assert.assertEquals((long)(4 - gsn.size() + 1), (long)TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size());
        TEST_UTIL.waitTableAvailable(this.tableName, 30000L);
        for (JVMClusterUtil.RegionServerThread regionServerThread : TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads()) {
            if (!regionServerThread.getRegionServer().getServerName().getAddress().equals((Object)((ServerName)gsn.get(0)).getAddress())) continue;
            TEST_UTIL.getMiniHBaseCluster().stopRegionServer(regionServerThread.getRegionServer().getServerName());
            break;
        }
        Threads.sleep((long)10000L);
        Assert.assertEquals((long)(4 - gsn.size()), (long)TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size());
        ServerName newServer = (ServerName)master.getServerManager().getOnlineServersList().get(0);
        rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{newServer.getAddress()}), groupName);
        TEST_UTIL.waitTableAvailable(this.tableName, 30000L);
    }

    @Test
    public void testLowerMetaGroupVersion() throws Exception {
        String groupName = "meta_group";
        int groupRSCount = 1;
        this.addGroup(groupName, groupRSCount);
        HashSet<TableName> toAddTables = new HashSet<TableName>();
        toAddTables.add(TableName.META_TABLE_NAME);
        rsGroupAdmin.moveTables(toAddTables, groupName);
        Assert.assertTrue((boolean)rsGroupAdmin.getRSGroupInfo(groupName).getTables().contains(TableName.META_TABLE_NAME));
        String originVersion = "";
        HashSet<Address> servers = new HashSet<Address>();
        for (Address addr : rsGroupAdmin.getRSGroupInfo(groupName).getServers()) {
            servers.add(addr);
            TEST_UTIL.getMiniHBaseCluster().stopRegionServer(this.getServerName(addr));
            originVersion = master.getRegionServerVersion(this.getServerName(addr));
        }
        Threads.sleep((long)10000L);
        Assert.assertEquals((long)(4 - groupRSCount), (long)TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size());
        Address address = (Address)servers.iterator().next();
        int majorVersion = VersionInfo.getMajorVersion((String)originVersion);
        Assert.assertTrue((majorVersion >= 1 ? 1 : 0) != 0);
        String lowerVersion = String.valueOf(majorVersion - 1) + originVersion.split("\\.")[1];
        TestRSGroupsKillRS.setFinalStatic(Version.class.getField("version"), lowerVersion);
        TEST_UTIL.getMiniHBaseCluster().startRegionServer(address.getHostname(), address.getPort());
        Assert.assertEquals((long)4L, (long)TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size());
        Assert.assertTrue((VersionInfo.compareVersion((String)originVersion, (String)master.getRegionServerVersion(this.getServerName((Address)servers.iterator().next()))) > 0 ? 1 : 0) != 0);
        LOG.debug("wait for META assigned...");
        TEST_UTIL.waitFor(60000L, () -> !TEST_UTIL.getHBaseCluster().getMaster().getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).findAny().isPresent());
    }

    private static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }
}

