/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AcidGuaranteesTestTool
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(AcidGuaranteesTestTool.class);
    public static final TableName TABLE_NAME = TableName.valueOf((String)"TestAcidGuarantees");
    public static final byte[] FAMILY_A = Bytes.toBytes((String)"A");
    public static final byte[] FAMILY_B = Bytes.toBytes((String)"B");
    public static final byte[] FAMILY_C = Bytes.toBytes((String)"C");
    public static final byte[] QUALIFIER_NAME = Bytes.toBytes((String)"data");
    public static final byte[][] FAMILIES = new byte[][]{FAMILY_A, FAMILY_B, FAMILY_C};
    public static int NUM_COLS_TO_CHECK = 50;
    private ExecutorService sharedPool;
    private long millisToRun;
    private int numWriters;
    private int numGetters;
    private int numScanners;
    private int numUniqueRows;
    private boolean crazyFlush;
    private boolean useMob;

    private ExecutorService createThreadPool() {
        int maxThreads = 256;
        int coreThreads = 128;
        long keepAliveTime = 60L;
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * 100);
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory((String)(((Object)((Object)this)).toString() + "-shared")));
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    protected void addOptions() {
        this.addOptWithArg("millis", "time limit in milliseconds");
        this.addOptWithArg("numWriters", "number of write threads");
        this.addOptWithArg("numGetters", "number of get threads");
        this.addOptWithArg("numScanners", "number of scan threads");
        this.addOptWithArg("numUniqueRows", "number of unique rows to test");
        this.addOptNoArg("crazyFlush", "if specified we will flush continuously otherwise will flush every minute");
        this.addOptNoArg("useMob", "if specified we will enable mob on the first column family");
    }

    protected void processOptions(CommandLine cmd) {
        this.millisToRun = this.getOptionAsLong(cmd, "millis", 5000);
        this.numWriters = this.getOptionAsInt(cmd, "numWriters", 50);
        this.numGetters = this.getOptionAsInt(cmd, "numGetters", 2);
        this.numScanners = this.getOptionAsInt(cmd, "numScanners", 2);
        this.numUniqueRows = this.getOptionAsInt(cmd, "numUniqueRows", 3);
        this.crazyFlush = cmd.hasOption("crazyFlush");
        this.useMob = cmd.hasOption("useMob");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doWork() throws Exception {
        this.sharedPool = this.createThreadPool();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());){
            this.runTestAtomicity(conn.getAdmin());
        }
        finally {
            this.sharedPool.shutdown();
        }
        return 0;
    }

    private void createTableIfMissing(Admin admin, boolean useMob) throws IOException {
        ColumnFamilyDescriptor cfd;
        if (!admin.tableExists(TABLE_NAME)) {
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME);
            Stream.of(FAMILIES).map(ColumnFamilyDescriptorBuilder::of).forEachOrdered(arg_0 -> ((TableDescriptorBuilder)builder).setColumnFamily(arg_0));
            admin.createTable(builder.build());
        }
        if ((cfd = admin.getDescriptor(TABLE_NAME).getColumnFamilies()[0]).isMobEnabled() != useMob) {
            admin.modifyColumnFamily(TABLE_NAME, ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfd).setMobEnabled(useMob).setMobThreshold(4L).build());
        }
    }

    private void runTestAtomicity(final Admin admin) throws Exception {
        this.createTableIfMissing(admin, this.useMob);
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(this.conf);
        byte[][] rows = new byte[this.numUniqueRows][];
        for (int i = 0; i < this.numUniqueRows; ++i) {
            rows[i] = Bytes.toBytes((String)("test_row_" + i));
        }
        ArrayList writers = Lists.newArrayList();
        for (int i = 0; i < this.numWriters; ++i) {
            AtomicityWriter writer = new AtomicityWriter(ctx, rows, FAMILIES, this.sharedPool);
            writers.add(writer);
            ctx.addThread(writer);
        }
        ctx.addThread(new MultithreadedTestUtil.RepeatingTestThread(ctx){

            @Override
            public void doAnAction() throws Exception {
                try {
                    admin.flush(TABLE_NAME);
                }
                catch (IOException ioe) {
                    LOG.warn("Ignoring exception while flushing: " + StringUtils.stringifyException((Throwable)ioe));
                }
                if (!AcidGuaranteesTestTool.this.crazyFlush) {
                    Thread.sleep(60000L);
                }
            }
        });
        ArrayList getters = Lists.newArrayList();
        for (int i = 0; i < this.numGetters; ++i) {
            AtomicGetReader getter = new AtomicGetReader(ctx, rows[i % this.numUniqueRows], FAMILIES, this.sharedPool);
            getters.add(getter);
            ctx.addThread(getter);
        }
        ArrayList scanners = Lists.newArrayList();
        for (int i = 0; i < this.numScanners; ++i) {
            AtomicScanReader scanner = new AtomicScanReader(ctx, FAMILIES, this.sharedPool);
            scanners.add(scanner);
            ctx.addThread(scanner);
        }
        ctx.startThreads();
        ctx.waitFor(this.millisToRun);
        ctx.stop();
        LOG.info("Finished test. Writers:");
        for (AtomicityWriter writer : writers) {
            LOG.info("  wrote " + writer.numWritten.get());
        }
        LOG.info("Readers:");
        for (AtomicGetReader reader : getters) {
            LOG.info("  read " + reader.numRead.get());
        }
        LOG.info("Scanners:");
        for (AtomicScanReader scanner : scanners) {
            LOG.info("  scanned " + scanner.numScans.get());
            LOG.info("  verified " + scanner.numRowsScanned.get() + " rows");
        }
    }

    public static void main(String[] args) {
        int status;
        Configuration c = HBaseConfiguration.create();
        try {
            AcidGuaranteesTestTool test = new AcidGuaranteesTestTool();
            status = ToolRunner.run((Configuration)c, (Tool)test, (String[])args);
        }
        catch (Exception e) {
            LOG.error("Exiting due to error", (Throwable)e);
            status = -1;
        }
        System.exit(status);
    }

    public static class AtomicScanReader
    extends MultithreadedTestUtil.RepeatingTestThread {
        byte[][] targetFamilies;
        Table table;
        Connection connection;
        AtomicLong numScans = new AtomicLong();
        AtomicLong numRowsScanned = new AtomicLong();

        public AtomicScanReader(MultithreadedTestUtil.TestContext ctx, byte[][] targetFamilies, ExecutorService pool) throws IOException {
            super(ctx);
            this.targetFamilies = targetFamilies;
            this.connection = ConnectionFactory.createConnection((Configuration)ctx.getConf(), (ExecutorService)pool);
            this.table = this.connection.getTable(TABLE_NAME);
        }

        @Override
        public void doAnAction() throws Exception {
            Scan s = new Scan();
            for (byte[] family : this.targetFamilies) {
                s.addFamily(family);
            }
            ResultScanner scanner = this.table.getScanner(s);
            for (Result res : scanner) {
                byte[] gotValue = null;
                for (byte[] family : this.targetFamilies) {
                    for (int i = 0; i < NUM_COLS_TO_CHECK; ++i) {
                        byte[] qualifier = Bytes.toBytes((String)("col" + i));
                        byte[] thisValue = res.getValue(family, qualifier);
                        if (gotValue != null && !Bytes.equals((byte[])gotValue, (byte[])thisValue)) {
                            this.gotFailure(gotValue, res);
                        }
                        gotValue = thisValue;
                    }
                }
                this.numRowsScanned.getAndIncrement();
            }
            this.numScans.getAndIncrement();
        }

        @Override
        public void workDone() throws IOException {
            try {
                this.table.close();
            }
            finally {
                this.connection.close();
            }
        }

        private void gotFailure(byte[] expected, Result res) {
            StringBuilder msg = new StringBuilder();
            msg.append("Failed after ").append(this.numRowsScanned).append("!");
            msg.append("Expected=").append(Bytes.toStringBinary((byte[])expected));
            msg.append("Got:\n");
            for (Cell kv : res.listCells()) {
                msg.append(kv.toString());
                msg.append(" val= ");
                msg.append(Bytes.toStringBinary((byte[])CellUtil.cloneValue((Cell)kv)));
                msg.append("\n");
            }
            throw new RuntimeException(msg.toString());
        }
    }

    public static class AtomicGetReader
    extends MultithreadedTestUtil.RepeatingTestThread {
        byte[] targetRow;
        byte[][] targetFamilies;
        Connection connection;
        Table table;
        int numVerified = 0;
        AtomicLong numRead = new AtomicLong();

        public AtomicGetReader(MultithreadedTestUtil.TestContext ctx, byte[] targetRow, byte[][] targetFamilies, ExecutorService pool) throws IOException {
            super(ctx);
            this.targetRow = targetRow;
            this.targetFamilies = targetFamilies;
            this.connection = ConnectionFactory.createConnection((Configuration)ctx.getConf(), (ExecutorService)pool);
            this.table = this.connection.getTable(TABLE_NAME);
        }

        @Override
        public void doAnAction() throws Exception {
            Get g = new Get(this.targetRow);
            Result res = this.table.get(g);
            byte[] gotValue = null;
            if (res.getRow() == null) {
                return;
            }
            for (byte[] family : this.targetFamilies) {
                for (int i = 0; i < NUM_COLS_TO_CHECK; ++i) {
                    byte[] qualifier = Bytes.toBytes((String)("col" + i));
                    byte[] thisValue = res.getValue(family, qualifier);
                    if (gotValue != null && !Bytes.equals(gotValue, (byte[])thisValue)) {
                        this.gotFailure(gotValue, res);
                    }
                    ++this.numVerified;
                    gotValue = thisValue;
                }
            }
            this.numRead.getAndIncrement();
        }

        @Override
        public void workDone() throws IOException {
            try {
                this.table.close();
            }
            finally {
                this.connection.close();
            }
        }

        private void gotFailure(byte[] expected, Result res) {
            StringBuilder msg = new StringBuilder();
            msg.append("Failed after ").append(this.numVerified).append("!");
            msg.append("Expected=").append(Bytes.toStringBinary((byte[])expected));
            msg.append("Got:\n");
            for (Cell kv : res.listCells()) {
                msg.append(kv.toString());
                msg.append(" val= ");
                msg.append(Bytes.toStringBinary((byte[])CellUtil.cloneValue((Cell)kv)));
                msg.append("\n");
            }
            throw new RuntimeException(msg.toString());
        }
    }

    public static class AtomicityWriter
    extends MultithreadedTestUtil.RepeatingTestThread {
        Random rand = new Random();
        byte[] data = new byte[10];
        byte[][] targetRows;
        byte[][] targetFamilies;
        Connection connection;
        Table table;
        AtomicLong numWritten = new AtomicLong();

        public AtomicityWriter(MultithreadedTestUtil.TestContext ctx, byte[][] targetRows, byte[][] targetFamilies, ExecutorService pool) throws IOException {
            super(ctx);
            this.targetRows = targetRows;
            this.targetFamilies = targetFamilies;
            this.connection = ConnectionFactory.createConnection((Configuration)ctx.getConf(), (ExecutorService)pool);
            this.table = this.connection.getTable(TABLE_NAME);
        }

        @Override
        public void doAnAction() throws Exception {
            byte[] targetRow = this.targetRows[this.rand.nextInt(this.targetRows.length)];
            Put p = new Put(targetRow);
            this.rand.nextBytes(this.data);
            for (byte[] family : this.targetFamilies) {
                for (int i = 0; i < NUM_COLS_TO_CHECK; ++i) {
                    byte[] qualifier = Bytes.toBytes((String)("col" + i));
                    p.addColumn(family, qualifier, this.data);
                }
            }
            this.table.put(p);
            this.numWritten.getAndIncrement();
        }

        @Override
        public void workDone() throws IOException {
            try {
                this.table.close();
            }
            finally {
                this.connection.close();
            }
        }
    }
}

