/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.naming.ServiceUnavailableException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.JMXListener;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestJMXConnectorServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestJMXConnectorServer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestJMXConnectorServer.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Configuration conf = null;
    private static Admin admin;
    private static int rmiRegistryPort;
    static boolean hasAccess;

    @Before
    public void setUp() throws Exception {
        UTIL = new HBaseTestingUtility();
        conf = UTIL.getConfiguration();
    }

    @After
    public void tearDown() throws Exception {
        hasAccess = true;
        admin.close();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testHMConnectorServerWhenStopMaster() throws Exception {
        JMXConnector connector;
        block4: {
            conf.set("hbase.coprocessor.master.classes", JMXListener.class.getName() + "," + MyAccessController.class.getName());
            conf.setInt("master.rmi.registry.port", rmiRegistryPort);
            UTIL.startMiniCluster();
            admin = UTIL.getConnection().getAdmin();
            boolean accessDenied = false;
            try {
                hasAccess = false;
                LOG.info("Stopping HMaster...");
                admin.stopMaster();
            }
            catch (AccessDeniedException e) {
                LOG.info("Exception occurred while stopping HMaster. ", (Throwable)e);
                accessDenied = true;
            }
            Assert.assertTrue((boolean)accessDenied);
            connector = null;
            try {
                connector = JMXConnectorFactory.connect(JMXListener.buildJMXServiceURL((int)rmiRegistryPort, (int)rmiRegistryPort));
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof ServiceUnavailableException)) break block4;
                Assert.fail((String)"Can't connect to HMaster ConnectorServer.");
            }
        }
        Assert.assertNotNull((String)"JMXConnector should not be null.", (Object)connector);
        connector.close();
    }

    @Test
    public void testRSConnectorServerWhenStopRegionServer() throws Exception {
        JMXConnector connector;
        block2: {
            conf.set("hbase.coprocessor.regionserver.classes", JMXListener.class.getName() + "," + MyAccessController.class.getName());
            conf.setInt("regionserver.rmi.registry.port", rmiRegistryPort);
            UTIL.startMiniCluster();
            admin = UTIL.getConnection().getAdmin();
            hasAccess = false;
            ServerName serverName = UTIL.getHBaseCluster().getRegionServer(0).getServerName();
            LOG.info("Stopping Region Server...");
            admin.stopRegionServer(serverName.getHostname() + ":" + serverName.getPort());
            connector = null;
            try {
                connector = JMXConnectorFactory.connect(JMXListener.buildJMXServiceURL((int)rmiRegistryPort, (int)rmiRegistryPort));
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof ServiceUnavailableException)) break block2;
                Assert.fail((String)"Can't connect to Region Server ConnectorServer.");
            }
        }
        Assert.assertNotNull((String)"JMXConnector should not be null.", (Object)connector);
        connector.close();
    }

    @Test
    public void testHMConnectorServerWhenShutdownCluster() throws Exception {
        JMXConnector connector;
        block4: {
            conf.set("hbase.coprocessor.master.classes", JMXListener.class.getName() + "," + MyAccessController.class.getName());
            conf.setInt("master.rmi.registry.port", rmiRegistryPort);
            UTIL.startMiniCluster();
            admin = UTIL.getConnection().getAdmin();
            boolean accessDenied = false;
            try {
                hasAccess = false;
                LOG.info("Stopping HMaster...");
                admin.shutdown();
            }
            catch (AccessDeniedException e) {
                LOG.error("Exception occurred while stopping HMaster. ", (Throwable)e);
                accessDenied = true;
            }
            Assert.assertTrue((boolean)accessDenied);
            connector = null;
            try {
                connector = JMXConnectorFactory.connect(JMXListener.buildJMXServiceURL((int)rmiRegistryPort, (int)rmiRegistryPort));
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof ServiceUnavailableException)) break block4;
                Assert.fail((String)"Can't connect to HMaster ConnectorServer.");
            }
        }
        Assert.assertNotNull((String)"JMXConnector should not be null.", (Object)connector);
        connector.close();
    }

    static {
        rmiRegistryPort = 61120;
    }

    public static class MyAccessController
    extends AccessController {
        public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        }

        public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
            if (!hasAccess) {
                throw new AccessDeniedException("Insufficient permissions to stop master");
            }
        }

        public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
            if (!hasAccess) {
                throw new AccessDeniedException("Insufficient permissions to stop region server.");
            }
        }

        public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
            if (!hasAccess) {
                throw new AccessDeniedException("Insufficient permissions to shut down cluster.");
            }
        }

        public void preExecuteProcedures(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        }
    }
}

