/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TestZKAsyncRegistry;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

final class RegionReplicaTestHelper {
    private RegionReplicaTestHelper() {
    }

    static void waitUntilAllMetaReplicasHavingRegionLocation(final AsyncRegistry registry, final int regionReplication) throws IOException {
        TestZKAsyncRegistry.TEST_UTIL.waitFor(TestZKAsyncRegistry.TEST_UTIL.getConfiguration().getLong("hbase.client.sync.wait.timeout.msec", 60000L), 200L, true, (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() throws IOException {
                return "Not all meta replicas get assigned";
            }

            public boolean evaluate() throws IOException {
                try {
                    RegionLocations locs = (RegionLocations)registry.getMetaRegionLocation().get();
                    if (locs.size() < regionReplication) {
                        return false;
                    }
                    for (int i = 0; i < regionReplication; ++i) {
                        if (locs.getRegionLocation(i) != null) continue;
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    TestZKAsyncRegistry.LOG.warn("Failed to get meta region locations", (Throwable)e);
                    return false;
                }
            }
        });
    }

    static Optional<ServerName> getRSCarryingReplica(HBaseTestingUtility util, TableName tableName, int replicaId) {
        return util.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer()).filter(rs -> rs.getRegions(tableName).stream().anyMatch(r -> r.getRegionInfo().getReplicaId() == replicaId)).findAny().map(rs -> rs.getServerName());
    }

    static ServerName moveRegion(final HBaseTestingUtility util, HRegionLocation currentLoc) throws Exception {
        final ServerName serverName = currentLoc.getServerName();
        final RegionInfo regionInfo = currentLoc.getRegion();
        final TableName tableName = regionInfo.getTable();
        final int replicaId = regionInfo.getReplicaId();
        ServerName newServerName = util.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getServerName()).filter(sn -> !sn.equals((Object)serverName)).findAny().get();
        util.getAdmin().move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)newServerName.getServerName()));
        util.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                Optional<ServerName> newServerName = RegionReplicaTestHelper.getRSCarryingReplica(util, tableName, replicaId);
                return newServerName.isPresent() && !newServerName.get().equals((Object)serverName);
            }

            public String explainFailure() throws Exception {
                return regionInfo.getRegionNameAsString() + " is still on " + serverName;
            }
        });
        return newServerName;
    }

    static void testLocator(HBaseTestingUtility util, TableName tableName, Locator locator) throws Exception {
        RegionLocations locs = locator.getRegionLocations(tableName, 0, false);
        Assert.assertEquals((long)3L, (long)locs.size());
        for (int i = 0; i < 3; ++i) {
            HRegionLocation loc = locs.getRegionLocation(i);
            Assert.assertNotNull((Object)loc);
            ServerName serverName = RegionReplicaTestHelper.getRSCarryingReplica(util, tableName, i).get();
            Assert.assertEquals((Object)serverName, (Object)loc.getServerName());
        }
        ServerName newServerName = RegionReplicaTestHelper.moveRegion(util, locs.getDefaultRegionLocation());
        Assert.assertEquals((Object)locs.getDefaultRegionLocation().getServerName(), (Object)locator.getRegionLocations(tableName, 0, false).getDefaultRegionLocation().getServerName());
        Assert.assertEquals((Object)newServerName, (Object)locator.getRegionLocations(tableName, 0, true).getDefaultRegionLocation().getServerName());
        Assert.assertEquals((Object)newServerName, (Object)locator.getRegionLocations(tableName, 0, false).getDefaultRegionLocation().getServerName());
        ServerName newServerName1 = RegionReplicaTestHelper.moveRegion(util, locs.getRegionLocation(1));
        ServerName newServerName2 = RegionReplicaTestHelper.moveRegion(util, locs.getRegionLocation(2));
        Assert.assertEquals((Object)locs.getRegionLocation(1).getServerName(), (Object)locator.getRegionLocations(tableName, 1, false).getRegionLocation(1).getServerName());
        locator.updateCachedLocationOnError(locs.getRegionLocation(1), new NotServingRegionException());
        Assert.assertEquals((Object)locs.getRegionLocation(2).getServerName(), (Object)locator.getRegionLocations(tableName, 2, false).getRegionLocation(2).getServerName());
        Assert.assertEquals((Object)newServerName1, (Object)locator.getRegionLocations(tableName, 1, false).getRegionLocation(1).getServerName());
        Assert.assertEquals((Object)newServerName2, (Object)locator.getRegionLocations(tableName, 2, false).getRegionLocation(2).getServerName());
    }

    static interface Locator {
        public RegionLocations getRegionLocations(TableName var1, int var2, boolean var3) throws Exception;

        public void updateCachedLocationOnError(HRegionLocation var1, Throwable var2) throws Exception;
    }
}

