/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"cq");
    private static byte[] VALUE = Bytes.toBytes((String)"value");
    private static AsyncConnection ASYNC_CONN;
    @Rule
    public TestName testName = new TestName();
    private byte[] row;
    @Parameterized.Parameter
    public Supplier<AsyncTable<?>> getTable;

    private static AsyncTable<?> getRawTable() {
        return ASYNC_CONN.getTable(TABLE_NAME);
    }

    private static AsyncTable<?> getTable() {
        return ASYNC_CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool());
    }

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return Arrays.asList({TestAsyncTable::getRawTable}, {TestAsyncTable::getTable});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        IOUtils.closeQuietly((Closeable)ASYNC_CONN);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException, InterruptedException, ExecutionException {
        this.row = Bytes.toBytes((String)this.testName.getMethodName().replaceAll("[^0-9A-Za-z]", "_"));
        if (((Boolean)ASYNC_CONN.getAdmin().isTableDisabled(TABLE_NAME).get()).booleanValue()) {
            ASYNC_CONN.getAdmin().enableTable(TABLE_NAME).get();
        }
    }

    @Test
    public void testSimple() throws Exception {
        AsyncTable<?> table = this.getTable.get();
        table.put(new Put(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).get();
        Assert.assertTrue((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get()));
        Result result = (Result)table.get(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get();
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
        table.delete(new Delete(this.row)).get();
        result = (Result)table.get(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertFalse((boolean)((Boolean)table.exists(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get()));
    }

    private byte[] concat(byte[] base, int index) {
        return Bytes.toBytes((String)(Bytes.toString((byte[])base) + "-" + index));
    }

    @Test
    public void testSimpleMultiple() throws Exception {
        int i2;
        AsyncTable<?> table = this.getTable.get();
        int count = 100;
        CountDownLatch putLatch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> table.put(new Put(this.concat(this.row, i)).addColumn(FAMILY, QUALIFIER, this.concat(VALUE, i))).thenAccept(x -> putLatch.countDown()));
        putLatch.await();
        ArrayBlockingQueue existsResp = new ArrayBlockingQueue(count);
        IntStream.range(0, count).forEach(i -> table.exists(new Get(this.concat(this.row, i)).addColumn(FAMILY, QUALIFIER)).thenAccept(x -> existsResp.add(x)));
        for (int i3 = 0; i3 < count; ++i3) {
            Assert.assertTrue((boolean)((Boolean)existsResp.take()));
        }
        ArrayBlockingQueue getResp = new ArrayBlockingQueue(count);
        IntStream.range(0, count).forEach(i -> table.get(new Get(this.concat(this.row, i)).addColumn(FAMILY, QUALIFIER)).thenAccept(x -> getResp.add(Pair.newPair((Object)i, (Object)x))));
        for (int i4 = 0; i4 < count; ++i4) {
            Pair pair = (Pair)getResp.take();
            Assert.assertArrayEquals((byte[])this.concat(VALUE, (Integer)pair.getFirst()), (byte[])((Result)pair.getSecond()).getValue(FAMILY, QUALIFIER));
        }
        CountDownLatch deleteLatch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> table.delete(new Delete(this.concat(this.row, i))).thenAccept(x -> deleteLatch.countDown()));
        deleteLatch.await();
        IntStream.range(0, count).forEach(i -> table.exists(new Get(this.concat(this.row, i)).addColumn(FAMILY, QUALIFIER)).thenAccept(x -> existsResp.add(x)));
        for (i2 = 0; i2 < count; ++i2) {
            Assert.assertFalse((boolean)((Boolean)existsResp.take()));
        }
        IntStream.range(0, count).forEach(i -> table.get(new Get(this.concat(this.row, i)).addColumn(FAMILY, QUALIFIER)).thenAccept(x -> getResp.add(Pair.newPair((Object)i, (Object)x))));
        for (i2 = 0; i2 < count; ++i2) {
            Pair pair = (Pair)getResp.take();
            Assert.assertTrue((boolean)((Result)pair.getSecond()).isEmpty());
        }
    }

    @Test
    public void testIncrement() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        int count = 100;
        CountDownLatch latch = new CountDownLatch(count);
        AtomicLong sum = new AtomicLong(0L);
        IntStream.range(0, count).forEach(i -> table.incrementColumnValue(this.row, FAMILY, QUALIFIER, 1L).thenAccept(x -> {
            sum.addAndGet((long)x);
            latch.countDown();
        }));
        latch.await();
        Assert.assertEquals((long)count, (long)Bytes.toLong((byte[])((Result)table.get(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get()).getValue(FAMILY, QUALIFIER)));
        Assert.assertEquals((long)((1 + count) * count / 2), (long)sum.get());
    }

    @Test
    public void testAppend() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        int count = 10;
        CountDownLatch latch = new CountDownLatch(count);
        char suffix = ':';
        AtomicLong suffixCount = new AtomicLong(0L);
        IntStream.range(0, count).forEachOrdered(i -> table.append(new Append(this.row).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)("" + i + suffix)))).thenAccept(r -> {
            suffixCount.addAndGet(Bytes.toString((byte[])r.getValue(FAMILY, QUALIFIER)).chars().filter(x -> x == suffix).count());
            latch.countDown();
        }));
        latch.await();
        Assert.assertEquals((long)((1 + count) * count / 2), (long)suffixCount.get());
        String value = Bytes.toString((byte[])((Result)table.get(new Get(this.row).addColumn(FAMILY, QUALIFIER)).get()).getValue(FAMILY, QUALIFIER));
        int[] actual = Arrays.asList(value.split("" + suffix)).stream().mapToInt(Integer::parseInt).sorted().toArray();
        Assert.assertArrayEquals((int[])IntStream.range(0, count).toArray(), (int[])actual);
    }

    @Test
    public void testCheckAndPut() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger successIndex = new AtomicInteger(-1);
        int count = 10;
        CountDownLatch latch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(new Put(this.row).addColumn(FAMILY, QUALIFIER, this.concat(VALUE, i))).thenAccept(x -> {
            if (x.booleanValue()) {
                successCount.incrementAndGet();
                successIndex.set(i);
            }
            latch.countDown();
        }));
        latch.await();
        Assert.assertEquals((long)1L, (long)successCount.get());
        String actual = Bytes.toString((byte[])((Result)table.get(new Get(this.row)).get()).getValue(FAMILY, QUALIFIER));
        Assert.assertTrue((boolean)actual.endsWith(Integer.toString(successIndex.get())));
    }

    @Test
    public void testCheckAndDelete() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        int count = 10;
        CountDownLatch putLatch = new CountDownLatch(count + 1);
        table.put(new Put(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).thenRun(() -> putLatch.countDown());
        IntStream.range(0, count).forEach(i -> table.put(new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, i), VALUE)).thenRun(() -> putLatch.countDown()));
        putLatch.await();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger successIndex = new AtomicInteger(-1);
        CountDownLatch deleteLatch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).ifEquals(VALUE).thenDelete(new Delete(this.row).addColumn(FAMILY, QUALIFIER).addColumn(FAMILY, this.concat(QUALIFIER, i))).thenAccept(x -> {
            if (x.booleanValue()) {
                successCount.incrementAndGet();
                successIndex.set(i);
            }
            deleteLatch.countDown();
        }));
        deleteLatch.await();
        Assert.assertEquals((long)1L, (long)successCount.get());
        Result result = (Result)table.get(new Get(this.row)).get();
        IntStream.range(0, count).forEach(i -> {
            if (i == successIndex.get()) {
                Assert.assertFalse((boolean)result.containsColumn(FAMILY, this.concat(QUALIFIER, i)));
            } else {
                Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, i)));
            }
        });
    }

    @Test
    public void testMutateRow() throws InterruptedException, ExecutionException, IOException {
        AsyncTable<?> table = this.getTable.get();
        RowMutations mutation = new RowMutations(this.row);
        mutation.add((Mutation)new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, 1), VALUE));
        table.mutateRow(mutation).get();
        Result result = (Result)table.get(new Get(this.row)).get();
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, 1)));
        mutation = new RowMutations(this.row);
        mutation.add((Mutation)new Delete(this.row).addColumn(FAMILY, this.concat(QUALIFIER, 1)));
        mutation.add((Mutation)new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, 2), VALUE));
        table.mutateRow(mutation).get();
        result = (Result)table.get(new Get(this.row)).get();
        Assert.assertNull((Object)result.getValue(FAMILY, this.concat(QUALIFIER, 1)));
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, 2)));
    }

    @Test
    public void testCheckAndMutate() throws InterruptedException, ExecutionException {
        AsyncTable<?> table = this.getTable.get();
        int count = 10;
        CountDownLatch putLatch = new CountDownLatch(count + 1);
        table.put(new Put(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).thenRun(() -> putLatch.countDown());
        IntStream.range(0, count).forEach(i -> table.put(new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, i), VALUE)).thenRun(() -> putLatch.countDown()));
        putLatch.await();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger successIndex = new AtomicInteger(-1);
        CountDownLatch mutateLatch = new CountDownLatch(count);
        IntStream.range(0, count).forEach(i -> {
            RowMutations mutation = new RowMutations(this.row);
            try {
                mutation.add((Mutation)new Delete(this.row).addColumn(FAMILY, QUALIFIER));
                mutation.add((Mutation)new Put(this.row).addColumn(FAMILY, this.concat(QUALIFIER, i), this.concat(VALUE, i)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).ifEquals(VALUE).thenMutate(mutation).thenAccept(x -> {
                if (x.booleanValue()) {
                    successCount.incrementAndGet();
                    successIndex.set(i);
                }
                mutateLatch.countDown();
            });
        });
        mutateLatch.await();
        Assert.assertEquals((long)1L, (long)successCount.get());
        Result result = (Result)table.get(new Get(this.row)).get();
        IntStream.range(0, count).forEach(i -> {
            if (i == successIndex.get()) {
                Assert.assertArrayEquals((byte[])this.concat(VALUE, i), (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, i)));
            } else {
                Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, this.concat(QUALIFIER, i)));
            }
        });
    }

    @Test
    public void testCheckAndMutateWithTimeRange() throws Exception {
        AsyncTable<?> table = this.getTable.get();
        long ts = System.currentTimeMillis() / 2L;
        Put put = new Put(this.row);
        put.addColumn(FAMILY, QUALIFIER, ts, VALUE);
        boolean ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put).get();
        Assert.assertTrue((boolean)ok);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenPut(put).get();
        Assert.assertFalse((boolean)ok);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenPut(put).get();
        Assert.assertTrue((boolean)ok);
        RowMutations rm = new RowMutations(this.row).add((Mutation)put);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenMutate(rm).get();
        Assert.assertFalse((boolean)ok);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenMutate(rm).get();
        Assert.assertTrue((boolean)ok);
        Delete delete = new Delete(this.row).addColumn(FAMILY, QUALIFIER);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenDelete(delete).get();
        Assert.assertFalse((boolean)ok);
        ok = (Boolean)table.checkAndMutate(this.row, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenDelete(delete).get();
        Assert.assertTrue((boolean)ok);
    }

    @Test
    public void testDisabled() throws InterruptedException, ExecutionException {
        ASYNC_CONN.getAdmin().disableTable(TABLE_NAME).get();
        try {
            this.getTable.get().get(new Get(this.row)).get();
            Assert.fail((String)"Should fail since table has been disabled");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(TableNotEnabledException.class));
            Assert.assertThat((Object)cause.getMessage(), (Matcher)CoreMatchers.containsString((String)TABLE_NAME.getNameAsString()));
        }
    }
}

