/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AbstractTestAsyncTableScan;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableScanAll
extends AbstractTestAsyncTableScan {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableScanAll.class);
    @Parameterized.Parameter(value=0)
    public String tableType;
    @Parameterized.Parameter(value=1)
    public Supplier<AsyncTable<?>> getTable;
    @Parameterized.Parameter(value=2)
    public String scanType;
    @Parameterized.Parameter(value=3)
    public Supplier<Scan> scanCreator;

    @Parameterized.Parameters(name="{index}: table={0}, scan={2}")
    public static List<Object[]> params() {
        return TestAsyncTableScanAll.getTableAndScanCreatorParams();
    }

    @Override
    protected Scan createScan() {
        return this.scanCreator.get();
    }

    @Override
    protected List<Result> doScan(Scan scan) throws Exception {
        List<Result> results = (List<Result>)this.getTable.get().scanAll(scan).get();
        if (scan.getBatch() > 0) {
            results = this.convertFromBatchResult(results);
        }
        return results;
    }
}

