/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ReplicationPeerNotFoundException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.replication.DummyReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.TestReplicationEndpoint;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestReplicationAdmin {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationAdmin.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationAdmin.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String ID_ONE = "1";
    private final String KEY_ONE = "127.0.0.1:2181:/hbase";
    private final String ID_SECOND = "2";
    private final String KEY_SECOND = "127.0.0.1:2181:/hbase2";
    private static ReplicationAdmin admin;
    private static Admin hbaseAdmin;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        TEST_UTIL.startMiniCluster();
        admin = new ReplicationAdmin(TEST_UTIL.getConfiguration());
        hbaseAdmin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (admin != null) {
            admin.close();
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        for (ReplicationPeerDescription desc : hbaseAdmin.listReplicationPeers()) {
            hbaseAdmin.removeReplicationPeer(desc.getPeerId());
        }
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)TEST_UTIL.getZooKeeperWatcher(), (Configuration)TEST_UTIL.getConfiguration());
        for (ServerName serverName : queueStorage.getListOfReplicators()) {
            for (String queue : queueStorage.getAllQueues(serverName)) {
                queueStorage.removeQueue(serverName, queue);
            }
            queueStorage.removeReplicatorIfQueueIsEmpty(serverName);
        }
    }

    @Test
    public void testConcurrentPeerOperations() throws Exception {
        int threadNum = 5;
        AtomicLong successCount = new AtomicLong(0L);
        Thread[] addPeers = new Thread[threadNum];
        for (int i = 0; i < threadNum; ++i) {
            addPeers[i] = new Thread(() -> {
                try {
                    hbaseAdmin.addReplicationPeer("1", ReplicationPeerConfig.newBuilder().setClusterKey("127.0.0.1:2181:/hbase").build());
                    successCount.incrementAndGet();
                }
                catch (Exception e) {
                    LOG.debug("Got exception when add replication peer", (Throwable)e);
                }
            });
            addPeers[i].start();
        }
        for (Thread addPeer : addPeers) {
            addPeer.join();
        }
        Assert.assertEquals((long)1L, (long)successCount.get());
        successCount.set(0L);
        Thread[] removePeers = new Thread[threadNum];
        for (int i = 0; i < threadNum; ++i) {
            removePeers[i] = new Thread(() -> {
                try {
                    hbaseAdmin.removeReplicationPeer("1");
                    successCount.incrementAndGet();
                }
                catch (Exception e) {
                    LOG.debug("Got exception when remove replication peer", (Throwable)e);
                }
            });
            removePeers[i].start();
        }
        for (Thread removePeer : removePeers) {
            removePeer.join();
        }
        Assert.assertEquals((long)1L, (long)successCount.get());
        successCount.set(0L);
        addPeers = new Thread[threadNum];
        for (int i = 0; i < threadNum; ++i) {
            addPeers[i] = new Thread(() -> {
                try {
                    hbaseAdmin.addReplicationPeer("1", ReplicationPeerConfig.newBuilder().setClusterKey("127.0.0.1:2181:/hbase").build());
                    successCount.incrementAndGet();
                }
                catch (Exception e) {
                    LOG.debug("Got exception when add replication peer", (Throwable)e);
                }
            });
            addPeers[i].start();
        }
        for (Thread addPeer : addPeers) {
            addPeer.join();
        }
        Assert.assertEquals((long)1L, (long)successCount.get());
    }

    @Test
    public void testAddInvalidPeer() {
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder();
        builder.setClusterKey("127.0.0.1:2181:/hbase");
        try {
            String invalidPeerId = "1-2";
            hbaseAdmin.addReplicationPeer(invalidPeerId, builder.build());
            Assert.fail((String)("Should fail as the peer id: " + invalidPeerId + " is invalid"));
        }
        catch (Exception invalidPeerId) {
            // empty catch block
        }
        try {
            String invalidClusterKey = "2181:/hbase";
            builder.setClusterKey(invalidClusterKey);
            hbaseAdmin.addReplicationPeer("1", builder.build());
            Assert.fail((String)("Should fail as the peer cluster key: " + invalidClusterKey + " is invalid"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAddRemovePeer() throws Exception {
        ReplicationPeerConfigBuilder rpc1 = ReplicationPeerConfig.newBuilder();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        ReplicationPeerConfigBuilder rpc2 = ReplicationPeerConfig.newBuilder();
        rpc2.setClusterKey("127.0.0.1:2181:/hbase2");
        hbaseAdmin.addReplicationPeer("1", rpc1.build());
        try {
            hbaseAdmin.addReplicationPeer("1", rpc1.build());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)hbaseAdmin.listReplicationPeers().size());
        try {
            hbaseAdmin.removeReplicationPeer("2");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)hbaseAdmin.listReplicationPeers().size());
        try {
            hbaseAdmin.addReplicationPeer("2", rpc2.build());
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertEquals((long)2L, (long)hbaseAdmin.listReplicationPeers().size());
        hbaseAdmin.removeReplicationPeer("1");
        Assert.assertEquals((long)1L, (long)hbaseAdmin.listReplicationPeers().size());
        hbaseAdmin.removeReplicationPeer("2");
        Assert.assertEquals((long)0L, (long)hbaseAdmin.listReplicationPeers().size());
    }

    @Test
    public void testAddPeerWithState() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        hbaseAdmin.addReplicationPeer("1", rpc1, true);
        Assert.assertTrue((boolean)((ReplicationPeerDescription)hbaseAdmin.listReplicationPeers(Pattern.compile("1")).get(0)).isEnabled());
        hbaseAdmin.removeReplicationPeer("1");
        ReplicationPeerConfig rpc2 = new ReplicationPeerConfig();
        rpc2.setClusterKey("127.0.0.1:2181:/hbase2");
        hbaseAdmin.addReplicationPeer("2", rpc2, false);
        Assert.assertFalse((boolean)((ReplicationPeerDescription)hbaseAdmin.listReplicationPeers(Pattern.compile("2")).get(0)).isEnabled());
        hbaseAdmin.removeReplicationPeer("2");
    }

    @Test
    public void testPeerConfig() throws Exception {
        ReplicationPeerConfig config = new ReplicationPeerConfig();
        config.setClusterKey("127.0.0.1:2181:/hbase");
        config.getConfiguration().put("key1", "value1");
        config.getConfiguration().put("key2", "value2");
        hbaseAdmin.addReplicationPeer("1", config);
        List peers = hbaseAdmin.listReplicationPeers();
        Assert.assertEquals((long)1L, (long)peers.size());
        ReplicationPeerDescription peerOne = (ReplicationPeerDescription)peers.get(0);
        Assert.assertNotNull((Object)peerOne);
        Assert.assertEquals((Object)"value1", peerOne.getPeerConfig().getConfiguration().get("key1"));
        Assert.assertEquals((Object)"value2", peerOne.getPeerConfig().getConfiguration().get("key2"));
        hbaseAdmin.removeReplicationPeer("1");
    }

    @Test
    public void testAddPeerWithUnDeletedQueues() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        ReplicationPeerConfig rpc2 = new ReplicationPeerConfig();
        rpc2.setClusterKey("127.0.0.1:2181:/hbase2");
        Configuration conf = TEST_UTIL.getConfiguration();
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)TEST_UTIL.getZooKeeperWatcher(), (Configuration)conf);
        ServerName serverName = ServerName.valueOf((String)"server1", (int)8000, (long)1234L);
        queueStorage.addWAL(serverName, "1", "file1");
        try {
            admin.addPeer("1", rpc1, null);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        queueStorage.removeQueue(serverName, "1");
        Assert.assertEquals((long)0L, (long)queueStorage.getAllQueues(serverName).size());
        queueStorage.addWAL(serverName, "1-server2", "file1");
        try {
            admin.addPeer("1", rpc2, null);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testEnableDisable() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        admin.addPeer("1", rpc1, null);
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        Assert.assertTrue((boolean)admin.getPeerState("1"));
        admin.disablePeer("1");
        Assert.assertFalse((boolean)admin.getPeerState("1"));
        try {
            admin.getPeerState("2");
        }
        catch (ReplicationPeerNotFoundException replicationPeerNotFoundException) {
            // empty catch block
        }
        admin.removePeer("1");
    }

    @Test
    public void testAppendPeerTableCFs() throws Exception {
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "t1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "t2"));
        TableName tableName3 = TableName.valueOf((String)(this.name.getMethodName() + "t3"));
        TableName tableName4 = TableName.valueOf((String)(this.name.getMethodName() + "t4"));
        TableName tableName5 = TableName.valueOf((String)(this.name.getMethodName() + "t5"));
        TableName tableName6 = TableName.valueOf((String)(this.name.getMethodName() + "t6"));
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        rpc.setReplicateAllUserTables(false);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        HashMap tableCFs = new HashMap();
        tableCFs.put(tableName1, null);
        admin.appendPeerTableCFs("1", tableCFs);
        Map result = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)true, (Object)result.containsKey(tableName1));
        Assert.assertNull(result.get(tableName1));
        tableCFs.clear();
        tableCFs.put(tableName2, null);
        admin.appendPeerTableCFs("1", tableCFs);
        result = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertNull(result.get(tableName1));
        Assert.assertNull(result.get(tableName2));
        tableCFs.clear();
        tableCFs.put(tableName3, new ArrayList());
        ((List)tableCFs.get(tableName3)).add("f1");
        admin.appendPeerTableCFs("1", tableCFs);
        result = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertTrue((String)"Should contain t3", (boolean)result.containsKey(tableName3));
        Assert.assertNull(result.get(tableName1));
        Assert.assertNull(result.get(tableName2));
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName3)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tableName3)).get(0));
        tableCFs.clear();
        tableCFs.put(tableName4, new ArrayList());
        ((List)tableCFs.get(tableName4)).add("f1");
        ((List)tableCFs.get(tableName4)).add("f2");
        admin.appendPeerTableCFs("1", tableCFs);
        result = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertTrue((String)"Should contain t3", (boolean)result.containsKey(tableName3));
        Assert.assertTrue((String)"Should contain t4", (boolean)result.containsKey(tableName4));
        Assert.assertNull(result.get(tableName1));
        Assert.assertNull(result.get(tableName2));
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName3)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tableName3)).get(0));
        Assert.assertEquals((long)2L, (long)((List)result.get(tableName4)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tableName4)).get(0));
        Assert.assertEquals((Object)"f2", ((List)result.get(tableName4)).get(1));
        tableCFs.clear();
        tableCFs.put(tableName5, new ArrayList());
        admin.appendPeerTableCFs("1", tableCFs);
        tableCFs.clear();
        tableCFs.put(tableName5, new ArrayList());
        ((List)tableCFs.get(tableName5)).add("f1");
        admin.appendPeerTableCFs("1", tableCFs);
        result = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertTrue((String)"Should contain t5", (boolean)result.containsKey(tableName5));
        Assert.assertNull(result.get(tableName5));
        tableCFs.clear();
        tableCFs.put(tableName6, new ArrayList());
        ((List)tableCFs.get(tableName6)).add("f1");
        admin.appendPeerTableCFs("1", tableCFs);
        tableCFs.clear();
        tableCFs.put(tableName6, new ArrayList());
        admin.appendPeerTableCFs("1", tableCFs);
        result = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertTrue((String)"Should contain t6", (boolean)result.containsKey(tableName6));
        Assert.assertNull(result.get(tableName6));
        admin.removePeer("1");
    }

    @Test
    public void testRemovePeerTableCFs() throws Exception {
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "t1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "t2"));
        TableName tableName3 = TableName.valueOf((String)(this.name.getMethodName() + "t3"));
        TableName tableName4 = TableName.valueOf((String)(this.name.getMethodName() + "t4"));
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        rpc.setReplicateAllUserTables(false);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        HashMap tableCFs = new HashMap();
        try {
            tableCFs.put(tableName3, null);
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        Assert.assertNull((Object)admin.getPeerTableCFs("1"));
        tableCFs.clear();
        tableCFs.put(tableName1, null);
        tableCFs.put(tableName2, new ArrayList());
        ((List)tableCFs.get(tableName2)).add("cf1");
        admin.setPeerTableCFs("1", tableCFs);
        try {
            tableCFs.clear();
            tableCFs.put(tableName3, null);
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        Map result = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertNull(result.get(tableName1));
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName2)).size());
        Assert.assertEquals((Object)"cf1", ((List)result.get(tableName2)).get(0));
        try {
            tableCFs.clear();
            tableCFs.put(tableName1, new ArrayList());
            ((List)tableCFs.get(tableName1)).add("f1");
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        tableCFs.clear();
        tableCFs.put(tableName1, null);
        admin.removePeerTableCFs("1", tableCFs);
        result = ReplicationPeerConfigUtil.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName2)).size());
        Assert.assertEquals((Object)"cf1", ((List)result.get(tableName2)).get(0));
        try {
            tableCFs.clear();
            tableCFs.put(tableName2, null);
            admin.removePeerTableCFs("1", tableCFs);
            Assert.fail();
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        tableCFs.clear();
        tableCFs.put(tableName2, new ArrayList());
        ((List)tableCFs.get(tableName2)).add("cf1");
        admin.removePeerTableCFs("1", tableCFs);
        Assert.assertNull((Object)admin.getPeerTableCFs("1"));
        tableCFs.clear();
        tableCFs.put(tableName4, new ArrayList());
        admin.setPeerTableCFs("1", tableCFs);
        admin.removePeerTableCFs("1", tableCFs);
        Assert.assertNull((Object)admin.getPeerTableCFs("1"));
        admin.removePeer("1");
    }

    @Test
    public void testSetPeerNamespaces() throws Exception {
        String ns1 = "ns1";
        String ns2 = "ns2";
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        rpc.setReplicateAllUserTables(false);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        Set<String> namespaces = new HashSet<String>();
        namespaces.add(ns1);
        namespaces.add(ns2);
        rpc.setNamespaces(namespaces);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        namespaces = hbaseAdmin.getReplicationPeerConfig("1").getNamespaces();
        Assert.assertEquals((long)2L, (long)namespaces.size());
        Assert.assertTrue((boolean)namespaces.contains(ns1));
        Assert.assertTrue((boolean)namespaces.contains(ns2));
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        namespaces = new HashSet();
        namespaces.add(ns1);
        rpc.setNamespaces(namespaces);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        namespaces = hbaseAdmin.getReplicationPeerConfig("1").getNamespaces();
        Assert.assertEquals((long)1L, (long)namespaces.size());
        Assert.assertTrue((boolean)namespaces.contains(ns1));
        hbaseAdmin.removeReplicationPeer("1");
    }

    @Test
    public void testSetReplicateAllUserTables() throws Exception {
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        Assert.assertTrue((boolean)rpc.replicateAllUserTables());
        rpc.setReplicateAllUserTables(false);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        Assert.assertFalse((boolean)rpc.replicateAllUserTables());
        rpc.setReplicateAllUserTables(true);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        Assert.assertTrue((boolean)rpc.replicateAllUserTables());
        hbaseAdmin.removeReplicationPeer("1");
    }

    @Test
    public void testPeerExcludeNamespaces() throws Exception {
        String ns1 = "ns1";
        String ns2 = "ns2";
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        Assert.assertTrue((boolean)rpc.replicateAllUserTables());
        Set<String> namespaces = new HashSet<String>();
        namespaces.add(ns1);
        namespaces.add(ns2);
        rpc.setExcludeNamespaces(namespaces);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        namespaces = hbaseAdmin.getReplicationPeerConfig("1").getExcludeNamespaces();
        Assert.assertEquals((long)2L, (long)namespaces.size());
        Assert.assertTrue((boolean)namespaces.contains(ns1));
        Assert.assertTrue((boolean)namespaces.contains(ns2));
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        namespaces = new HashSet();
        namespaces.add(ns1);
        rpc.setExcludeNamespaces(namespaces);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        namespaces = hbaseAdmin.getReplicationPeerConfig("1").getExcludeNamespaces();
        Assert.assertEquals((long)1L, (long)namespaces.size());
        Assert.assertTrue((boolean)namespaces.contains(ns1));
        hbaseAdmin.removeReplicationPeer("1");
    }

    @Test
    public void testPeerExcludeTableCFs() throws Exception {
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        TableName tab1 = TableName.valueOf((String)"t1");
        TableName tab2 = TableName.valueOf((String)"t2");
        TableName tab3 = TableName.valueOf((String)"t3");
        TableName tab4 = TableName.valueOf((String)"t4");
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        Assert.assertTrue((boolean)rpc.replicateAllUserTables());
        HashMap tableCFs = new HashMap();
        tableCFs.put(tab1, null);
        rpc.setExcludeTableCFsMap(tableCFs);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        Map result = hbaseAdmin.getReplicationPeerConfig("1").getExcludeTableCFsMap();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)true, (Object)result.containsKey(tab1));
        Assert.assertNull(result.get(tab1));
        tableCFs.put(tab2, new ArrayList());
        ((List)tableCFs.get(tab2)).add("f1");
        rpc.setExcludeTableCFsMap(tableCFs);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        result = hbaseAdmin.getReplicationPeerConfig("1").getExcludeTableCFsMap();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tab1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tab2));
        Assert.assertNull(result.get(tab1));
        Assert.assertEquals((long)1L, (long)((List)result.get(tab2)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tab2)).get(0));
        tableCFs.clear();
        tableCFs.put(tab3, new ArrayList());
        tableCFs.put(tab4, new ArrayList());
        ((List)tableCFs.get(tab4)).add("f1");
        ((List)tableCFs.get(tab4)).add("f2");
        rpc.setExcludeTableCFsMap(tableCFs);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        result = hbaseAdmin.getReplicationPeerConfig("1").getExcludeTableCFsMap();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"Should contain t3", (boolean)result.containsKey(tab3));
        Assert.assertTrue((String)"Should contain t4", (boolean)result.containsKey(tab4));
        Assert.assertNull(result.get(tab3));
        Assert.assertEquals((long)2L, (long)((List)result.get(tab4)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tab4)).get(0));
        Assert.assertEquals((Object)"f2", ((List)result.get(tab4)).get(1));
        hbaseAdmin.removeReplicationPeer("1");
    }

    @Test
    public void testPeerConfigConflict() throws Exception {
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        String ns1 = "ns1";
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(ns1);
        TableName tab1 = TableName.valueOf((String)"ns2:tabl");
        HashMap tableCfs = new HashMap();
        tableCfs.put(tab1, new ArrayList());
        try {
            rpc.setNamespaces(namespaces);
            hbaseAdmin.addReplicationPeer("1", rpc);
            Assert.fail((String)"Should throw Exception. When replicate all flag is true, no need to config namespaces");
        }
        catch (IOException e) {
            rpc.setNamespaces(null);
        }
        try {
            rpc.setTableCFsMap(tableCfs);
            hbaseAdmin.addReplicationPeer("1", rpc);
            Assert.fail((String)"Should throw Exception. When replicate all flag is true, no need to config table-cfs");
        }
        catch (IOException e) {
            rpc.setTableCFsMap(null);
        }
        rpc.setReplicateAllUserTables(false);
        try {
            rpc.setExcludeNamespaces(namespaces);
            hbaseAdmin.addReplicationPeer("1", rpc);
            Assert.fail((String)"Should throw Exception. When replicate all flag is false, no need to config exclude namespaces");
        }
        catch (IOException e) {
            rpc.setExcludeNamespaces(null);
        }
        try {
            rpc.setExcludeTableCFsMap(tableCfs);
            hbaseAdmin.addReplicationPeer("1", rpc);
            Assert.fail((String)"Should throw Exception. When replicate all flag is false, no need to config exclude table-cfs");
        }
        catch (IOException e) {
            rpc.setExcludeTableCFsMap(null);
        }
        rpc.setNamespaces(namespaces);
        rpc.setTableCFsMap(tableCfs);
        hbaseAdmin.addReplicationPeer("1", rpc);
        ReplicationPeerConfig rpc2 = new ReplicationPeerConfig();
        rpc2.setClusterKey("127.0.0.1:2181:/hbase2");
        rpc2.setExcludeNamespaces(namespaces);
        rpc2.setExcludeTableCFsMap(tableCfs);
        hbaseAdmin.addReplicationPeer("2", rpc2);
        hbaseAdmin.removeReplicationPeer("1");
        hbaseAdmin.removeReplicationPeer("2");
    }

    @Test
    public void testNamespacesAndTableCfsConfigConflict() throws Exception {
        HashMap excludeTableCfs2;
        HashMap tableCfs2;
        String ns1 = "ns1";
        String ns2 = "ns2";
        TableName tableName1 = TableName.valueOf((String)(ns1 + ":" + this.name.getMethodName()));
        TableName tableName2 = TableName.valueOf((String)(ns2 + ":" + this.name.getMethodName() + "2"));
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        rpc.setReplicateAllUserTables(false);
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(ns1);
        rpc.setNamespaces(namespaces);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        try {
            tableCfs2 = new HashMap();
            tableCfs2.put(tableName1, new ArrayList());
            rpc.setTableCFsMap(tableCfs2);
            hbaseAdmin.updateReplicationPeerConfig("1", rpc);
            Assert.fail((String)("Should throw ReplicationException Because table " + tableName1 + " conflict with namespace " + ns1));
        }
        catch (Exception tableCfs2) {
            // empty catch block
        }
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        tableCfs2 = new HashMap();
        tableCfs2.put(tableName2, new ArrayList());
        rpc.setTableCFsMap(tableCfs2);
        hbaseAdmin.updateReplicationPeerConfig("1", rpc);
        rpc = hbaseAdmin.getReplicationPeerConfig("1");
        try {
            namespaces.clear();
            namespaces.add(ns2);
            rpc.setNamespaces(namespaces);
            hbaseAdmin.updateReplicationPeerConfig("1", rpc);
            Assert.fail((String)("Should throw ReplicationException Because namespace " + ns2 + " conflict with table " + tableName2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ReplicationPeerConfig rpc2 = new ReplicationPeerConfig();
        rpc2.setClusterKey("127.0.0.1:2181:/hbase2");
        hbaseAdmin.addReplicationPeer("2", rpc2);
        rpc2 = hbaseAdmin.getReplicationPeerConfig("2");
        HashSet<String> excludeNamespaces = new HashSet<String>();
        excludeNamespaces.add(ns1);
        rpc2.setExcludeNamespaces(excludeNamespaces);
        hbaseAdmin.updateReplicationPeerConfig("2", rpc2);
        rpc2 = hbaseAdmin.getReplicationPeerConfig("2");
        try {
            excludeTableCfs2 = new HashMap();
            excludeTableCfs2.put(tableName1, new ArrayList());
            rpc2.setExcludeTableCFsMap(excludeTableCfs2);
            hbaseAdmin.updateReplicationPeerConfig("2", rpc2);
            Assert.fail((String)("Should throw ReplicationException Because exclude table " + tableName1 + " conflict with exclude namespace " + ns1));
        }
        catch (Exception excludeTableCfs2) {
            // empty catch block
        }
        rpc2 = hbaseAdmin.getReplicationPeerConfig("2");
        excludeTableCfs2 = new HashMap();
        excludeTableCfs2.put(tableName2, new ArrayList());
        rpc2.setExcludeTableCFsMap(excludeTableCfs2);
        hbaseAdmin.updateReplicationPeerConfig("2", rpc2);
        rpc2 = hbaseAdmin.getReplicationPeerConfig("2");
        try {
            namespaces.clear();
            namespaces.add(ns2);
            rpc2.setNamespaces(namespaces);
            hbaseAdmin.updateReplicationPeerConfig("2", rpc2);
            Assert.fail((String)("Should throw ReplicationException Because exclude namespace " + ns2 + " conflict with exclude table " + tableName2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        hbaseAdmin.removeReplicationPeer("1");
        hbaseAdmin.removeReplicationPeer("2");
    }

    @Test
    public void testPeerBandwidth() throws Exception {
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = admin.getPeerConfig("1");
        Assert.assertEquals((long)0L, (long)rpc.getBandwidth());
        rpc.setBandwidth(0x200000L);
        admin.updatePeerConfig("1", rpc);
        Assert.assertEquals((long)0x200000L, (long)admin.getPeerConfig("1").getBandwidth());
        admin.removePeer("1");
    }

    @Test
    public void testPeerClusterKey() throws Exception {
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder();
        builder.setClusterKey("127.0.0.1:2181:/hbase");
        hbaseAdmin.addReplicationPeer("1", builder.build());
        try {
            builder.setClusterKey("127.0.0.1:2181:/hbase2");
            hbaseAdmin.updateReplicationPeerConfig("1", builder.build());
            Assert.fail((String)"Change cluster key on an existing peer is not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPeerReplicationEndpointImpl() throws Exception {
        ReplicationPeerConfigBuilder builder = ReplicationPeerConfig.newBuilder();
        builder.setClusterKey("127.0.0.1:2181:/hbase");
        builder.setReplicationEndpointImpl(DummyReplicationEndpoint.class.getName());
        hbaseAdmin.addReplicationPeer("1", builder.build());
        try {
            builder.setReplicationEndpointImpl(TestReplicationEndpoint.InterClusterReplicationEndpointForTest.class.getName());
            hbaseAdmin.updateReplicationPeerConfig("1", builder.build());
            Assert.fail((String)"Change replication endpoint implementation class on an existing peer is not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            builder = ReplicationPeerConfig.newBuilder();
            builder.setClusterKey("127.0.0.1:2181:/hbase");
            hbaseAdmin.updateReplicationPeerConfig("1", builder.build());
            Assert.fail((String)"Change replication endpoint implementation class on an existing peer is not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        builder = ReplicationPeerConfig.newBuilder();
        builder.setClusterKey("127.0.0.1:2181:/hbase2");
        hbaseAdmin.addReplicationPeer("2", builder.build());
        try {
            builder.setReplicationEndpointImpl(DummyReplicationEndpoint.class.getName());
            hbaseAdmin.updateReplicationPeerConfig("2", builder.build());
            Assert.fail((String)"Change replication endpoint implementation class on an existing peer is not allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

