/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutputHelper;
import org.apache.hadoop.hbase.io.asyncfs.TestFanOutOneBlockAsyncDFSOutput;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.token.TestGenerateDelegationToken;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MiscTests.class, LargeTests.class})
public class TestSaslFanOutOneBlockAsyncDFSOutput {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSaslFanOutOneBlockAsyncDFSOutput.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static DistributedFileSystem FS;
    private static EventLoopGroup EVENT_LOOP_GROUP;
    private static Class<? extends Channel> CHANNEL_CLASS;
    private static int READ_TIMEOUT_MS;
    private static final File KEYTAB_FILE;
    private static MiniKdc KDC;
    private static String HOST;
    private static String USERNAME;
    private static String PRINCIPAL;
    private static String HTTP_PRINCIPAL;
    private static String TEST_KEY_NAME;
    @Rule
    public TestName name = new TestName();
    @Parameterized.Parameter(value=0)
    public String protection;
    @Parameterized.Parameter(value=1)
    public String encryptionAlgorithm;
    @Parameterized.Parameter(value=2)
    public String cipherSuite;
    private Path testDirOnTestFs;
    private Path entryptionTestDirOnTestFs;

    @Parameterized.Parameters(name="{index}: protection={0}, encryption={1}, cipherSuite={2}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String protection : Arrays.asList("authentication", "integrity", "privacy")) {
            for (String encryptionAlgorithm : Arrays.asList("", "3des", "rc4")) {
                for (String cipherSuite : Arrays.asList("", CipherSuite.AES_CTR_NOPADDING.getName())) {
                    params.add(new Object[]{protection, encryptionAlgorithm, cipherSuite});
                }
            }
        }
        return params;
    }

    private static void setHdfsSecuredConfiguration(Configuration conf) throws Exception {
        conf.set("dfs.namenode.kerberos.principal", PRINCIPAL + "@" + KDC.getRealm());
        conf.set("dfs.namenode.keytab.file", KEYTAB_FILE.getAbsolutePath());
        conf.set("dfs.datanode.kerberos.principal", PRINCIPAL + "@" + KDC.getRealm());
        conf.set("dfs.datanode.keytab.file", KEYTAB_FILE.getAbsolutePath());
        conf.set("dfs.web.authentication.kerberos.principal", HTTP_PRINCIPAL + "@" + KDC.getRealm());
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        File keystoresDir = new File(TEST_UTIL.getDataTestDir("keystore").toUri().getPath());
        keystoresDir.mkdirs();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestGenerateDelegationToken.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir.getAbsolutePath(), (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.setBoolean("ignore.secure.ports.for.testing", true);
    }

    private static void setUpKeyProvider(Configuration conf) throws Exception {
        URI keyProviderUri = new URI("jceks://file" + TEST_UTIL.getDataTestDir("test.jks").toUri().toString());
        conf.set("dfs.encryption.key.provider.uri", keyProviderUri.toString());
        KeyProvider keyProvider = KeyProviderFactory.get((URI)keyProviderUri, (Configuration)conf);
        keyProvider.createKey(TEST_KEY_NAME, KeyProvider.options((Configuration)conf));
        keyProvider.flush();
        keyProvider.close();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        EVENT_LOOP_GROUP = new NioEventLoopGroup();
        CHANNEL_CLASS = NioSocketChannel.class;
        TEST_UTIL.getConfiguration().setInt("dfs.client.socket-timeout", READ_TIMEOUT_MS);
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        USERNAME = UserGroupInformation.getLoginUser().getShortUserName();
        PRINCIPAL = USERNAME + "/" + HOST;
        HTTP_PRINCIPAL = "HTTP/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL, HTTP_PRINCIPAL});
        TestSaslFanOutOneBlockAsyncDFSOutput.setUpKeyProvider(TEST_UTIL.getConfiguration());
        TestSaslFanOutOneBlockAsyncDFSOutput.setHdfsSecuredConfiguration(TEST_UTIL.getConfiguration());
        HBaseKerberosUtils.setPrincipalForTesting(PRINCIPAL + "@" + KDC.getRealm());
        HBaseKerberosUtils.setSecuredConfiguration(TEST_UTIL.getConfiguration());
        UserGroupInformation.setConfiguration((Configuration)TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException, InterruptedException {
        if (EVENT_LOOP_GROUP != null) {
            EVENT_LOOP_GROUP.shutdownGracefully().sync();
        }
        if (KDC != null) {
            KDC.stop();
        }
    }

    private void createEncryptionZone() throws Exception {
        Method method = DistributedFileSystem.class.getMethod("createEncryptionZone", Path.class, String.class);
        method.invoke((Object)FS, this.entryptionTestDirOnTestFs, TEST_KEY_NAME);
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getConfiguration().set("dfs.data.transfer.protection", this.protection);
        if (StringUtils.isBlank((CharSequence)this.encryptionAlgorithm) && StringUtils.isBlank((CharSequence)this.cipherSuite)) {
            TEST_UTIL.getConfiguration().setBoolean("dfs.encrypt.data.transfer", false);
        } else {
            TEST_UTIL.getConfiguration().setBoolean("dfs.encrypt.data.transfer", true);
        }
        if (StringUtils.isBlank((CharSequence)this.encryptionAlgorithm)) {
            TEST_UTIL.getConfiguration().unset("dfs.encrypt.data.transfer.algorithm");
        } else {
            TEST_UTIL.getConfiguration().set("dfs.encrypt.data.transfer.algorithm", this.encryptionAlgorithm);
        }
        if (StringUtils.isBlank((CharSequence)this.cipherSuite)) {
            TEST_UTIL.getConfiguration().unset("dfs.encrypt.data.transfer.cipher.suites");
        } else {
            TEST_UTIL.getConfiguration().set("dfs.encrypt.data.transfer.cipher.suites", this.cipherSuite);
        }
        TEST_UTIL.startMiniDFSCluster(3);
        FS = TEST_UTIL.getDFSCluster().getFileSystem();
        this.testDirOnTestFs = new Path("/" + this.name.getMethodName().replaceAll("[^0-9a-zA-Z]", "_"));
        FS.mkdirs(this.testDirOnTestFs);
        this.entryptionTestDirOnTestFs = new Path("/" + this.testDirOnTestFs.getName() + "_enc");
        FS.mkdirs(this.entryptionTestDirOnTestFs);
        this.createEncryptionZone();
    }

    @After
    public void tearDown() throws IOException {
        TEST_UTIL.shutdownMiniDFSCluster();
    }

    private Path getTestFile() {
        return new Path(this.testDirOnTestFs, "test");
    }

    private Path getEncryptionTestFile() {
        return new Path(this.entryptionTestDirOnTestFs, "test");
    }

    private void test(Path file) throws IOException, InterruptedException, ExecutionException {
        EventLoop eventLoop = EVENT_LOOP_GROUP.next();
        FanOutOneBlockAsyncDFSOutput out = FanOutOneBlockAsyncDFSOutputHelper.createOutput((DistributedFileSystem)FS, (Path)file, (boolean)true, (boolean)false, (short)3, (long)FS.getDefaultBlockSize(), (EventLoopGroup)eventLoop, CHANNEL_CLASS);
        TestFanOutOneBlockAsyncDFSOutput.writeAndVerify((FileSystem)FS, file, (AsyncFSOutput)out);
    }

    @Test
    public void test() throws IOException, InterruptedException, ExecutionException {
        this.test(this.getTestFile());
        this.test(this.getEncryptionTestFile());
    }

    static {
        READ_TIMEOUT_MS = 200000;
        KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
        HOST = "localhost";
        TEST_KEY_NAME = "test_key";
    }
}

