/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, MediumTests.class})
public class TestSeekBeforeWithInlineBlocks {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSeekBeforeWithInlineBlocks.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSeekBeforeWithInlineBlocks.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NUM_KV = 10000;
    private static final int DATA_BLOCK_SIZE = 4096;
    private static final int BLOOM_BLOCK_SIZE = 1024;
    private static final int[] INDEX_CHUNK_SIZES = new int[]{65536, 4096, 1024};
    private static final int[] EXPECTED_NUM_LEVELS = new int[]{1, 2, 3};
    private static final Random RAND = new Random(192537L);
    private static final byte[] FAM = Bytes.toBytes((String)"family");
    private FileSystem fs;
    private Configuration conf;

    @Test
    public void testMultiIndexLevelRandomHFileWithBlooms() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        for (int hfileVersion = 3; hfileVersion <= 3; ++hfileVersion) {
            this.conf.setInt("hfile.format.version", hfileVersion);
            this.fs = HFileSystem.get((Configuration)this.conf);
            for (BloomType bloomType : BloomType.values()) {
                for (int testI = 0; testI < INDEX_CHUNK_SIZES.length; ++testI) {
                    int indexBlockSize = INDEX_CHUNK_SIZES[testI];
                    int expectedNumLevels = EXPECTED_NUM_LEVELS[testI];
                    LOG.info(String.format("Testing HFileVersion: %s, BloomType: %s, Index Levels: %s", hfileVersion, bloomType, expectedNumLevels));
                    this.conf.setInt("hfile.index.block.max.size", indexBlockSize);
                    this.conf.setInt("io.storefile.bloom.block.size", 1024);
                    Cell[] cells = new Cell[10000];
                    Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), String.format("testMultiIndexLevelRandomHFileWithBlooms-%s-%s-%s", hfileVersion, bloomType, testI));
                    this.conf.setFloat("hfile.block.cache.size", 0.0f);
                    CacheConfig cacheConf = new CacheConfig(this.conf);
                    HFileContext meta = new HFileContextBuilder().withBlockSize(4096).build();
                    StoreFileWriter storeFileWriter = new StoreFileWriter.Builder(this.conf, cacheConf, this.fs).withFilePath(hfilePath).withFileContext(meta).withBloomType(bloomType).build();
                    for (int i = 0; i < 10000; ++i) {
                        byte[] row = RandomKeyValueUtil.randomOrderedKey(RAND, i);
                        byte[] qual = RandomKeyValueUtil.randomRowOrQualifier(RAND);
                        byte[] value = RandomKeyValueUtil.randomValue(RAND);
                        KeyValue kv = new KeyValue(row, FAM, qual, value);
                        storeFileWriter.append((Cell)kv);
                        cells[i] = kv;
                    }
                    storeFileWriter.close();
                    HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)hfilePath, (CacheConfig)cacheConf, (boolean)true, (Configuration)this.conf);
                    Assert.assertEquals((long)expectedNumLevels, (long)reader.getTrailer().getNumDataIndexLevels());
                    for (boolean pread : new boolean[]{false, true}) {
                        int i;
                        HFileScanner scanner = reader.getScanner(true, pread);
                        this.checkNoSeekBefore(cells, scanner, 0);
                        for (i = 1; i < 10000; ++i) {
                            this.checkSeekBefore(cells, scanner, i);
                            this.checkCell(cells[i - 1], scanner.getCell());
                        }
                        Assert.assertTrue((boolean)scanner.seekTo());
                        for (i = 9999; i >= 1; --i) {
                            this.checkSeekBefore(cells, scanner, i);
                            this.checkCell(cells[i - 1], scanner.getCell());
                        }
                        this.checkNoSeekBefore(cells, scanner, 0);
                        scanner.close();
                    }
                    reader.close();
                }
            }
        }
    }

    private void checkSeekBefore(Cell[] cells, HFileScanner scanner, int i) throws IOException {
        Assert.assertEquals((String)("Failed to seek to the key before #" + i + " (" + CellUtil.getCellKeyAsString((Cell)cells[i]) + ")"), (Object)true, (Object)scanner.seekBefore(cells[i]));
    }

    private void checkNoSeekBefore(Cell[] cells, HFileScanner scanner, int i) throws IOException {
        Assert.assertEquals((String)("Incorrectly succeeded in seeking to before first key (" + CellUtil.getCellKeyAsString((Cell)cells[i]) + ")"), (Object)false, (Object)scanner.seekBefore(cells[i]));
    }

    private void checkCell(Cell expected, Cell actual) {
        Assert.assertTrue((String)String.format("Expected key %s, but was %s", CellUtil.getCellKeyAsString((Cell)expected), CellUtil.getCellKeyAsString((Cell)actual)), (boolean)CellUtil.equals((Cell)expected, (Cell)actual));
    }
}

