/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Arrays;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterRepairMode {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterRepairMode.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterRepairMode.class);
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    private static HBaseTestingUtility TEST_UTIL;

    @Before
    public void setUp() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private void enableMaintenanceMode() {
        Configuration c = TEST_UTIL.getConfiguration();
        c.setBoolean("hbase.master.maintenance_mode", true);
        c.setInt("hbase.master.init.timeout.localHBaseCluster", 30000);
    }

    @Test
    public void testNewCluster() throws Exception {
        this.enableMaintenanceMode();
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.startMiniDFSCluster(3);
        TEST_UTIL.startMiniHBaseCluster(1, 0);
        Connection conn = TEST_UTIL.getConnection();
        Assert.assertTrue((boolean)conn.getAdmin().isMasterInMaintenanceMode());
        try (Table table = conn.getTable(TableName.META_TABLE_NAME);
             ResultScanner scanner = table.getScanner(new Scan());){
            Assert.assertNotNull((String)"Could not read meta.", (Object)scanner.next());
        }
    }

    @Test
    public void testExistingCluster() throws Exception {
        Throwable throwable;
        ResultScanner scanner;
        TableName testRepairMode = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.startMiniCluster();
        Table t = TEST_UTIL.createTable(testRepairMode, FAMILYNAME);
        Put p = new Put(Bytes.toBytes((String)"r"));
        p.addColumn(FAMILYNAME, Bytes.toBytes((String)"c"), new byte[0]);
        t.put(p);
        TEST_UTIL.shutdownMiniHBaseCluster();
        LOG.info("Starting master-only");
        this.enableMaintenanceMode();
        TEST_UTIL.startMiniHBaseCluster(1, 0);
        Connection conn = TEST_UTIL.getConnection();
        Assert.assertTrue((boolean)conn.getAdmin().isMasterInMaintenanceMode());
        try (Table table = conn.getTable(TableName.META_TABLE_NAME);){
            scanner = table.getScanner(HConstants.TABLE_FAMILY);
            throwable = null;
            try (Stream<Result> results = StreamSupport.stream(scanner.spliterator(), false);){
                Assert.assertTrue((String)"Did not find user table records while reading hbase:meta", (boolean)results.anyMatch(r -> Arrays.equals(r.getRow(), testRepairMode.getName())));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (scanner != null) {
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
        try {
            table = conn.getTable(testRepairMode);
            var6_7 = null;
            try {
                scanner = table.getScanner(new Scan());
                throwable = null;
                try {
                    scanner.next();
                    Assert.fail((String)"Should not be able to access user-space tables in repair mode.");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (scanner != null) {
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            scanner.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var6_7 = throwable6;
                throw throwable6;
            }
            finally {
                if (table != null) {
                    if (var6_7 != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable throwable7) {
                            var6_7.addSuppressed(throwable7);
                        }
                    } else {
                        table.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

