/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestMasterWALManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterWALManager.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterWALManager.class);
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private MasterWalManager mwm;
    private MasterServices masterServices;

    @Before
    public void before() throws IOException {
        MasterFileSystem mfs = (MasterFileSystem)Mockito.mock(MasterFileSystem.class);
        Mockito.when((Object)mfs.getWALFileSystem()).thenReturn((Object)HTU.getTestFileSystem());
        Path walRootDir = HTU.createWALRootDir();
        Mockito.when((Object)mfs.getWALRootDir()).thenReturn((Object)walRootDir);
        this.masterServices = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)this.masterServices.getConfiguration()).thenReturn((Object)HTU.getConfiguration());
        Mockito.when((Object)this.masterServices.getMasterFileSystem()).thenReturn((Object)mfs);
        Mockito.when((Object)this.masterServices.getServerName()).thenReturn((Object)ServerName.parseServerName((String)"master.example.org,0123,456"));
        this.mwm = new MasterWalManager(this.masterServices);
    }

    @Test
    public void testIsWALDirectoryNameWithWALs() throws IOException {
        ServerName sn = ServerName.parseServerName((String)"x.example.org,1234,5678");
        Assert.assertFalse((boolean)this.mwm.isWALDirectoryNameWithWALs(sn));
        FileSystem walFS = this.masterServices.getMasterFileSystem().getWALFileSystem();
        Path dir = new Path(this.mwm.getWALDirPath(), sn.toString());
        TestCase.assertTrue((boolean)walFS.mkdirs(dir));
        TestCase.assertTrue((boolean)this.mwm.isWALDirectoryNameWithWALs(sn));
        HashSet<ServerName> sns = new HashSet<ServerName>();
        sns.add(sn);
        List paths = this.mwm.createAndGetLogDirs(sns);
        TestCase.assertTrue((boolean)this.mwm.isWALDirectoryNameWithWALs(sn));
    }
}

