/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.MergeTableRegionsProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMergeTableRegionsProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMergeTableRegionsProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMergeTableRegionsProcedure.class);
    @Rule
    public final TestName name = new TestName();
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int initialRegionCount = 4;
    private static final byte[] FAMILY = Bytes.toBytes((String)"FAMILY");
    static final Configuration conf = UTIL.getConfiguration();
    private static Admin admin;
    private AssignmentManager am;
    private ProcedureMetrics mergeProcMetrics;
    private ProcedureMetrics assignProcMetrics;
    private ProcedureMetrics unassignProcMetrics;
    private long mergeSubmittedCount = 0L;
    private long mergeFailedCount = 0L;
    private long assignSubmittedCount = 0L;
    private long assignFailedCount = 0L;
    private long unassignSubmittedCount = 0L;
    private long unassignFailedCount = 0L;

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.assignment.maximum.attempts", 3);
        conf.setInt("hbase.master.maximum.ping.server.attempts", 3);
        conf.setInt("hbase.master.ping.server.retry.sleep.interval", 1);
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.setInt("hbase.master.urgent.procedure.threads", 0);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestMergeTableRegionsProcedure.setupConf(conf);
        UTIL.startMiniCluster(1);
        admin = UTIL.getHBaseAdmin();
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        this.resetProcExecutorTestingKillFlag();
        MasterProcedureTestingUtility.generateNonceGroup(UTIL.getHBaseCluster().getMaster());
        MasterProcedureTestingUtility.generateNonce(UTIL.getHBaseCluster().getMaster());
        UTIL.getHBaseAdmin().setBalancerRunning(false, true);
        UTIL.getHBaseCluster().getMaster().setCatalogJanitorEnabled(false);
        this.resetProcExecutorTestingKillFlag();
        this.am = UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        this.mergeProcMetrics = this.am.getAssignmentManagerMetrics().getMergeProcMetrics();
        this.assignProcMetrics = this.am.getAssignmentManagerMetrics().getAssignProcMetrics();
        this.unassignProcMetrics = this.am.getAssignmentManagerMetrics().getUnassignProcMetrics();
    }

    @After
    public void tearDown() throws Exception {
        this.resetProcExecutorTestingKillFlag();
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            UTIL.deleteTable(htd.getTableName());
        }
    }

    private void resetProcExecutorTestingKillFlag() {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        Assert.assertTrue((String)"expected executor to be running", (boolean)procExec.isRunning());
    }

    @Test
    public void testMergeTwoRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        List<RegionInfo> tableRegions = this.createTable(tableName);
        RegionInfo[] regionsToMerge = new RegionInfo[]{tableRegions.get(0), tableRegions.get(1)};
        this.collectAssignmentManagerMetrics();
        MergeTableRegionsProcedure proc = new MergeTableRegionsProcedure((MasterProcedureEnv)procExec.getEnvironment(), regionsToMerge, true);
        long procId = procExec.submitProcedure((Procedure)proc);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        this.assertRegionCount(tableName, 3);
        Assert.assertEquals((long)(this.mergeSubmittedCount + 1L), (long)this.mergeProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.mergeFailedCount, (long)this.mergeProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.assignSubmittedCount + 1L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.unassignSubmittedCount + 2L), (long)this.unassignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.unassignFailedCount, (long)this.unassignProcMetrics.getFailedCounter().getCount());
        Pair pair = MetaTableAccessor.getRegionsFromMergeQualifier((Connection)UTIL.getConnection(), (byte[])proc.getMergedRegion().getRegionName());
        Assert.assertTrue((pair.getFirst() != null && pair.getSecond() != null ? 1 : 0) != 0);
        UTIL.getHBaseCluster().getMaster().setCatalogJanitorEnabled(true);
        UTIL.getHBaseCluster().getMaster().getCatalogJanitor().triggerNow();
        while (pair != null && pair.getFirst() != null && pair.getSecond() != null) {
            pair = MetaTableAccessor.getRegionsFromMergeQualifier((Connection)UTIL.getConnection(), (byte[])proc.getMergedRegion().getRegionName());
        }
    }

    @Test
    public void testMergeRegionsConcurrently() throws Exception {
        TableName tableName = TableName.valueOf((String)"testMergeRegionsConcurrently");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        List<RegionInfo> tableRegions = this.createTable(tableName);
        RegionInfo[] regionsToMerge1 = new RegionInfo[2];
        RegionInfo[] regionsToMerge2 = new RegionInfo[2];
        regionsToMerge1[0] = tableRegions.get(0);
        regionsToMerge1[1] = tableRegions.get(1);
        regionsToMerge2[0] = tableRegions.get(2);
        regionsToMerge2[1] = tableRegions.get(3);
        this.collectAssignmentManagerMetrics();
        long procId1 = procExec.submitProcedure((Procedure)new MergeTableRegionsProcedure((MasterProcedureEnv)procExec.getEnvironment(), regionsToMerge1, true));
        long procId2 = procExec.submitProcedure((Procedure)new MergeTableRegionsProcedure((MasterProcedureEnv)procExec.getEnvironment(), regionsToMerge2, true));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId2);
        this.assertRegionCount(tableName, 2);
        Assert.assertEquals((long)(this.mergeSubmittedCount + 2L), (long)this.mergeProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.mergeFailedCount, (long)this.mergeProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.assignSubmittedCount + 2L), (long)this.assignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.assignFailedCount, (long)this.assignProcMetrics.getFailedCounter().getCount());
        Assert.assertEquals((long)(this.unassignSubmittedCount + 4L), (long)this.unassignProcMetrics.getSubmittedCounter().getCount());
        Assert.assertEquals((long)this.unassignFailedCount, (long)this.unassignProcMetrics.getFailedCounter().getCount());
    }

    @Test
    public void testRecoveryAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRecoveryAndDoubleExecution");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        List<RegionInfo> tableRegions = this.createTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        RegionInfo[] regionsToMerge = new RegionInfo[]{tableRegions.get(0), tableRegions.get(1)};
        long procId = procExec.submitProcedure((Procedure)new MergeTableRegionsProcedure((MasterProcedureEnv)procExec.getEnvironment(), regionsToMerge, true));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        this.assertRegionCount(tableName, 3);
    }

    @Test
    public void testRollbackAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRollbackAndDoubleExecution");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        List<RegionInfo> tableRegions = this.createTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        RegionInfo[] regionsToMerge = new RegionInfo[]{tableRegions.get(0), tableRegions.get(1)};
        long procId = procExec.submitProcedure((Procedure)new MergeTableRegionsProcedure((MasterProcedureEnv)procExec.getEnvironment(), regionsToMerge, true));
        int lastStep = 8;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, lastStep, true);
        Assert.assertEquals((long)4L, (long)UTIL.getAdmin().getRegions(tableName).size());
        UTIL.waitUntilAllRegionsAssigned(tableName);
        List<HRegion> regions = UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)4L, (long)regions.size());
    }

    @Test
    public void testMergeWithoutPONR() throws Exception {
        TableName tableName = TableName.valueOf((String)"testMergeWithoutPONR");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        List<RegionInfo> tableRegions = this.createTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        RegionInfo[] regionsToMerge = new RegionInfo[]{tableRegions.get(0), tableRegions.get(1)};
        long procId = procExec.submitProcedure((Procedure)new MergeTableRegionsProcedure((MasterProcedureEnv)procExec.getEnvironment(), regionsToMerge, true));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, 9, false);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        MasterProcedureTestingUtility.restartMasterProcedureExecutor(procExec);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        this.assertRegionCount(tableName, 3);
    }

    private List<RegionInfo> createTable(TableName tableName) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY));
        byte[][] splitRows = new byte[3][];
        for (int i = 0; i < splitRows.length; ++i) {
            splitRows[i] = Bytes.toBytes((String)String.format("%d", i));
        }
        admin.createTable((TableDescriptor)desc, (byte[][])splitRows);
        return this.assertRegionCount(tableName, 4);
    }

    public List<RegionInfo> assertRegionCount(TableName tableName, int nregions) throws Exception {
        UTIL.waitUntilNoRegionsInTransition();
        List tableRegions = admin.getRegions(tableName);
        Assert.assertEquals((long)nregions, (long)tableRegions.size());
        return tableRegions;
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    private void collectAssignmentManagerMetrics() {
        this.mergeSubmittedCount = this.mergeProcMetrics.getSubmittedCounter().getCount();
        this.mergeFailedCount = this.mergeProcMetrics.getFailedCounter().getCount();
        this.assignSubmittedCount = this.assignProcMetrics.getSubmittedCounter().getCount();
        this.assignFailedCount = this.assignProcMetrics.getFailedCounter().getCount();
        this.unassignSubmittedCount = this.unassignProcMetrics.getSubmittedCounter().getCount();
        this.unassignFailedCount = this.unassignProcMetrics.getFailedCounter().getCount();
    }
}

