/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestHFileLinkCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileLinkCleaner.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @Test
    public void testHFileLinkCleaning() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        FSUtils.setRootDir((Configuration)conf, (Path)TEST_UTIL.getDataTestDir());
        conf.set("hbase.master.hfilecleaner.plugins", HFileLinkCleaner.class.getName());
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName tableLinkName = TableName.valueOf((String)(this.name.getMethodName() + "-link"));
        String hfileName = "1234567890";
        String familyName = "cf";
        HRegionInfo hri = new HRegionInfo(tableName);
        HRegionInfo hriLink = new HRegionInfo(tableLinkName);
        Path archiveDir = HFileArchiveUtil.getArchivePath((Configuration)conf);
        Path archiveStoreDir = HFileArchiveUtil.getStoreArchivePath((Configuration)conf, (TableName)tableName, (String)hri.getEncodedName(), (String)"cf");
        Path archiveLinkStoreDir = HFileArchiveUtil.getStoreArchivePath((Configuration)conf, (TableName)tableLinkName, (String)hriLink.getEncodedName(), (String)"cf");
        Path familyPath = TestHFileLinkCleaner.getFamilyDirPath(archiveDir, tableName, hri.getEncodedName(), "cf");
        fs.mkdirs(familyPath);
        Path hfilePath = new Path(familyPath, "1234567890");
        fs.createNewFile(hfilePath);
        Path familyLinkPath = TestHFileLinkCleaner.getFamilyDirPath(rootDir, tableLinkName, hriLink.getEncodedName(), "cf");
        fs.mkdirs(familyLinkPath);
        HFileLink.create((Configuration)conf, (FileSystem)fs, (Path)familyLinkPath, (RegionInfo)hri, (String)"1234567890");
        Path linkBackRefDir = HFileLink.getBackReferencesDir((Path)archiveStoreDir, (String)"1234567890");
        Assert.assertTrue((boolean)fs.exists(linkBackRefDir));
        FileStatus[] backRefs = fs.listStatus(linkBackRefDir);
        Assert.assertEquals((long)1L, (long)backRefs.length);
        Path linkBackRef = backRefs[0].getPath();
        long ttl = 1000L;
        conf.setLong("hbase.master.hfilecleaner.ttl", 1000L);
        DummyServer server = new DummyServer();
        CleanerChore.initChorePool((Configuration)conf);
        HFileCleaner cleaner = new HFileCleaner(1000, (Stoppable)server, conf, fs, archiveDir);
        cleaner.chore();
        Assert.assertTrue((boolean)fs.exists(linkBackRef));
        Assert.assertTrue((boolean)fs.exists(hfilePath));
        fs.rename(FSUtils.getTableDir((Path)rootDir, (TableName)tableLinkName), FSUtils.getTableDir((Path)archiveDir, (TableName)tableLinkName));
        cleaner.chore();
        Assert.assertFalse((String)"Link should be deleted", (boolean)fs.exists(linkBackRef));
        Thread.sleep(2000L);
        cleaner.chore();
        Assert.assertFalse((String)"HFile should be deleted", (boolean)fs.exists(hfilePath));
        for (int i = 0; i < 4; ++i) {
            Thread.sleep(2000L);
            cleaner.chore();
        }
        Assert.assertFalse((String)"HFile should be deleted", (boolean)fs.exists(FSUtils.getTableDir((Path)archiveDir, (TableName)tableName)));
        Assert.assertFalse((String)"Link should be deleted", (boolean)fs.exists(FSUtils.getTableDir((Path)archiveDir, (TableName)tableLinkName)));
    }

    private static Path getFamilyDirPath(Path rootDir, TableName table, String region, String family) {
        return new Path(new Path(FSUtils.getTableDir((Path)rootDir, (TableName)table), region), family);
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        public ZKWatcher getZooKeeper() {
            try {
                return new ZKWatcher(this.getConfiguration(), "dummy server", (Abortable)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)"regionserver,60020,000000");
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }
}

