/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.master.procedure.EnableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestEnableTableProcedure
extends TestTableDDLProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEnableTableProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestEnableTableProcedure.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testEnableTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        long procId = procExec.submitProcedure((Procedure)new EnableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        MasterProcedureTestingUtility.validateTableIsEnabled(this.getMaster(), tableName);
    }

    @Test(expected=TableNotDisabledException.class)
    public void testEnableNonDisabledTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2");
        long procId1 = procExec.submitProcedure((Procedure)new EnableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        Procedure result = procExec.getResult(procId1);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug("Enable failed with exception: " + result.getException());
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof TableNotDisabledException));
        long procId2 = procExec.submitProcedure((Procedure)new EnableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, true));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId2);
        ProcedurePrepareLatch.CompatibilityLatch prepareLatch = new ProcedurePrepareLatch.CompatibilityLatch();
        long procId3 = procExec.submitProcedure((Procedure)new EnableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false, (ProcedurePrepareLatch)prepareLatch));
        prepareLatch.await();
        Assert.fail((String)"Enable should throw exception through latch.");
    }

    @Test
    public void testRecoveryAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        MasterProcedureTestingUtility.createTable(procExec, tableName, splitKeys, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new EnableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        MasterProcedureTestingUtility.validateTableIsEnabled(this.getMaster(), tableName);
    }

    @Test
    public void testRollbackAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        MasterProcedureTestingUtility.createTable(procExec, tableName, splitKeys, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new EnableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        int lastStep = 3;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, lastStep);
        MasterProcedureTestingUtility.validateTableIsDisabled(this.getMaster(), tableName);
    }
}

