/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestCleanupMetaWAL {
    private static final Logger LOG = LoggerFactory.getLogger(TestCleanupMetaWAL.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCleanupMetaWAL.class);

    @BeforeClass
    public static void before() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void after() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testCleanupMetaWAL() throws Exception {
        TEST_UTIL.createTable(TableName.valueOf((String)"test"), "cf");
        HRegionServer serverWithMeta = TEST_UTIL.getMiniHBaseCluster().getRegionServer(TEST_UTIL.getMiniHBaseCluster().getServerWithMeta());
        TEST_UTIL.getAdmin().move(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), null);
        LOG.info("KILL");
        TEST_UTIL.getMiniHBaseCluster().killRegionServer(serverWithMeta.getServerName());
        LOG.info("WAIT");
        TEST_UTIL.waitFor(30000L, () -> TEST_UTIL.getMiniHBaseCluster().getMaster().getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure && p.isFinished()).count() > 0L);
        LOG.info("DONE WAITING");
        MasterFileSystem fs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path walPath = new Path(fs.getWALRootDir(), "WALs");
        for (FileStatus status : FSUtils.listStatus((FileSystem)fs.getFileSystem(), (Path)walPath)) {
            if (!status.getPath().toString().contains("-splitting")) continue;
            Assert.fail((String)("Should not have splitting wal dir here:" + status));
        }
    }
}

