/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.MetricsHeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.MetricsHeapMemoryManagerSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMetricsHeapMemoryManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsHeapMemoryManager.class);
    public static MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilitySingletonFactory.getInstance(MetricsAssertHelper.class);
    private MetricsHeapMemoryManager hmm;
    private MetricsHeapMemoryManagerSource source;

    @Before
    public void setUp() {
        this.hmm = new MetricsHeapMemoryManager();
        this.source = this.hmm.getMetricsSource();
    }

    @Test
    public void testConstuctor() {
        Assert.assertNotNull((String)"There should be a hadoop1/hadoop2 metrics source", (Object)this.source);
    }

    @Test
    public void testCounter() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.hmm.increaseAboveHeapOccupancyLowWatermarkCounter();
        }
        for (i = 0; i < 11; ++i) {
            this.hmm.increaseTunerDoNothingCounter();
        }
        HELPER.assertCounter("aboveHeapOccupancyLowWaterMarkCounter", 10L, (BaseSource)this.source);
        HELPER.assertCounter("tunerDoNothingCounter", 11L, (BaseSource)this.source);
    }

    @Test
    public void testGauge() {
        this.hmm.updateBlockedFlushCount(200L);
        this.hmm.updateUnblockedFlushCount(50L);
        this.hmm.setCurMemStoreSizeGauge(0x10000000L);
        this.hmm.setCurBlockCacheSizeGauge(0x6400000L);
        HELPER.assertGauge("blockedFlushGauge", 200L, (BaseSource)this.source);
        HELPER.assertGauge("unblockedFlushGauge", 50L, (BaseSource)this.source);
        HELPER.assertGauge("memStoreSize", 0x10000000L, (BaseSource)this.source);
        HELPER.assertGauge("blockCacheSize", 0x6400000L, (BaseSource)this.source);
    }
}

