/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationListener;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationTrackerZKImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationTrackerZKImpl.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationTrackerZKImpl.class);
    private static Configuration conf;
    private static HBaseTestingUtility utility;
    private ZKWatcher zkw;
    private ReplicationPeers rp;
    private ReplicationTracker rt;
    private AtomicInteger rsRemovedCount;
    private String rsRemovedData;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        utility = new HBaseTestingUtility();
        utility.startMiniZKCluster();
        conf = utility.getConfiguration();
        ZKWatcher zk = HBaseTestingUtility.getZooKeeperWatcher((HBaseZKTestingUtility)utility);
        ZKUtil.createWithParents((ZKWatcher)zk, (String)zk.getZNodePaths().rsZNode);
    }

    @Before
    public void setUp() throws Exception {
        this.zkw = HBaseTestingUtility.getZooKeeperWatcher((HBaseZKTestingUtility)utility);
        String fakeRs1 = ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().rsZNode, (String)"hostname1.example.org:1234");
        try {
            ZKClusterId.setClusterId((ZKWatcher)this.zkw, (ClusterId)new ClusterId());
            this.rp = ReplicationFactory.getReplicationPeers((ZKWatcher)this.zkw, (Configuration)conf);
            this.rp.init();
            this.rt = ReplicationFactory.getReplicationTracker((ZKWatcher)this.zkw, (Abortable)new DummyServer(fakeRs1), (Stoppable)new DummyServer(fakeRs1));
        }
        catch (Exception e) {
            Assert.fail((String)("Exception during test setup: " + e));
        }
        this.rsRemovedCount = new AtomicInteger(0);
        this.rsRemovedData = "";
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility.shutdownMiniZKCluster();
    }

    @Test
    public void testGetListOfRegionServers() throws Exception {
        Assert.assertEquals((long)0L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.createWithParents((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().rsZNode, (String)"hostname1.example.org:1234"));
        Assert.assertEquals((long)1L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.createWithParents((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().rsZNode, (String)"hostname2.example.org:1234"));
        Assert.assertEquals((long)2L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.deleteNode((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().rsZNode, (String)"hostname2.example.org:1234"));
        Assert.assertEquals((long)1L, (long)this.rt.getListOfRegionServers().size());
        ZKUtil.deleteNode((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().rsZNode, (String)"hostname1.example.org:1234"));
        Assert.assertEquals((long)0L, (long)this.rt.getListOfRegionServers().size());
    }

    @Test
    public void testRegionServerRemovedEvent() throws Exception {
        ZKUtil.createAndWatch((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().rsZNode, (String)"hostname2.example.org:1234"), (byte[])HConstants.EMPTY_BYTE_ARRAY);
        this.rt.registerListener((ReplicationListener)new DummyReplicationListener());
        ZKUtil.deleteNode((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().rsZNode, (String)"hostname2.example.org:1234"));
        while (this.rsRemovedCount.get() < 1) {
            Thread.sleep(5L);
        }
        Assert.assertEquals((Object)"hostname2.example.org:1234", (Object)this.rsRemovedData);
    }

    @Test
    public void testPeerNameControl() throws Exception {
        int exists;
        block2: {
            exists = 0;
            this.rp.getPeerStorage().addPeer("6", ReplicationPeerConfig.newBuilder().setClusterKey(utility.getClusterKey()).build(), true);
            try {
                this.rp.getPeerStorage().addPeer("6", ReplicationPeerConfig.newBuilder().setClusterKey(utility.getClusterKey()).build(), true);
            }
            catch (ReplicationException e) {
                if (!(e.getCause() instanceof KeeperException.NodeExistsException)) break block2;
                ++exists;
            }
        }
        Assert.assertEquals((long)1L, (long)exists);
        this.rp.getPeerStorage().removePeer("6");
    }

    private class DummyServer
    implements Server {
        private String serverName;
        private boolean isAborted = false;
        private boolean isStopped = false;

        public DummyServer(String serverName) {
            this.serverName = serverName;
        }

        public Configuration getConfiguration() {
            return conf;
        }

        public ZKWatcher getZooKeeper() {
            return TestReplicationTrackerZKImpl.this.zkw;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.serverName);
        }

        public void abort(String why, Throwable e) {
            LOG.info("Aborting " + this.serverName);
            this.isAborted = true;
        }

        public boolean isAborted() {
            return this.isAborted;
        }

        public void stop(String why) {
            this.isStopped = true;
        }

        public boolean isStopped() {
            return this.isStopped;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }

    private class DummyReplicationListener
    implements ReplicationListener {
        private DummyReplicationListener() {
        }

        public void regionServerRemoved(String regionServer) {
            TestReplicationTrackerZKImpl.this.rsRemovedData = regionServer;
            TestReplicationTrackerZKImpl.this.rsRemovedCount.getAndIncrement();
            LOG.debug("Received regionServerRemoved event: " + regionServer);
        }
    }
}

