/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.UnassignProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MoveRegionProcedure
extends AbstractStateMachineRegionProcedure<MasterProcedureProtos.MoveRegionState> {
    private static final Logger LOG = LoggerFactory.getLogger(MoveRegionProcedure.class);
    private RegionPlan plan;

    public MoveRegionProcedure() {
    }

    @VisibleForTesting
    protected RegionPlan getPlan() {
        return this.plan;
    }

    public MoveRegionProcedure(MasterProcedureEnv env, RegionPlan plan, boolean check) throws HBaseIOException {
        super(env, plan.getRegionInfo());
        this.plan = plan;
        if (check) {
            this.preflightChecks(env, true);
            MoveRegionProcedure.checkOnline(env, plan.getRegionInfo());
        }
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.MoveRegionState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        switch (state) {
            case MOVE_REGION_PREPARE: {
                try {
                    this.preflightChecks(env, true);
                    MoveRegionProcedure.checkOnline(env, this.plan.getRegionInfo());
                    if (!env.getMasterServices().getServerManager().isServerOnline(this.plan.getSource())) {
                        throw new HBaseIOException(this.plan.getSource() + " not online");
                    }
                    break;
                }
                catch (HBaseIOException e) {
                    LOG.warn(this.toString() + " FAILED because " + e.toString());
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            case MOVE_REGION_UNASSIGN: {
                try {
                    MoveRegionProcedure.checkOnline(env, this.plan.getRegionInfo());
                }
                catch (DoNotRetryRegionException dnrre) {
                    LOG.info("Skipping move, {} is not online; {}", new Object[]{this.getRegion().getEncodedName(), this, dnrre});
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                this.addChildProcedure(new UnassignProcedure[]{new UnassignProcedure(this.plan.getRegionInfo(), this.plan.getSource(), this.plan.getDestination(), true)});
                this.setNextState(MasterProcedureProtos.MoveRegionState.MOVE_REGION_ASSIGN);
                break;
            }
            case MOVE_REGION_ASSIGN: {
                AssignProcedure assignProcedure = this.plan.getDestination() == null ? new AssignProcedure(this.plan.getRegionInfo()) : new AssignProcedure(this.plan.getRegionInfo(), this.plan.getDestination());
                this.addChildProcedure(new AssignProcedure[]{assignProcedure});
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            default: {
                throw new UnsupportedOperationException("unhandled state=" + state);
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.MoveRegionState state) throws IOException {
    }

    public boolean abort(MasterProcedureEnv env) {
        return false;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" ");
        sb.append(this.plan);
    }

    protected MasterProcedureProtos.MoveRegionState getInitialState() {
        return MasterProcedureProtos.MoveRegionState.MOVE_REGION_UNASSIGN;
    }

    protected int getStateId(MasterProcedureProtos.MoveRegionState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.MoveRegionState getState(int stateId) {
        return MasterProcedureProtos.MoveRegionState.forNumber((int)stateId);
    }

    @Override
    public TableName getTableName() {
        return this.plan.getRegionInfo().getTable();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_EDIT;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.MoveRegionStateData.Builder state = MasterProcedureProtos.MoveRegionStateData.newBuilder().setSourceServer(ProtobufUtil.toServerName((ServerName)this.plan.getSource()));
        if (this.plan.getDestination() != null) {
            state.setDestinationServer(ProtobufUtil.toServerName((ServerName)this.plan.getDestination()));
        }
        serializer.serialize((Message)state.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.MoveRegionStateData state = (MasterProcedureProtos.MoveRegionStateData)serializer.deserialize(MasterProcedureProtos.MoveRegionStateData.class);
        RegionInfo regionInfo = this.getRegion();
        ServerName sourceServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)state.getSourceServer());
        ServerName destinationServer = state.hasDestinationServer() ? ProtobufUtil.toServerName((HBaseProtos.ServerName)state.getDestinationServer()) : null;
        this.plan = new RegionPlan(regionInfo, sourceServer, destinationServer);
    }
}

