/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.hbck.HFileCorruptionChecker;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class HFileContentValidator
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(HFileContentValidator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateHFileContent(Configuration conf) throws IOException {
        HFileCorruptionChecker checker;
        FileSystem fileSystem = FSUtils.getCurrentFileSystem((Configuration)conf);
        ExecutorService threadPool = this.createThreadPool(conf);
        try {
            checker = new HFileCorruptionChecker(conf, threadPool, false);
            Path rootDir = FSUtils.getRootDir((Configuration)conf);
            LOG.info("Validating HFile contents under {}", (Object)rootDir);
            List<Path> tableDirs = FSUtils.getTableDirs(fileSystem, rootDir);
            checker.checkTables(tableDirs);
            Path archiveRootDir = new Path(rootDir, "archive");
            LOG.info("Validating HFile contents under {}", (Object)archiveRootDir);
            List<Path> archiveTableDirs = FSUtils.getTableDirs(fileSystem, archiveRootDir);
            checker.checkTables(archiveTableDirs);
        }
        finally {
            threadPool.shutdown();
            try {
                threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        int checkedFiles = checker.getHFilesChecked();
        Collection<Path> corrupted = checker.getCorrupted();
        if (corrupted.isEmpty()) {
            LOG.info("Checked {} HFiles, none of them are corrupted.", (Object)checkedFiles);
            LOG.info("There are no incompatible HFiles.");
            return true;
        }
        LOG.info("Checked {} HFiles, {} are corrupted.", (Object)checkedFiles, (Object)corrupted.size());
        for (Path path : corrupted) {
            LOG.info("Corrupted file: {}", (Object)path);
        }
        LOG.info("Change data block encodings before upgrading. Check https://s.apache.org/prefixtree for instructions.");
        return false;
    }

    private ExecutorService createThreadPool(Configuration conf) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int numThreads = conf.getInt("hfilevalidator.numthreads", availableProcessors);
        return Executors.newFixedThreadPool(numThreads, Threads.getNamedThreadFactory((String)"hfile-validator"));
    }

    protected void addOptions() {
    }

    protected void processOptions(CommandLine cmd) {
    }

    protected int doWork() throws Exception {
        return this.validateHFileContent(this.getConf()) ? 0 : 1;
    }
}

