// Autogenerated Jamon implementation
// /home/relocate/hbase-source/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/RegionServerListTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 27, 9
import java.util.*;
// 28, 9
import org.apache.hadoop.hbase.master.HMaster;
// 29, 9
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
// 30, 9
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
// 31, 9
import org.apache.hadoop.hbase.RegionMetrics;
// 32, 9
import org.apache.hadoop.hbase.ServerMetrics;
// 33, 9
import org.apache.hadoop.hbase.ServerName;
// 34, 9
import org.apache.hadoop.hbase.Size;
// 35, 9
import org.apache.hadoop.hbase.util.VersionInfo;
// 36, 9
import org.apache.hadoop.hbase.util.Pair;
// 37, 9
import org.apache.hadoop.util.StringUtils.TraditionalBinaryPrefix;

public class RegionServerListTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.Intf

{
  private final HMaster master;
  private final List<ServerName> servers;
  protected static org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public RegionServerListTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 41, 1
    if ((servers != null && servers.size() > 0))
    {
      // 41, 47
      jamonWriter.write("\n\n");
      // 43, 1
      
ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
Arrays.sort(serverNames);

      // 48, 1
      jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_compactStats\" data-toggle=\"tab\">Compactions</a></li>\n        <li class=\"\"><a href=\"#tab_replicationStats\" data-toggle=\"tab\">Replications</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_baseStats\">\n            ");
      // 59, 13
      {
        // 59, 13
        __jamon_innerUnit__baseStats(jamonWriter, serverNames);
      }
      // 59, 56
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_memoryStats\">\n            ");
      // 62, 13
      {
        // 62, 13
        __jamon_innerUnit__memoryStats(jamonWriter, serverNames);
      }
      // 62, 58
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_requestStats\">\n            ");
      // 65, 13
      {
        // 65, 13
        __jamon_innerUnit__requestStats(jamonWriter, serverNames);
      }
      // 65, 59
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_storeStats\">\n            ");
      // 68, 13
      {
        // 68, 13
        __jamon_innerUnit__storeStats(jamonWriter, serverNames);
      }
      // 68, 57
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_compactStats\">\n            ");
      // 71, 13
      {
        // 71, 13
        __jamon_innerUnit__compactionStats(jamonWriter, serverNames);
      }
      // 71, 62
      jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_replicationStats\">\n            ");
      // 74, 13
      {
        // 74, 13
        __jamon_innerUnit__replicationStats(jamonWriter, serverNames);
      }
      // 74, 63
      jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }
    // 79, 7
    jamonWriter.write("\n\n");
  }
  
  
  // 81, 1
  private void __jamon_innerUnit__baseStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 85, 1
    jamonWriter.write("<table id=\"baseStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Start time</th>\n    <th>Last contact</th>\n    <th>Version</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n</tr>\n</thead>\n<tbody>\n");
    // 97, 1
    
    int totalRegions = 0;
    int totalRequestsPerSecond = 0;
    int inconsistentNodeNum = 0;
    String masterVersion = VersionInfo.getVersion();
    for (ServerName serverName: serverNames) {

    ServerMetrics sl = master.getServerManager().getLoad(serverName);
    String version = master.getRegionServerVersion(serverName);
    if (!masterVersion.equals(version)) {
        inconsistentNodeNum ++;
    }

    double requestsPerSecond = 0.0;
    int numRegionsOnline = 0;
    long lastContact = 0;

    if (sl != null) {
        requestsPerSecond = sl.getRequestCountPerSecond();
        numRegionsOnline = sl.getRegionMetrics().size();
        totalRegions += sl.getRegionMetrics().size();
        totalRequestsPerSecond += sl.getRequestCountPerSecond();
        lastContact = (System.currentTimeMillis() - sl.getReportTimestamp())/1000;
    }
    long startcode = serverName.getStartcode();

    // 123, 1
    jamonWriter.write("<tr>\n    <td>");
    // 124, 9
    {
      // 124, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 124, 53
    jamonWriter.write("</td>\n    <td>");
    // 125, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
    // 125, 34
    jamonWriter.write("</td>\n    <td>");
    // 126, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(lastContact, "s", 1)), jamonWriter);
    // 126, 71
    jamonWriter.write("</td>\n    <td>");
    // 127, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(version), jamonWriter);
    // 127, 22
    jamonWriter.write("</td>\n    <td>");
    // 128, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(String.format("%.0f", requestsPerSecond)), jamonWriter);
    // 128, 55
    jamonWriter.write("</td>\n    <td>");
    // 129, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numRegionsOnline), jamonWriter);
    // 129, 31
    jamonWriter.write("</td>\n</tr>\n");
    // 131, 1
    
}

    // 134, 1
    jamonWriter.write("</tbody>\n<tr><td>Total:");
    // 135, 15
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
    // 135, 35
    jamonWriter.write("</td>\n<td></td>\n<td></td>\n");
    // 138, 1
    if (inconsistentNodeNum > 0)
    {
      // 138, 31
      jamonWriter.write("\n  <td style=\"color:red;\">");
      // 139, 26
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(inconsistentNodeNum), jamonWriter);
      // 139, 51
      jamonWriter.write(" nodes with inconsistent version</td>\n");
    }
    // 140, 1
    else
    {
      // 140, 8
      jamonWriter.write("\n   <td></td>\n");
    }
    // 142, 7
    jamonWriter.write("\n<td>");
    // 143, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequestsPerSecond), jamonWriter);
    // 143, 33
    jamonWriter.write("</td>\n<td>");
    // 144, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
    // 144, 23
    jamonWriter.write("</td>\n</tr>\n</table>\n");
  }
  
  
  // 308, 1
  private void __jamon_innerUnit__compactionStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 312, 1
    jamonWriter.write("<table id=\"compactionStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Compacting Cells</th>\n    <th>Num. Compacted Cells</th>\n    <th>Remaining Cells</th>\n    <th>Compaction Progress</th>\n</tr>\n</thead>\n<tbody>\n");
    // 323, 1
    
for (ServerName serverName: serverNames) {

ServerMetrics sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
long totalCompactingCells = 0;
long totalCompactedCells = 0;
for (RegionMetrics rl : sl.getRegionMetrics().values()) {
  totalCompactingCells += rl.getCompactingCellCount();
  totalCompactedCells += rl.getCompactedCellCount();
}
String percentDone = "";
if  (totalCompactingCells > 0) {
     percentDone = String.format("%.2f", 100 *
        ((float) totalCompactedCells / totalCompactingCells)) + "%";
}

    // 340, 1
    jamonWriter.write("<tr>\n<td>");
    // 341, 5
    {
      // 341, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 341, 49
    jamonWriter.write("</td>\n<td>");
    // 342, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalCompactingCells), jamonWriter);
    // 342, 31
    jamonWriter.write("</td>\n<td>");
    // 343, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalCompactedCells), jamonWriter);
    // 343, 30
    jamonWriter.write("</td>\n<td>");
    // 344, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalCompactingCells - totalCompactedCells), jamonWriter);
    // 344, 53
    jamonWriter.write("</td>\n<td>");
    // 345, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(percentDone), jamonWriter);
    // 345, 22
    jamonWriter.write("</td>\n</tr>\n");
    // 347, 1
    
        }  else {
        
    // 350, 1
    {
      // 350, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 350, 40
    jamonWriter.write("\n");
    // 351, 1
    
    }
}

    // 355, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 441, 1
  private void __jamon_innerUnit__emptyStat(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 445, 5
    jamonWriter.write("<tr>\n    <td>");
    // 446, 9
    {
      // 446, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 446, 53
    jamonWriter.write("</td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    <td></td>\n    </tr>\n");
  }
  
  
  // 149, 1
  private void __jamon_innerUnit__memoryStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 153, 1
    jamonWriter.write("<table id=\"memoryStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n</thead>\n<tbody>\n");
    // 164, 1
    
for (ServerName serverName: serverNames) {

    ServerMetrics sl = master.getServerManager().getLoad(serverName);
    if (sl != null) {
      long memStoreSizeMB = 0;
      for (RegionMetrics rl : sl.getRegionMetrics().values()) {
        memStoreSizeMB += rl.getMemStoreSize().get(Size.Unit.MEGABYTE);
      }

    // 174, 1
    jamonWriter.write("<tr>\n    <td>");
    // 175, 9
    {
      // 175, 9
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 175, 53
    jamonWriter.write("</td>\n    <td>");
    // 176, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String((long) sl.getUsedHeapSize().get(Size.Unit.MEGABYTE)
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 177, 55
    jamonWriter.write("</td>\n    <td>");
    // 178, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String((long) sl.getMaxHeapSize().get(Size.Unit.MEGABYTE)
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 179, 55
    jamonWriter.write("</td>\n    <td>");
    // 180, 9
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(memStoreSizeMB
      * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 181, 55
    jamonWriter.write("</td>\n\n</tr>\n");
    // 184, 1
    
        }  else {

    // 187, 1
    {
      // 187, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 187, 40
    jamonWriter.write("\n");
    // 188, 1
    
        }
}

    // 192, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 359, 1
  private void __jamon_innerUnit__replicationStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 363, 1
    
        HashMap<String, List<Pair<ServerName, ReplicationLoadSource>>> replicationLoadSourceMap
            = master.getReplicationLoad(serverNames);
        List<String> peers = null;
        if (replicationLoadSourceMap != null && replicationLoadSourceMap.size() > 0){
            peers = new ArrayList<>(replicationLoadSourceMap.keySet());
            Collections.sort(peers);
        }

    // 373, 1
    if ((replicationLoadSourceMap != null && replicationLoadSourceMap.size() > 0) )
    {
      // 373, 82
      jamonWriter.write("\n\n<div class=\"tabbable\">\n    <ul class=\"nav nav-tabs\">\n        ");
      // 377, 9
      
        String active = "active";
        for (String peer : peers){
        
      // 381, 13
      jamonWriter.write("<li class=");
      // 381, 23
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(active), jamonWriter);
      // 381, 35
      jamonWriter.write("><a href=\"#tab_");
      // 381, 50
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 381, 60
      jamonWriter.write("\" data-toggle=\"tab\">Peer ");
      // 381, 85
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 381, 95
      jamonWriter.write("</a> </li>\n        ");
      // 382, 9
      
        active = "";
        }
        
      // 386, 5
      jamonWriter.write("</ul>\n    <div class=\"tab-content\">\n        ");
      // 388, 9
      
            active = "active";
            for (String peer : peers){
        
      // 392, 13
      jamonWriter.write("<div class=\"tab-pane ");
      // 392, 34
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(active), jamonWriter);
      // 392, 46
      jamonWriter.write("\" id=\"tab_");
      // 392, 56
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(peer), jamonWriter);
      // 392, 66
      jamonWriter.write("\">\n                <table class=\"table table-striped\">\n                    <tr>\n                        <th>Server</th>\n                        <th>AgeOfLastShippedOp</th>\n                        <th>SizeOfLogQueue</th>\n                        <th>ReplicationLag</th>\n                    </tr>\n\n                    ");
      // 401, 21
      for (Pair<ServerName, ReplicationLoadSource> pair: replicationLoadSourceMap.get(peer) )
      {
        // 401, 110
        jamonWriter.write("\n                    <tr>\n                        <td>");
        // 403, 29
        {
          // 403, 29
          __jamon_innerUnit__serverNameLink(jamonWriter, pair.getFirst());
        }
        // 403, 78
        jamonWriter.write("</td>\n                        <td>");
        // 404, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.humanTimeDiff(pair.getSecond().getAgeOfLastShippedOp())), jamonWriter);
        // 404, 102
        jamonWriter.write("</td>\n                        <td>");
        // 405, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(pair.getSecond().getSizeOfLogQueue()), jamonWriter);
        // 405, 71
        jamonWriter.write("</td>\n                        <td>");
        // 406, 29
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(pair.getSecond().getReplicationLag() == Long.MAX_VALUE ? "UNKNOWN" : StringUtils.humanTimeDiff(pair.getSecond().getReplicationLag())), jamonWriter);
        // 406, 167
        jamonWriter.write("</td>\n                    </tr>\n                    ");
      }
      // 408, 28
      jamonWriter.write("\n        </table>\n            </div>\n        ");
      // 411, 9
      
                active = "";
                }
        
      // 415, 5
      jamonWriter.write("</div>\n    <p>If the replication delay is UNKNOWN, that means this walGroup doesn't start replicate yet and it may get disabled.</p>\n</div>\n");
    }
    // 418, 1
    else
    {
      // 418, 8
      jamonWriter.write("\n    <p>No Peers Metrics</p>\n");
    }
    // 420, 7
    jamonWriter.write("\n");
  }
  
  
  // 197, 1
  private void __jamon_innerUnit__requestStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 201, 1
    jamonWriter.write("<table id=\"requestStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Filtered Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n</thead>\n<tbody>\n");
    // 212, 1
    
for (ServerName serverName: serverNames) {

ServerMetrics sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
  long readRequestCount = 0;
  long writeRequestCount = 0;
  long filteredReadRequestCount = 0;
  for (RegionMetrics rl : sl.getRegionMetrics().values()) {
    readRequestCount += rl.getReadRequestCount();
    writeRequestCount += rl.getWriteRequestCount();
    filteredReadRequestCount += rl.getFilteredReadRequestCount();
  }

    // 226, 1
    jamonWriter.write("<tr>\n<td>");
    // 227, 5
    {
      // 227, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 227, 49
    jamonWriter.write("</td>\n<td>");
    // 228, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(sl.getRequestCountPerSecond()), jamonWriter);
    // 228, 40
    jamonWriter.write("</td>\n<td>");
    // 229, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(readRequestCount), jamonWriter);
    // 229, 27
    jamonWriter.write("</td>\n<td>");
    // 230, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(filteredReadRequestCount), jamonWriter);
    // 230, 35
    jamonWriter.write("</td>\n<td>");
    // 231, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(writeRequestCount), jamonWriter);
    // 231, 28
    jamonWriter.write("</td>\n</tr>\n");
    // 233, 1
    
        }  else {
        
    // 236, 1
    {
      // 236, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 236, 40
    jamonWriter.write("\n");
    // 237, 1
    
        }
}

    // 241, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
  // 425, 1
  private void __jamon_innerUnit__serverNameLink(final java.io.Writer jamonWriter, final ServerName serverName)
    throws java.io.IOException
  {
    // 429, 9
    
        int infoPort = master.getRegionServerInfoPort(serverName);
        String url = "//" + serverName.getHostname() + ":" + infoPort + "/rs-status";
        
    // 434, 9
    if (infoPort > 0)
    {
      // 434, 28
      jamonWriter.write("\n            <a href=\"");
      // 435, 22
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 435, 31
      jamonWriter.write("\">");
      // 435, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 435, 65
      jamonWriter.write("</a>\n        ");
    }
    // 436, 9
    else
    {
      // 436, 16
      jamonWriter.write("\n            ");
      // 437, 13
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName.getServerName()), jamonWriter);
      // 437, 45
      jamonWriter.write("\n        ");
    }
    // 438, 15
    jamonWriter.write("\n");
  }
  
  
  // 246, 1
  private void __jamon_innerUnit__storeStats(final java.io.Writer jamonWriter, final ServerName[] serverNames)
    throws java.io.IOException
  {
    // 250, 1
    jamonWriter.write("<table id=\"storeStatsTable\" class=\"tablesorter table table-striped\">\n<thead>\n<tr>\n    <th>ServerName</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n</thead>\n<tbody>\n");
    // 263, 1
    
for (ServerName serverName: serverNames) {

ServerMetrics sl = master.getServerManager().getLoad(serverName);
if (sl != null) {
  long storeCount = 0;
  long storeFileCount = 0;
  long storeUncompressedSizeMB = 0;
  long storeFileSizeMB = 0;
  long totalStaticIndexSizeKB = 0;
  long totalStaticBloomSizeKB = 0;
  for (RegionMetrics rl : sl.getRegionMetrics().values()) {
    storeCount += rl.getStoreCount();
    storeFileCount += rl.getStoreFileCount();
    storeUncompressedSizeMB += rl.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE);
    storeFileSizeMB += rl.getStoreFileSize().get(Size.Unit.MEGABYTE);
    totalStaticIndexSizeKB += rl.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE);
    totalStaticBloomSizeKB += rl.getBloomFilterSize().get(Size.Unit.KILOBYTE);
  }

    // 283, 1
    jamonWriter.write("<tr>\n<td>");
    // 284, 5
    {
      // 284, 5
      __jamon_innerUnit__serverNameLink(jamonWriter, serverName);
    }
    // 284, 49
    jamonWriter.write("</td>\n<td>");
    // 285, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storeCount), jamonWriter);
    // 285, 21
    jamonWriter.write("</td>\n<td>");
    // 286, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(storeFileCount), jamonWriter);
    // 286, 25
    jamonWriter.write("</td>\n<td>");
    // 287, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(
  storeUncompressedSizeMB * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 288, 75
    jamonWriter.write("</td>\n<td>");
    // 289, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(storeFileSizeMB
  * TraditionalBinaryPrefix.MEGA.value, "B", 1)), jamonWriter);
    // 290, 51
    jamonWriter.write("</td>\n<td>");
    // 291, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(totalStaticIndexSizeKB
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 292, 51
    jamonWriter.write("</td>\n<td>");
    // 293, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(TraditionalBinaryPrefix.long2String(totalStaticBloomSizeKB
  * TraditionalBinaryPrefix.KILO.value, "B", 1)), jamonWriter);
    // 294, 51
    jamonWriter.write("</td>\n</tr>\n");
    // 296, 1
    
        }  else {
        
    // 299, 1
    {
      // 299, 1
      __jamon_innerUnit__emptyStat(jamonWriter, serverName);
    }
    // 299, 40
    jamonWriter.write("\n");
    // 300, 1
    
    }
}

    // 304, 1
    jamonWriter.write("</tbody>\n</table>\n");
  }
  
  
}
