/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnValueFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FilterTests.class, SmallTests.class})
public class TestFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFilter.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFilter.class);
    private HRegion region;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();
    private static final byte[][] ROWS_ONE = new byte[][]{Bytes.toBytes((String)"testRowOne-0"), Bytes.toBytes((String)"testRowOne-1"), Bytes.toBytes((String)"testRowOne-2"), Bytes.toBytes((String)"testRowOne-3")};
    private static final byte[][] ROWS_TWO = new byte[][]{Bytes.toBytes((String)"testRowTwo-0"), Bytes.toBytes((String)"testRowTwo-1"), Bytes.toBytes((String)"testRowTwo-2"), Bytes.toBytes((String)"testRowTwo-3")};
    private static final byte[][] ROWS_THREE = new byte[][]{Bytes.toBytes((String)"testRowThree-0"), Bytes.toBytes((String)"testRowThree-1"), Bytes.toBytes((String)"testRowThree-2"), Bytes.toBytes((String)"testRowThree-3")};
    private static final byte[][] ROWS_FOUR = new byte[][]{Bytes.toBytes((String)"testRowFour-0"), Bytes.toBytes((String)"testRowFour-1"), Bytes.toBytes((String)"testRowFour-2"), Bytes.toBytes((String)"testRowFour-3")};
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"testFamilyOne"), Bytes.toBytes((String)"testFamilyTwo")};
    private static final byte[][] FAMILIES_1 = new byte[][]{Bytes.toBytes((String)"testFamilyThree"), Bytes.toBytes((String)"testFamilyFour")};
    private static final byte[][] QUALIFIERS_ONE = new byte[][]{Bytes.toBytes((String)"testQualifierOne-0"), Bytes.toBytes((String)"testQualifierOne-1"), Bytes.toBytes((String)"testQualifierOne-2"), Bytes.toBytes((String)"testQualifierOne-3")};
    private static final byte[][] QUALIFIERS_TWO = new byte[][]{Bytes.toBytes((String)"testQualifierTwo-0"), Bytes.toBytes((String)"testQualifierTwo-1"), Bytes.toBytes((String)"testQualifierTwo-2"), Bytes.toBytes((String)"testQualifierTwo-3")};
    private static final byte[][] QUALIFIERS_THREE = new byte[][]{Bytes.toBytes((String)"testQualifierThree-0"), Bytes.toBytes((String)"testQualifierThree-1"), Bytes.toBytes((String)"testQualifierThree-2"), Bytes.toBytes((String)"testQualifierThree-3")};
    private static final byte[][] QUALIFIERS_FOUR = new byte[][]{Bytes.toBytes((String)"testQualifierFour-0"), Bytes.toBytes((String)"testQualifierFour-1"), Bytes.toBytes((String)"testQualifierFour-2"), Bytes.toBytes((String)"testQualifierFour-3")};
    private static final byte[][] QUALIFIERS_FIVE = new byte[][]{Bytes.toBytes((String)"testQualifierFive-0"), Bytes.toBytes((String)"testQualifierFive-1")};
    private static final byte[][] VALUES = new byte[][]{Bytes.toBytes((String)"testValueOne"), Bytes.toBytes((String)"testValueTwo")};
    byte[][] NEW_FAMILIES = new byte[][]{Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"f2")};
    private long numRows = (long)ROWS_ONE.length + (long)ROWS_TWO.length;
    private long colsPerRow = (long)FAMILIES.length * (long)QUALIFIERS_ONE.length;

    @Before
    public void setUp() throws Exception {
        Delete d;
        Put p;
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"TestFilter"));
        HColumnDescriptor family0 = new HColumnDescriptor(FAMILIES[0]).setVersions(100, 100);
        htd.addFamily(family0);
        htd.addFamily(new HColumnDescriptor(FAMILIES[1]));
        htd.addFamily(new HColumnDescriptor(FAMILIES_1[0]));
        htd.addFamily(new HColumnDescriptor(FAMILIES_1[1]));
        htd.addFamily(new HColumnDescriptor(this.NEW_FAMILIES[0]));
        htd.addFamily(new HColumnDescriptor(this.NEW_FAMILIES[1]));
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), (TableDescriptor)htd);
        for (byte[] ROW : ROWS_ONE) {
            p = new Put(ROW);
            p.setDurability(Durability.SKIP_WAL);
            for (byte[] QUALIFIER : QUALIFIERS_ONE) {
                p.addColumn(FAMILIES[0], QUALIFIER, VALUES[0]);
            }
            this.region.put(p);
        }
        for (byte[] ROW : ROWS_TWO) {
            p = new Put(ROW);
            p.setDurability(Durability.SKIP_WAL);
            for (byte[] QUALIFIER : QUALIFIERS_TWO) {
                p.addColumn(FAMILIES[1], QUALIFIER, VALUES[1]);
            }
            this.region.put(p);
        }
        this.region.flush(true);
        for (byte[] ROW : ROWS_ONE) {
            p = new Put(ROW);
            p.setDurability(Durability.SKIP_WAL);
            for (byte[] QUALIFIER : QUALIFIERS_ONE) {
                p.addColumn(FAMILIES[1], QUALIFIER, VALUES[0]);
            }
            this.region.put(p);
        }
        for (byte[] ROW : ROWS_TWO) {
            p = new Put(ROW);
            p.setDurability(Durability.SKIP_WAL);
            for (byte[] QUALIFIER : QUALIFIERS_TWO) {
                p.addColumn(FAMILIES[0], QUALIFIER, VALUES[1]);
            }
            this.region.put(p);
        }
        for (byte[] ROW : ROWS_ONE) {
            d = new Delete(ROW);
            d.addColumns(FAMILIES[0], QUALIFIERS_ONE[1]);
            d.addColumns(FAMILIES[1], QUALIFIERS_ONE[1]);
            this.region.delete(d);
        }
        for (byte[] ROW : ROWS_TWO) {
            d = new Delete(ROW);
            d.addColumns(FAMILIES[0], QUALIFIERS_TWO[1]);
            d.addColumns(FAMILIES[1], QUALIFIERS_TWO[1]);
            this.region.delete(d);
        }
        this.colsPerRow -= 2L;
        for (byte[] QUALIFIER : QUALIFIERS_ONE) {
            d = new Delete(ROWS_ONE[1]);
            d.addColumns(FAMILIES[0], QUALIFIER);
            d.addColumns(FAMILIES[1], QUALIFIER);
            this.region.delete(d);
        }
        for (byte[] QUALIFIER : QUALIFIERS_TWO) {
            d = new Delete(ROWS_TWO[1]);
            d.addColumns(FAMILIES[0], QUALIFIER);
            d.addColumns(FAMILIES[1], QUALIFIER);
            this.region.delete(d);
        }
        this.numRows -= 2L;
    }

    @After
    public void tearDown() throws Exception {
        HBaseTestingUtility.closeRegionAndWAL(this.region);
    }

    @Test
    public void testRegionScannerReseek() throws Exception {
        Put p;
        for (byte[] ROW : ROWS_THREE) {
            p = new Put(ROW);
            p.setDurability(Durability.SKIP_WAL);
            for (byte[] QUALIFIER : QUALIFIERS_THREE) {
                p.addColumn(FAMILIES[0], QUALIFIER, VALUES[0]);
            }
            this.region.put(p);
        }
        for (byte[] ROW : ROWS_FOUR) {
            p = new Put(ROW);
            p.setDurability(Durability.SKIP_WAL);
            for (byte[] QUALIFIER : QUALIFIERS_FOUR) {
                p.addColumn(FAMILIES[1], QUALIFIER, VALUES[1]);
            }
            this.region.put(p);
        }
        this.region.flush(true);
        for (byte[] ROW : ROWS_THREE) {
            p = new Put(ROW);
            p.setDurability(Durability.SKIP_WAL);
            for (byte[] QUALIFIER : QUALIFIERS_THREE) {
                p.addColumn(FAMILIES[1], QUALIFIER, VALUES[0]);
            }
            this.region.put(p);
        }
        for (byte[] ROW : ROWS_FOUR) {
            p = new Put(ROW);
            p.setDurability(Durability.SKIP_WAL);
            for (byte[] QUALIFIER : QUALIFIERS_FOUR) {
                p.addColumn(FAMILIES[0], QUALIFIER, VALUES[1]);
            }
            this.region.put(p);
        }
        Scan s = new Scan();
        s.setStartRow(ROWS_FOUR[1]);
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        scanner.reseek(ROWS_THREE[1]);
        ArrayList results = new ArrayList();
        scanner.next(results);
        for (Cell keyValue : results) {
            Assert.assertTrue((String)"The rows with ROWS_TWO as row key should be appearing.", (boolean)CellUtil.matchingRows((Cell)keyValue, (byte[])ROWS_THREE[1]));
        }
        scanner.reseek(ROWS_ONE[1]);
        results = new ArrayList();
        scanner.next(results);
        for (Cell keyValue : results) {
            Assert.assertFalse((String)"Cannot rewind back to a value less than previous reseek.", (boolean)Bytes.toString((byte[])CellUtil.cloneRow((Cell)keyValue)).contains("testRowOne"));
        }
    }

    @Test
    public void testNoFilter() throws Exception {
        long expectedRows = this.numRows;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan();
        this.verifyScan(s, expectedRows, expectedKeys);
        s = new Scan();
        s.addFamily(FAMILIES[0]);
        this.verifyScan(s, expectedRows, expectedKeys / 2L);
    }

    @Test
    public void testPrefixFilter() throws Exception {
        long expectedRows = this.numRows / 2L;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan();
        s.setFilter((Filter)new PrefixFilter(Bytes.toBytes((String)"testRowOne")));
        this.verifyScan(s, expectedRows, expectedKeys);
    }

    @Test
    public void testPrefixFilterWithReverseScan() throws Exception {
        long expectedRows = this.numRows / 2L;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan();
        s.setReversed(true);
        s.setFilter((Filter)new PrefixFilter(Bytes.toBytes((String)"testRowOne")));
        this.verifyScan(s, expectedRows, expectedKeys);
    }

    @Test
    public void testPageFilter() throws Exception {
        KeyValue[] expectedKVs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        long expectedRows = 6L;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan();
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScanFull(s, expectedKVs);
        expectedRows = 4L;
        expectedKeys = this.colsPerRow;
        s = new Scan();
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScanFull(s, Arrays.copyOf(expectedKVs, 24));
        expectedRows = 2L;
        expectedKeys = this.colsPerRow;
        s = new Scan();
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScanFull(s, Arrays.copyOf(expectedKVs, 12));
        expectedRows = 1L;
        expectedKeys = this.colsPerRow;
        s = new Scan();
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScanFull(s, Arrays.copyOf(expectedKVs, 6));
    }

    @Test
    public void testPageFilterWithReverseScan() throws Exception {
        KeyValue[] expectedKVs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        long expectedRows = 6L;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan();
        s.setReversed(true);
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = 4L;
        expectedKeys = this.colsPerRow;
        s = new Scan();
        s.setReversed(true);
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = 2L;
        expectedKeys = this.colsPerRow;
        s = new Scan();
        s.setReversed(true);
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = 1L;
        expectedKeys = this.colsPerRow;
        s = new Scan();
        s.setReversed(true);
        s.setFilter((Filter)new PageFilter(expectedRows));
        this.verifyScan(s, expectedRows, expectedKeys);
    }

    @Test
    public void testWhileMatchFilterWithFilterRowWithReverseScan() throws Exception {
        boolean isMoreResults;
        int pageSize = 4;
        Scan s = new Scan();
        s.setReversed(true);
        WhileMatchFilter filter = new WhileMatchFilter((Filter)new PageFilter(4L));
        s.setFilter((Filter)filter);
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        int scannerCounter = 0;
        do {
            isMoreResults = scanner.next(new ArrayList());
            if (++scannerCounter < 4) continue;
            Assert.assertTrue((String)"The WhileMatchFilter should now filter all remaining", (boolean)filter.filterAllRemaining());
        } while (isMoreResults);
        scanner.close();
        Assert.assertEquals((String)"The page filter returned more rows than expected", (long)4L, (long)scannerCounter);
    }

    @Test
    public void testWhileMatchFilterWithFilterRowKeyWithReverseScan() throws Exception {
        boolean isMoreResults;
        Scan s = new Scan();
        String prefix = "testRowOne";
        WhileMatchFilter filter = new WhileMatchFilter((Filter)new PrefixFilter(Bytes.toBytes((String)prefix)));
        s.setFilter((Filter)filter);
        s.setReversed(true);
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        do {
            ArrayList values;
            if ((isMoreResults = scanner.next(values = new ArrayList())) && Bytes.toString((byte[])CellUtil.cloneRow((Cell)((Cell)values.get(0)))).startsWith(prefix)) continue;
            Assert.assertTrue((String)"The WhileMatchFilter should now filter all remaining", (boolean)filter.filterAllRemaining());
        } while (isMoreResults);
        scanner.close();
    }

    @Test
    public void testWhileMatchFilterWithFilterRow() throws Exception {
        boolean isMoreResults;
        int pageSize = 4;
        Scan s = new Scan();
        WhileMatchFilter filter = new WhileMatchFilter((Filter)new PageFilter(4L));
        s.setFilter((Filter)filter);
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        int scannerCounter = 0;
        do {
            isMoreResults = scanner.next(new ArrayList());
            if (++scannerCounter < 4) continue;
            Assert.assertTrue((String)"The WhileMatchFilter should now filter all remaining", (boolean)filter.filterAllRemaining());
        } while (isMoreResults);
        Assert.assertEquals((String)"The page filter returned more rows than expected", (long)4L, (long)scannerCounter);
    }

    @Test
    public void test94FilterRowCompatibility() throws Exception {
        Scan s = new Scan();
        OldTestFilter filter = new OldTestFilter();
        s.setFilter((Filter)filter);
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        ArrayList values = new ArrayList();
        scanner.next(values);
        Assert.assertTrue((String)"All rows should be filtered out", (boolean)values.isEmpty());
    }

    @Test
    public void testWhileMatchFilterWithFilterRowKey() throws Exception {
        boolean isMoreResults;
        Scan s = new Scan();
        String prefix = "testRowOne";
        WhileMatchFilter filter = new WhileMatchFilter((Filter)new PrefixFilter(Bytes.toBytes((String)prefix)));
        s.setFilter((Filter)filter);
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        do {
            ArrayList values;
            if ((isMoreResults = scanner.next(values = new ArrayList())) && Bytes.toString((byte[])CellUtil.cloneRow((Cell)((Cell)values.get(0)))).startsWith(prefix)) continue;
            Assert.assertTrue((String)"The WhileMatchFilter should now filter all remaining", (boolean)filter.filterAllRemaining());
        } while (isMoreResults);
    }

    @Test
    public void testWhileMatchFilterWithFilterCell() throws Exception {
        boolean isMoreResults;
        Scan s = new Scan();
        WhileMatchFilter filter = new WhileMatchFilter((Filter)new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[0], CompareOperator.EQUAL, Bytes.toBytes((String)"foo")));
        s.setFilter((Filter)filter);
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        do {
            ArrayList values = new ArrayList();
            isMoreResults = scanner.next(values);
            Assert.assertTrue((String)"The WhileMatchFilter should now filter all remaining", (boolean)filter.filterAllRemaining());
        } while (isMoreResults);
    }

    @Test
    public void testInclusiveStopFilter() throws IOException {
        long expectedRows = this.numRows / 2L - 1L;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan(Bytes.toBytes((String)"testRowOne-0"), Bytes.toBytes((String)"testRowOne-3"));
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        s = new Scan(Bytes.toBytes((String)"testRowOne-0"));
        s.setFilter((Filter)new InclusiveStopFilter(Bytes.toBytes((String)"testRowOne-3")));
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L - 1L;
        expectedKeys = this.colsPerRow;
        s = new Scan(Bytes.toBytes((String)"testRowTwo-0"), Bytes.toBytes((String)"testRowTwo-3"));
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        s = new Scan(Bytes.toBytes((String)"testRowTwo-0"));
        s.setFilter((Filter)new InclusiveStopFilter(Bytes.toBytes((String)"testRowTwo-3")));
        this.verifyScan(s, expectedRows, expectedKeys);
    }

    @Test
    public void testInclusiveStopFilterWithReverseScan() throws IOException {
        long expectedRows = this.numRows / 2L - 1L;
        long expectedKeys = this.colsPerRow;
        Scan s = new Scan(Bytes.toBytes((String)"testRowOne-3"), Bytes.toBytes((String)"testRowOne-0"));
        s.setReversed(true);
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        s = new Scan(Bytes.toBytes((String)"testRowOne-3"));
        s.setReversed(true);
        s.setFilter((Filter)new InclusiveStopFilter(Bytes.toBytes((String)"testRowOne-0")));
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L - 1L;
        expectedKeys = this.colsPerRow;
        s = new Scan(Bytes.toBytes((String)"testRowTwo-3"), Bytes.toBytes((String)"testRowTwo-0"));
        s.setReversed(true);
        this.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        s = new Scan(Bytes.toBytes((String)"testRowTwo-3"));
        s.setReversed(true);
        s.setFilter((Filter)new InclusiveStopFilter(Bytes.toBytes((String)"testRowTwo-0")));
        this.verifyScan(s, expectedRows, expectedKeys);
    }

    @Test
    public void testQualifierFilter() throws IOException {
        long expectedRows = this.numRows / 2L;
        long expectedKeys = 2L;
        QualifierFilter f = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        Scan s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = 2L;
        f = new QualifierFilter(CompareOperator.LESS, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = 4L;
        f = new QualifierFilter(CompareOperator.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = 4L;
        f = new QualifierFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"testRowTwo"));
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = 4L;
        f = new QualifierFilter(CompareOperator.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"testRowTwo"));
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = 2L;
        f = new QualifierFilter(CompareOperator.GREATER, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"testRowTwo"));
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        f = new QualifierFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(QUALIFIERS_ONE[2]));
        s = new Scan();
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
        f = new QualifierFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new RegexStringComparator("test.+-2"));
        s = new Scan();
        s.setFilter((Filter)f);
        kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    @Test
    public void testFamilyFilter() throws IOException {
        long expectedRows = this.numRows;
        long expectedKeys = this.colsPerRow / 2L;
        FamilyFilter f = new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testFamilyOne")));
        Scan s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = 0L;
        expectedKeys = 0L;
        f = new FamilyFilter(CompareOperator.LESS, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testFamily")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows;
        expectedKeys = this.colsPerRow / 2L;
        f = new FamilyFilter(CompareOperator.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testFamilyOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow / 2L;
        f = new FamilyFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testFamilyOne")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"testRowTwo"));
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new FamilyFilter(CompareOperator.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testFamilyOne")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"testRowTwo"));
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow / 2L;
        f = new FamilyFilter(CompareOperator.GREATER, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testFamilyOne")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"testRowTwo"));
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        f = new FamilyFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(FAMILIES[1]));
        s = new Scan();
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
        f = new FamilyFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new RegexStringComparator("test.*One"));
        s = new Scan();
        s.setFilter((Filter)f);
        kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    @Test
    public void testRowFilter() throws IOException {
        long expectedRows = 1L;
        long expectedKeys = this.colsPerRow;
        RowFilter f = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        Scan s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = 2L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator("testRow.+-2"));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = 1L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareOperator.LESS, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = 2L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareOperator.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows - 1L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows - 1L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareOperator.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows - 2L;
        expectedKeys = this.colsPerRow;
        f = new RowFilter(CompareOperator.GREATER, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        f = new RowFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
        f = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(".+-2"));
        s = new Scan();
        s.setFilter((Filter)f);
        kvs = new KeyValue[]{new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    @Test
    public void testValueFilter() throws IOException {
        long expectedRows = this.numRows / 2L;
        long expectedKeys = this.colsPerRow;
        ValueFilter f = new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        Scan s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueTwo")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator("testValue((One)|(Two))"));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareOperator.LESS, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueTwo")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareOperator.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueTwo")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareOperator.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareOperator.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = this.numRows / 2L;
        expectedKeys = this.colsPerRow;
        f = new ValueFilter(CompareOperator.GREATER, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        f = new ValueFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    @Test
    public void testSkipFilter() throws IOException {
        SkipFilter f = new SkipFilter((Filter)new QualifierFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2"))));
        Scan s = new Scan();
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    @Test
    public void testFilterList() throws IOException {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(".+-2")));
        filters.add(new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(".+-2")));
        filters.add(new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("One")));
        FilterList f = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        Scan s = new Scan();
        s.addFamily(FAMILIES[0]);
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0])};
        this.verifyScanFull(s, kvs);
        filters.clear();
        filters.add(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(".+Two.+")));
        filters.add(new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(".+-2")));
        filters.add(new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("One")));
        f = new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
        s = new Scan();
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, this.numRows, this.colsPerRow);
    }

    @Test
    public void testFirstKeyOnlyFilter() throws IOException {
        Scan s = new Scan();
        s.setFilter((Filter)new FirstKeyOnlyFilter());
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    @Test
    public void testFilterListWithSingleColumnValueFilter() throws IOException {
        SingleColumnValueFilter f1 = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[0], CompareOperator.EQUAL, VALUES[0]);
        f1.setFilterIfMissing(true);
        Scan s1 = new Scan();
        s1.addFamily(FAMILIES[0]);
        s1.setFilter((Filter)f1);
        KeyValue[] kvs1 = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0])};
        this.verifyScanNoEarlyOut(s1, 3L, 3L);
        this.verifyScanFull(s1, kvs1);
        SingleColumnValueFilter f2 = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_TWO[0], CompareOperator.EQUAL, VALUES[1]);
        f2.setFilterIfMissing(true);
        Scan s2 = new Scan();
        s2.addFamily(FAMILIES[0]);
        s2.setFilter((Filter)f2);
        KeyValue[] kvs2 = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanNoEarlyOut(s2, 3L, 3L);
        this.verifyScanFull(s2, kvs2);
        FilterList f = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        f.addFilter((Filter)f1);
        f.addFilter((Filter)f2);
        Scan s = new Scan();
        s.addFamily(FAMILIES[0]);
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanNoEarlyOut(s, 6L, 3L);
        this.verifyScanFull(s, kvs);
    }

    @Test
    public void testFilterListWithPrefixFilter() throws IOException {
        byte[] family = Bytes.toBytes((String)"f1");
        byte[] qualifier = Bytes.toBytes((String)"q1");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        htd.addFamily(new HColumnDescriptor(family));
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        HRegion testRegion = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), (TableDescriptor)htd);
        for (int i = 0; i < 5; ++i) {
            Put p = new Put(Bytes.toBytes((String)((char)(97 + i) + "row")));
            p.setDurability(Durability.SKIP_WAL);
            p.addColumn(family, qualifier, Bytes.toBytes((String)String.valueOf(111 + i)));
            testRegion.put(p);
        }
        testRegion.flush(true);
        PrefixFilter pf = new PrefixFilter(new byte[]{98});
        SingleColumnValueFilter scvf = new SingleColumnValueFilter(family, qualifier, CompareOperator.EQUAL, Bytes.toBytes((String)"113"));
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE, new Filter[]{pf, scvf});
        Scan s1 = new Scan();
        s1.setFilter((Filter)filterList);
        HRegion.RegionScannerImpl scanner = testRegion.getScanner(s1);
        ArrayList results = new ArrayList();
        int resultCount = 0;
        while (scanner.next(results)) {
            ++resultCount;
            byte[] row = CellUtil.cloneRow((Cell)((Cell)results.get(0)));
            LOG.debug("Found row: " + Bytes.toStringBinary((byte[])row));
            Assert.assertTrue((Bytes.equals((byte[])row, (byte[])Bytes.toBytes((String)"brow")) || Bytes.equals((byte[])row, (byte[])Bytes.toBytes((String)"crow")) ? 1 : 0) != 0);
            results.clear();
        }
        Assert.assertEquals((long)2L, (long)resultCount);
        scanner.close();
        WAL wal = testRegion.getWAL();
        testRegion.close();
        wal.close();
    }

    @Test
    public void testSingleColumnValueFilter() throws IOException {
        KeyValue[] srcKVs;
        Put p = new Put(ROWS_ONE[2]);
        p.addColumn(FAMILIES[0], QUALIFIERS_ONE[2], VALUES[1]);
        this.region.put(p);
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[0], CompareOperator.EQUAL, VALUES[0]));
        filters.add(new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[2], CompareOperator.EQUAL, VALUES[1]));
        FilterList f = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        Scan s = new Scan(ROWS_ONE[0], ROWS_TWO[0]);
        s.addFamily(FAMILIES[0]);
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[1]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0])};
        this.verifyScanNoEarlyOut(s, 1L, 3L);
        this.verifyScanFull(s, kvs);
        filters = new ArrayList();
        filters.add(new SkipFilter((Filter)new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[0], CompareOperator.EQUAL, VALUES[0])));
        filters.add(new SkipFilter((Filter)new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[2], CompareOperator.EQUAL, VALUES[1])));
        f = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        s = new Scan(ROWS_ONE[0], ROWS_TWO[0]);
        s.addFamily(FAMILIES[0]);
        s.setFilter((Filter)f);
        this.verifyScanNoEarlyOut(s, 1L, 3L);
        this.verifyScanFull(s, kvs);
        byte[][] ROWS_THREE = new byte[][]{Bytes.toBytes((String)"rowThree-0"), Bytes.toBytes((String)"rowThree-1"), Bytes.toBytes((String)"rowThree-2"), Bytes.toBytes((String)"rowThree-3")};
        for (KeyValue kv : srcKVs = new KeyValue[]{new KeyValue(ROWS_THREE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_THREE[1], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[1]), new KeyValue(ROWS_THREE[2], FAMILIES[0], QUALIFIERS_ONE[1], VALUES[0]), new KeyValue(ROWS_THREE[3], FAMILIES[0], QUALIFIERS_ONE[1], VALUES[1])}) {
            Put put = new Put(CellUtil.cloneRow((Cell)kv)).add((Cell)kv);
            put.setDurability(Durability.SKIP_WAL);
            this.region.put(put);
        }
        SingleColumnValueFilter scvf = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[0], CompareOperator.EQUAL, VALUES[0]);
        s = new Scan(ROWS_THREE[0], Bytes.toBytes((String)"rowThree-4"));
        s.addFamily(FAMILIES[0]);
        s.setFilter((Filter)scvf);
        kvs = new KeyValue[]{srcKVs[0], srcKVs[2], srcKVs[3]};
        this.verifyScanFull(s, kvs);
        scvf = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[0], CompareOperator.EQUAL, VALUES[0]);
        scvf.setFilterIfMissing(true);
        s = new Scan(ROWS_THREE[0], Bytes.toBytes((String)"rowThree-4"));
        s.addFamily(FAMILIES[0]);
        s.setFilter((Filter)scvf);
        kvs = new KeyValue[]{srcKVs[0]};
        this.verifyScanFull(s, kvs);
        scvf = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[1], CompareOperator.EQUAL, VALUES[1]);
        scvf.setFilterIfMissing(true);
        s = new Scan(ROWS_THREE[0], Bytes.toBytes((String)"rowThree-4"));
        s.addFamily(FAMILIES[0]);
        s.setFilter((Filter)scvf);
        kvs = new KeyValue[]{srcKVs[3]};
        this.verifyScanFull(s, kvs);
        KeyValue kvA = new KeyValue(ROWS_THREE[0], FAMILIES[0], QUALIFIERS_ONE[1], VALUES[0]);
        this.region.put(new Put(CellUtil.cloneRow((Cell)kvA)).add((Cell)kvA));
        scvf = new SingleColumnValueFilter(FAMILIES[0], QUALIFIERS_ONE[1], CompareOperator.EQUAL, VALUES[1]);
        scvf.setFilterIfMissing(true);
        s = new Scan(ROWS_THREE[0], Bytes.toBytes((String)"rowThree-4"));
        s.addFamily(FAMILIES[0]);
        s.setFilter((Filter)scvf);
        kvs = new KeyValue[]{srcKVs[3]};
        this.verifyScanFull(s, kvs);
    }

    @Test
    public void testColumnValueFilter() throws Exception {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < ROWS_ONE.length; ++j) {
                Put p1 = new Put(ROWS_ONE[j]).setDurability(Durability.SKIP_WAL);
                Put p2 = new Put(ROWS_TWO[j]).setDurability(Durability.SKIP_WAL);
                for (byte[] q5 : QUALIFIERS_FIVE) {
                    p1.addColumn(FAMILIES[0], q5, VALUES[0 + i]).addColumn(FAMILIES[1], q5, VALUES[0 + i]);
                    p2.addColumn(FAMILIES[0], q5, VALUES[1 - i]).addColumn(FAMILIES[1], q5, VALUES[1 - i]);
                }
                this.region.put(p1);
                this.region.put(p2);
            }
            this.region.flush(true);
        }
        Scan scan = new Scan().setFilter((Filter)new ColumnValueFilter(FAMILIES[0], QUALIFIERS_FIVE[0], CompareOperator.EQUAL, VALUES[1]));
        KeyValue[] expectedEquals = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[1], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[1], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1])};
        this.verifyScanFull(scan, expectedEquals);
        scan.setFilter((Filter)new ColumnValueFilter(FAMILIES[0], QUALIFIERS_FIVE[0], CompareOperator.GREATER, VALUES[0]));
        KeyValue[] expectedGreater = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[1], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[1], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1])};
        this.verifyScanFull(scan, expectedGreater);
        scan.readAllVersions().setFilter((Filter)new ColumnValueFilter(FAMILIES[0], QUALIFIERS_FIVE[0], CompareOperator.GREATER_OR_EQUAL, VALUES[0]));
        KeyValue[] expectedGreaterOrEqual = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_ONE[1], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[1], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[1], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[1], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1])};
        this.verifyScanFull(scan, expectedGreaterOrEqual);
        scan.readVersions(1).setFilter((Filter)new ColumnValueFilter(FAMILIES[1], QUALIFIERS_FIVE[1], CompareOperator.LESS, VALUES[1]));
        KeyValue[] expectedLess = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[1], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0])};
        this.verifyScanFull(scan, expectedLess);
        scan.setFilter((Filter)new ColumnValueFilter(FAMILIES[1], QUALIFIERS_FIVE[1], CompareOperator.LESS_OR_EQUAL, VALUES[1]));
        KeyValue[] expectedLessOrEqual = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[1]), new KeyValue(ROWS_ONE[1], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[1]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[1]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[1], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0])};
        this.verifyScanFull(scan, expectedLessOrEqual);
        scan.setFilter((Filter)new ColumnValueFilter(FAMILIES[1], QUALIFIERS_FIVE[1], CompareOperator.NOT_EQUAL, VALUES[1]));
        KeyValue[] expectedNotEqual = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[1], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0])};
        this.verifyScanFull(scan, expectedNotEqual);
        ArrayList<Object> orFilters = new ArrayList<Object>(2);
        orFilters.add(new ColumnValueFilter(FAMILIES[1], QUALIFIERS_FIVE[1], CompareOperator.NOT_EQUAL, VALUES[1]));
        orFilters.add(new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(QUALIFIERS_FIVE[0])));
        scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ONE, orFilters));
        KeyValue[] expectedMustPassOne = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[1], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[1], FAMILIES[1], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_FIVE[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[1], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[1], FAMILIES[1], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[1], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_FIVE[0], VALUES[0]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0])};
        this.verifyScanFull(scan, expectedMustPassOne);
        ArrayList<Object> andFilters = new ArrayList<Object>(2);
        andFilters.add(new ColumnValueFilter(FAMILIES[1], QUALIFIERS_FIVE[1], CompareOperator.NOT_EQUAL, VALUES[1]));
        andFilters.add(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryPrefixComparator(Bytes.toBytes((String)"testRow"))));
        scan.setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ALL, andFilters));
        KeyValue[] expectedMustPassAll = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[1], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0])};
        this.verifyScanFull(scan, expectedMustPassAll);
        Scan anotherScan = new Scan().addColumn(FAMILIES[1], QUALIFIERS_FIVE[1]).setFilter((Filter)new FilterList(FilterList.Operator.MUST_PASS_ONE, orFilters));
        KeyValue[] expectedValues = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[1], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_FIVE[1], VALUES[0])};
        this.verifyScanFull(anotherScan, expectedValues);
    }

    private void verifyScan(Scan s, long expectedRows, long expectedKeys) throws IOException {
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        ArrayList results = new ArrayList();
        int i = 0;
        boolean done = true;
        while (done) {
            done = scanner.next(results);
            Arrays.sort(results.toArray(new Cell[results.size()]), CellComparator.getInstance());
            LOG.info("counter=" + i + ", " + results);
            if (results.isEmpty()) break;
            Assert.assertTrue((String)("Scanned too many rows! Only expected " + expectedRows + " total but already scanned " + (i + 1)), (expectedRows > (long)i ? 1 : 0) != 0);
            Assert.assertEquals((String)("Expected " + expectedKeys + " keys per row but returned " + results.size()), (long)expectedKeys, (long)results.size());
            results.clear();
            ++i;
        }
        Assert.assertEquals((String)("Expected " + expectedRows + " rows but scanned " + i + " rows"), (long)expectedRows, (long)i);
    }

    private void verifyScanNoEarlyOut(Scan s, long expectedRows, long expectedKeys) throws IOException {
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        ArrayList results = new ArrayList();
        int i = 0;
        boolean done = true;
        while (done) {
            done = scanner.next(results);
            Arrays.sort(results.toArray(new Cell[results.size()]), CellComparator.getInstance());
            LOG.info("counter=" + i + ", " + results);
            if (results.isEmpty()) break;
            Assert.assertTrue((String)("Scanned too many rows! Only expected " + expectedRows + " total but already scanned " + (i + 1)), (expectedRows > (long)i ? 1 : 0) != 0);
            Assert.assertEquals((String)("Expected " + expectedKeys + " keys per row but returned " + results.size()), (long)expectedKeys, (long)results.size());
            results.clear();
            ++i;
        }
        Assert.assertEquals((String)("Expected " + expectedRows + " rows but scanned " + i + " rows"), (long)expectedRows, (long)i);
    }

    private void verifyScanFull(Scan s, KeyValue[] kvs) throws IOException {
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        ArrayList results = new ArrayList();
        int row = 0;
        int idx = 0;
        boolean done = true;
        while (done) {
            done = scanner.next(results);
            Arrays.sort(results.toArray(new Cell[results.size()]), CellComparator.getInstance());
            if (results.isEmpty()) break;
            Assert.assertTrue((String)("Scanned too many keys! Only expected " + kvs.length + " total but already scanned " + (results.size() + idx) + (results.isEmpty() ? "" : "(" + ((Cell)results.get(0)).toString() + ")")), (kvs.length >= idx + results.size() ? 1 : 0) != 0);
            for (Cell kv : results) {
                LOG.info("row=" + row + ", result=" + kv.toString() + ", match=" + kvs[idx].toString());
                Assert.assertTrue((String)"Row mismatch", (boolean)CellUtil.matchingRows((Cell)kv, (Cell)kvs[idx]));
                Assert.assertTrue((String)"Family mismatch", (boolean)CellUtil.matchingFamily((Cell)kv, (Cell)kvs[idx]));
                Assert.assertTrue((String)"Qualifier mismatch", (boolean)CellUtil.matchingQualifier((Cell)kv, (Cell)kvs[idx]));
                Assert.assertTrue((String)"Value mismatch", (boolean)CellUtil.matchingValue((Cell)kv, (Cell)kvs[idx]));
                ++idx;
            }
            results.clear();
            ++row;
        }
        LOG.info("Looked at " + row + " rows with " + idx + " keys");
        Assert.assertEquals((String)("Expected " + kvs.length + " total keys but scanned " + idx), (long)kvs.length, (long)idx);
    }

    private void verifyScanFullNoValues(Scan s, KeyValue[] kvs, boolean useLen) throws IOException {
        HRegion.RegionScannerImpl scanner = this.region.getScanner(s);
        ArrayList results = new ArrayList();
        int row = 0;
        int idx = 0;
        boolean more = true;
        while (more) {
            more = scanner.next(results);
            Arrays.sort(results.toArray(new Cell[results.size()]), CellComparator.getInstance());
            if (results.isEmpty()) break;
            Assert.assertTrue((String)("Scanned too many keys! Only expected " + kvs.length + " total but already scanned " + (results.size() + idx) + (results.isEmpty() ? "" : "(" + ((Cell)results.get(0)).toString() + ")")), (kvs.length >= idx + results.size() ? 1 : 0) != 0);
            for (Cell kv : results) {
                LOG.info("row=" + row + ", result=" + kv.toString() + ", match=" + kvs[idx].toString());
                Assert.assertTrue((String)"Row mismatch", (boolean)CellUtil.matchingRows((Cell)kv, (Cell)kvs[idx]));
                Assert.assertTrue((String)"Family mismatch", (boolean)CellUtil.matchingFamily((Cell)kv, (Cell)kvs[idx]));
                Assert.assertTrue((String)"Qualifier mismatch", (boolean)CellUtil.matchingQualifier((Cell)kv, (Cell)kvs[idx]));
                Assert.assertFalse((String)"Should not have returned whole value", (boolean)CellUtil.matchingValue((Cell)kv, (Cell)kvs[idx]));
                if (useLen) {
                    Assert.assertEquals((String)"Value in result is not SIZEOF_INT", (long)4L, (long)kv.getValueLength());
                    LOG.info("idx = " + idx + ", len=" + kvs[idx].getValueLength() + ", actual=" + Bytes.toInt((byte[])CellUtil.cloneValue((Cell)kv)));
                    Assert.assertEquals((String)"Scan value should be the length of the actual value. ", (long)kvs[idx].getValueLength(), (long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)kv)));
                    LOG.info("good");
                } else {
                    Assert.assertEquals((String)"Value in result is not empty", (long)0L, (long)kv.getValueLength());
                }
                ++idx;
            }
            results.clear();
            ++row;
        }
        LOG.info("Looked at " + row + " rows with " + idx + " keys");
        Assert.assertEquals((String)("Expected " + kvs.length + " total keys but scanned " + idx), (long)kvs.length, (long)idx);
    }

    @Test
    public void testColumnPaginationFilterColumnOffset() throws Exception {
        KeyValue[] expectedKVs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1])};
        KeyValue[] expectedKVs1 = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1])};
        KeyValue[] expectedKVs2 = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1])};
        KeyValue[] expectedKVs3 = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        Scan s = new Scan();
        long expectedRows = 6L;
        long expectedKeys = 1L;
        s.setFilter((Filter)new ColumnPaginationFilter(1, QUALIFIERS_ONE[1]));
        this.verifyScan(s, expectedRows, expectedKeys);
        this.verifyScanFull(s, expectedKVs);
        expectedRows = 3L;
        expectedKeys = 2L;
        s = new Scan();
        s.setFilter((Filter)new ColumnPaginationFilter(2, QUALIFIERS_TWO[2]));
        this.verifyScan(s, expectedRows, expectedKeys);
        this.verifyScanFull(s, expectedKVs1);
        expectedRows = 3L;
        expectedKeys = 3L;
        s = new Scan();
        s.setFilter((Filter)new ColumnPaginationFilter(3, QUALIFIERS_TWO[2]));
        this.verifyScan(s, expectedRows, expectedKeys);
        this.verifyScanFull(s, expectedKVs2);
        expectedRows = 3L;
        expectedKeys = 2L;
        s = new Scan();
        s.addFamily(FAMILIES[1]);
        s.setFilter((Filter)new ColumnPaginationFilter(2, QUALIFIERS_TWO[2]));
        this.verifyScanFull(s, expectedKVs3);
    }

    @Test
    public void testLatestVersionFilterWithExplicitColumn() throws Exception {
        Put p = new Put(ROWS_ONE[0]);
        p.setDurability(Durability.SKIP_WAL);
        p.addColumn(FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]);
        this.region.put(p);
        p = new Put(ROWS_ONE[0]);
        p.setDurability(Durability.SKIP_WAL);
        p.addColumn(FAMILIES[0], QUALIFIERS_ONE[0], VALUES[1]);
        this.region.put(p);
        this.region.flush(true);
        Scan s = new Scan();
        s.setFilter((Filter)new FilterBase(){

            public Filter.ReturnCode filterCell(Cell c) throws IOException {
                return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
            }
        });
        s.readVersions(100);
        s.addColumn(FAMILIES[0], QUALIFIERS_ONE[0]);
        s.addColumn(FAMILIES[0], QUALIFIERS_ONE[1]);
        s.addColumn(FAMILIES[0], QUALIFIERS_ONE[2]);
        s.addColumn(FAMILIES[0], QUALIFIERS_ONE[3]);
        s.addColumn(FAMILIES[0], QUALIFIERS_TWO[0]);
        s.addColumn(FAMILIES[0], QUALIFIERS_TWO[1]);
        s.addColumn(FAMILIES[0], QUALIFIERS_TWO[2]);
        s.addColumn(FAMILIES[0], QUALIFIERS_TWO[3]);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[1]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1])};
        this.verifyScanFull(s, kvs);
    }

    @Test
    public void testColumnPaginationFilter() throws Exception {
        Put p = new Put(ROWS_ONE[0]);
        p.setDurability(Durability.SKIP_WAL);
        p.addColumn(FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]);
        this.region.put(p);
        this.region.flush(true);
        KeyValue[] expectedKVs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1])};
        KeyValue[] expectedKVs2 = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1])};
        KeyValue[] expectedKVs3 = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1])};
        KeyValue[] expectedKVs4 = new KeyValue[]{};
        long expectedRows = this.numRows;
        long expectedKeys = 1L;
        Scan s = new Scan();
        s.setFilter((Filter)new ColumnPaginationFilter(1, 0));
        this.verifyScan(s, expectedRows, expectedKeys);
        this.verifyScanFull(s, expectedKVs);
        s.setFilter((Filter)new ColumnPaginationFilter(1, 2));
        this.verifyScan(s, expectedRows, expectedKeys);
        this.verifyScanFull(s, expectedKVs2);
        s.setFilter((Filter)new ColumnPaginationFilter(2, 2));
        expectedKeys = 2L;
        this.verifyScan(s, expectedRows, expectedKeys);
        this.verifyScanFull(s, expectedKVs3);
        s.setFilter((Filter)new ColumnPaginationFilter(20, 140));
        expectedKeys = 0L;
        expectedRows = 0L;
        this.verifyScan(s, expectedRows, 0L);
        this.verifyScanFull(s, expectedKVs4);
    }

    @Test
    public void testKeyOnlyFilter() throws Exception {
        KeyValue[] expectedKVs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        long expectedRows = 6L;
        long expectedKeys = this.colsPerRow;
        for (boolean useLen : new boolean[]{false, true}) {
            Scan s = new Scan();
            s.setFilter((Filter)new KeyOnlyFilter(useLen));
            this.verifyScan(s, expectedRows, expectedKeys);
            this.verifyScanFullNoValues(s, expectedKVs, useLen);
        }
    }

    @Test
    @Ignore(value="TODO: intentionally disabled?")
    public void testNestedFilterListWithSCVF() throws IOException {
        byte[] columnStatus = Bytes.toBytes((String)"S");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        htd.addFamily(new HColumnDescriptor(FAMILIES[0]));
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        HRegion testRegion = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, TEST_UTIL.getDataTestDir(), TEST_UTIL.getConfiguration(), (TableDescriptor)htd);
        for (int i = 0; i < 10; ++i) {
            Put p = new Put(Bytes.toBytes((String)("row" + i)));
            p.setDurability(Durability.SKIP_WAL);
            p.addColumn(FAMILIES[0], columnStatus, Bytes.toBytes((int)(i % 2)));
            testRegion.put(p);
        }
        testRegion.flush(true);
        RowFilter rowFilter = new RowFilter(CompareOperator.GREATER, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"row4")));
        Scan s1 = new Scan();
        s1.setFilter((Filter)rowFilter);
        HRegion.RegionScannerImpl scanner = testRegion.getScanner(s1);
        ArrayList results = new ArrayList();
        int i = 5;
        boolean done = true;
        while (done) {
            done = scanner.next(results);
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)results.get(0)), (byte[])Bytes.toBytes((String)("row" + i))));
            Assert.assertEquals((long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(0)))), (long)(i % 2));
            results.clear();
            ++i;
        }
        FilterList subFilterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        RowFilter subFilter1 = new RowFilter(CompareOperator.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"row4")));
        subFilterList.addFilter((Filter)subFilter1);
        SingleColumnValueFilter subFilter2 = new SingleColumnValueFilter(FAMILIES[0], columnStatus, CompareOperator.EQUAL, Bytes.toBytes((int)0));
        subFilterList.addFilter((Filter)subFilter2);
        s1 = new Scan();
        s1.setFilter((Filter)subFilterList);
        scanner = testRegion.getScanner(s1);
        results = new ArrayList();
        for (i = 0; i <= 4; i += 2) {
            scanner.next(results);
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)results.get(0)), (byte[])Bytes.toBytes((String)("row" + i))));
            Assert.assertEquals((long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(0)))), (long)(i % 2));
            results.clear();
        }
        Assert.assertFalse((boolean)scanner.next(results));
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.addFilter((Filter)rowFilter);
        filterList.addFilter((Filter)subFilterList);
        s1 = new Scan();
        s1.setFilter((Filter)filterList);
        scanner = testRegion.getScanner(s1);
        results = new ArrayList();
        for (i = 0; i <= 4; i += 2) {
            scanner.next(results);
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)results.get(0)), (byte[])Bytes.toBytes((String)("row" + i))));
            Assert.assertEquals((long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(0)))), (long)(i % 2));
            results.clear();
        }
        for (i = 5; i <= 9; ++i) {
            scanner.next(results);
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)results.get(0)), (byte[])Bytes.toBytes((String)("row" + i))));
            Assert.assertEquals((long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(0)))), (long)(i % 2));
            results.clear();
        }
        Assert.assertFalse((boolean)scanner.next(results));
        filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.addFilter((Filter)subFilterList);
        filterList.addFilter((Filter)rowFilter);
        s1 = new Scan();
        s1.setFilter((Filter)filterList);
        scanner = testRegion.getScanner(s1);
        results = new ArrayList();
        for (i = 0; i <= 4; i += 2) {
            scanner.next(results);
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)results.get(0)), (byte[])Bytes.toBytes((String)("row" + i))));
            Assert.assertEquals((long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(0)))), (long)(i % 2));
            results.clear();
        }
        for (i = 5; i <= 9; ++i) {
            scanner.next(results);
            Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)results.get(0)), (byte[])Bytes.toBytes((String)("row" + i))));
            Assert.assertEquals((long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(0)))), (long)(i % 2));
            results.clear();
        }
        Assert.assertFalse((boolean)scanner.next(results));
        WAL wal = testRegion.getWAL();
        testRegion.close();
        wal.close();
    }

    public static class SlowScanFilter
    extends FilterBase {
        private static Thread ipcHandlerThread = null;

        public byte[] toByteArray() {
            return null;
        }

        public Filter.ReturnCode filterCell(Cell ignored) throws IOException {
            return Filter.ReturnCode.INCLUDE;
        }

        public boolean filterRow() throws IOException {
            ipcHandlerThread = Thread.currentThread();
            try {
                LOG.info("Handler thread " + ipcHandlerThread + " sleeping in filter...");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Throwables.propagate((Throwable)e);
            }
            return super.filterRow();
        }
    }

    static class OldTestFilter
    extends FilterBase {
        OldTestFilter() {
        }

        public byte[] toByteArray() {
            return null;
        }

        public boolean hasFilterRow() {
            return false;
        }

        public boolean filterRow() {
            return true;
        }

        public Filter.ReturnCode filterCell(Cell ignored) throws IOException {
            return Filter.ReturnCode.INCLUDE;
        }
    }
}

