/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMetaInitIfAllProceduresLost {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaInitIfAllProceduresLost.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaInitIfAllProceduresLost.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void test() throws Exception {
        for (JVMClusterUtil.RegionServerThread regionServerThread : UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            regionServerThread.getRegionServer().abort("killAll");
        }
        UTIL.waitFor(30000L, () -> UTIL.getMiniHBaseCluster().getMaster().getMasterWalManager().getLiveServersFromWALDir().size() == 0);
        Thread.sleep(1000L);
        Path procedureWals = new Path(UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem().getRootDir(), "MasterProcWALs");
        UTIL.getMiniHBaseCluster().killAll();
        for (FileStatus file : UTIL.getTestFileSystem().listStatus(procedureWals)) {
            LOG.info("removing " + file);
            UTIL.getTestFileSystem().delete(file.getPath());
        }
        UTIL.getMiniHBaseCluster().startMaster();
        UTIL.getMiniHBaseCluster().startRegionServer();
        UTIL.getMiniHBaseCluster().startRegionServer();
        UTIL.getMiniHBaseCluster().startRegionServer();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        HMaster master = UTIL.getHBaseCluster().getMaster();
        AssignmentManager am = master.getAssignmentManager();
        AssignProcedure ap = am.createAssignProcedure(RegionInfoBuilder.FIRST_META_REGIONINFO);
        scheduledExecutorService.schedule(() -> master.getMasterProcedureExecutor().submitProcedure((Procedure)ap), 10L, TimeUnit.SECONDS);
        scheduledExecutorService.schedule(() -> {
            List ris = am.getRegionStates().getRegionsOfTable(TableName.NAMESPACE_TABLE_NAME);
            if (ris.isEmpty()) {
                throw new RuntimeException("No namespace regions found!");
            }
            for (RegionInfo ri : ris) {
                AssignProcedure riap = am.createAssignProcedure(ri);
                master.getMasterProcedureExecutor().submitProcedure((Procedure)riap);
            }
        }, 20L, TimeUnit.SECONDS);
        UTIL.waitFor(180000L, () -> UTIL.getMiniHBaseCluster().getMaster() != null && UTIL.getMiniHBaseCluster().getMaster().isInitialized());
    }
}

