/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.UnassignProcedure;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.gson.JsonArray;
import org.apache.hbase.thirdparty.com.google.gson.JsonElement;
import org.apache.hbase.thirdparty.com.google.gson.JsonObject;
import org.apache.hbase.thirdparty.com.google.gson.JsonParser;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestUnexpectedStateException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestUnexpectedStateException.class);
    @Rule
    public final TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestUnexpectedStateException.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private TableName tableName;
    private static final int REGIONS = 10;

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createMultiRegionTable(this.tableName, FAMILY, 10);
    }

    private RegionInfo pickArbitraryRegion(Admin admin) throws IOException {
        List regions = admin.getRegions(this.tableName);
        return (RegionInfo)regions.get(3);
    }

    @Test
    public void testUnableToAssign() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            RegionInfo region = this.pickArbitraryRegion(admin);
            AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
            RegionStates.RegionStateNode rsn = am.getRegionStates().getRegionStateNode(region);
            am.markRegionAsOpening(rsn);
            Runnable unassign = () -> {
                try {
                    admin.unassign(region.getRegionName(), true);
                }
                catch (IOException ioe) {
                    Assert.fail((String)"Failed assign");
                }
            };
            Thread t = new Thread(unassign, "unassign");
            t.start();
            while (!t.isAlive()) {
                Threads.sleep((long)100L);
            }
            Threads.sleep((long)1000L);
            JsonParser parser = new JsonParser();
            long oldTimeout = 0L;
            int timeoutIncrements = 0;
            while (true) {
                long timeout;
                if ((timeout = this.getUnassignTimeout(parser, admin.getProcedures())) > oldTimeout) {
                    LOG.info("Timeout incremented, was {}, now is {}, increments={}", new Object[]{timeout, oldTimeout, timeoutIncrements});
                    oldTimeout = timeout;
                    if (++timeoutIncrements > 3) break;
                }
                Thread.sleep(1000L);
            }
            TEST_UTIL.getMiniHBaseCluster().stopMaster(0).join();
            HMaster master = TEST_UTIL.getMiniHBaseCluster().startMaster().getMaster();
            TEST_UTIL.waitFor(30000L, () -> master.isInitialized());
            am = master.getAssignmentManager();
            rsn = am.getRegionStates().getRegionStateNode(region);
            am.markRegionAsOpened(rsn);
            t.join();
        }
    }

    private long getUnassignTimeout(JsonParser parser, String proceduresAsJSON) throws Exception {
        JsonArray array = parser.parse(proceduresAsJSON).getAsJsonArray();
        for (JsonElement element : array) {
            String actualClassName;
            JsonObject obj = element.getAsJsonObject();
            String className = obj.get("className").getAsString();
            if (!className.equals(actualClassName = UnassignProcedure.class.getName())) continue;
            return obj.get("timeout").getAsLong();
        }
        throw new Exception("Failed to find UnassignProcedure or timeout in " + proceduresAsJSON);
    }
}

