/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.TimeToLiveHFileCleaner;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestHFileCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileCleaner.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileCleaner.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.startMiniDFSCluster(1);
        CleanerChore.initChorePool((Configuration)UTIL.getConfiguration());
    }

    @AfterClass
    public static void shutdownCluster() throws IOException {
        UTIL.shutdownMiniDFSCluster();
    }

    @Test
    public void testTTLCleaner() throws IOException, InterruptedException {
        DistributedFileSystem fs = UTIL.getDFSCluster().getFileSystem();
        Path root = UTIL.getDataTestDirOnTestFS();
        Path file = new Path(root, "file");
        fs.createNewFile(file);
        long createTime = System.currentTimeMillis();
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(file));
        TimeToLiveHFileCleaner cleaner = new TimeToLiveHFileCleaner();
        fs.setTimes(file, createTime - 100L, -1L);
        Configuration conf = UTIL.getConfiguration();
        conf.setLong("hbase.master.hfilecleaner.ttl", 100L);
        cleaner.setConf(conf);
        Assert.assertTrue((String)("File not set deletable - check mod time:" + this.getFileStats(file, (FileSystem)fs) + " with create time:" + createTime), (boolean)cleaner.isFileDeletable(fs.getFileStatus(file)));
    }

    private String getFileStats(Path file, FileSystem fs) throws IOException {
        FileStatus status = fs.getFileStatus(file);
        return "File" + file + ", mtime:" + status.getModificationTime() + ", atime:" + status.getAccessTime();
    }

    @Test
    public void testHFileCleaning() throws Exception {
        EnvironmentEdge originalEdge = EnvironmentEdgeManager.getDelegate();
        String prefix = "someHFileThatWouldBeAUUID";
        Configuration conf = UTIL.getConfiguration();
        long ttl = 2000L;
        conf.set("hbase.master.hfilecleaner.plugins", "org.apache.hadoop.hbase.master.cleaner.TimeToLiveHFileCleaner");
        conf.setLong("hbase.master.hfilecleaner.ttl", ttl);
        DummyServer server = new DummyServer();
        Path archivedHfileDir = new Path(UTIL.getDataTestDirOnTestFS(), "archive");
        FileSystem fs = FileSystem.get((Configuration)conf);
        HFileCleaner cleaner = new HFileCleaner(1000, (Stoppable)server, conf, fs, archivedHfileDir);
        final long createTime = System.currentTimeMillis();
        fs.delete(archivedHfileDir, true);
        fs.mkdirs(archivedHfileDir);
        fs.createNewFile(new Path(archivedHfileDir, "dfd-dfd"));
        LOG.debug("Now is: " + createTime);
        for (int i = 1; i < 32; ++i) {
            FileStatus[] fileName = new Path(archivedHfileDir, prefix + "." + (createTime + (long)i));
            fs.createNewFile((Path)fileName);
            fs.setTimes((Path)fileName, createTime - ttl - 1L, -1L);
            LOG.debug("Creating " + this.getFileStats((Path)fileName, fs));
        }
        Path saved = new Path(archivedHfileDir, prefix + ".00000000000");
        fs.createNewFile(saved);
        fs.setTimes(saved, createTime - ttl / 2L, -1L);
        LOG.debug("Creating " + this.getFileStats(saved, fs));
        for (FileStatus stat : fs.listStatus(archivedHfileDir)) {
            LOG.debug(stat.getPath().toString());
        }
        Assert.assertEquals((long)33L, (long)fs.listStatus(archivedHfileDir).length);
        EnvironmentEdge setTime = new EnvironmentEdge(){

            public long currentTime() {
                return createTime;
            }
        };
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)setTime);
        cleaner.chore();
        Assert.assertEquals((long)1L, (long)fs.listStatus(archivedHfileDir).length);
        for (FileStatus file : fs.listStatus(archivedHfileDir)) {
            LOG.debug("Kept hfiles: " + file.getPath().getName());
        }
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)originalEdge);
    }

    @Test
    public void testRemovesEmptyDirectories() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setStrings("hbase.master.hfilecleaner.plugins", new String[]{""});
        DummyServer server = new DummyServer();
        Path archivedHfileDir = new Path(UTIL.getDataTestDirOnTestFS(), "archive");
        DistributedFileSystem fs = UTIL.getDFSCluster().getFileSystem();
        HFileCleaner cleaner = new HFileCleaner(1000, (Stoppable)server, conf, (FileSystem)fs, archivedHfileDir);
        Path table = new Path(archivedHfileDir, "table");
        Path region = new Path(table, "regionsomthing");
        Path family = new Path(region, "fam");
        Path file = new Path(family, "file12345");
        fs.mkdirs(family);
        if (!fs.exists(family)) {
            throw new RuntimeException("Couldn't create test family:" + family);
        }
        fs.create(file).close();
        if (!fs.exists(file)) {
            throw new RuntimeException("Test file didn't get created:" + file);
        }
        cleaner.chore();
        Assert.assertFalse((String)"family directory not removed for empty directory", (boolean)fs.exists(family));
        Assert.assertFalse((String)"region directory not removed for empty directory", (boolean)fs.exists(region));
        Assert.assertFalse((String)"table directory not removed for empty directory", (boolean)fs.exists(table));
        Assert.assertTrue((String)"archive directory", (boolean)fs.exists(archivedHfileDir));
    }

    @Test
    public void testThreadCleanup() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setStrings("hbase.master.hfilecleaner.plugins", new String[]{""});
        DummyServer server = new DummyServer();
        Path archivedHfileDir = new Path(UTIL.getDataTestDirOnTestFS(), "archive");
        DistributedFileSystem fs = UTIL.getDFSCluster().getFileSystem();
        HFileCleaner cleaner = new HFileCleaner(1000, (Stoppable)server, conf, (FileSystem)fs, archivedHfileDir);
        fs.delete(archivedHfileDir, true);
        fs.mkdirs(archivedHfileDir);
        fs.createNewFile(new Path(archivedHfileDir, "dfd-dfd"));
        cleaner.chore();
        cleaner.cleanup();
        Thread.sleep(100L);
        for (Thread thread : cleaner.getCleanerThreads()) {
            Assert.assertFalse((boolean)thread.isAlive());
        }
    }

    @Test
    public void testLargeSmallIsolation() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setStrings("hbase.master.hfilecleaner.plugins", new String[]{""});
        conf.setInt("hbase.regionserver.thread.hfilecleaner.throttle", 524288);
        DummyServer server = new DummyServer();
        Path archivedHfileDir = new Path(UTIL.getDataTestDirOnTestFS(), "archive");
        DistributedFileSystem fs = UTIL.getDFSCluster().getFileSystem();
        HFileCleaner cleaner = new HFileCleaner(1000, (Stoppable)server, conf, (FileSystem)fs, archivedHfileDir);
        fs.delete(archivedHfileDir, true);
        fs.mkdirs(archivedHfileDir);
        int LARGE_FILE_NUM = 5;
        int SMALL_FILE_NUM = 20;
        this.createFilesForTesting(5, 20, (FileSystem)fs, archivedHfileDir);
        cleaner.chore();
        Assert.assertEquals((long)5L, (long)cleaner.getNumOfDeletedLargeFiles());
        Assert.assertEquals((long)20L, (long)cleaner.getNumOfDeletedSmallFiles());
    }

    @Test
    public void testOnConfigurationChange() throws Exception {
        int ORIGINAL_THROTTLE_POINT = 524288;
        int ORIGINAL_QUEUE_INIT_SIZE = 512;
        int UPDATE_THROTTLE_POINT = 1024;
        int UPDATE_QUEUE_INIT_SIZE = 1024;
        int LARGE_FILE_NUM = 5;
        int SMALL_FILE_NUM = 20;
        int LARGE_THREAD_NUM = 2;
        int SMALL_THREAD_NUM = 4;
        long THREAD_TIMEOUT_MSEC = 30000L;
        long THREAD_CHECK_INTERVAL_MSEC = 500L;
        Configuration conf = UTIL.getConfiguration();
        conf.setStrings("hbase.master.hfilecleaner.plugins", new String[]{""});
        conf.setInt("hbase.regionserver.thread.hfilecleaner.throttle", 524288);
        conf.setInt("hbase.regionserver.hfilecleaner.large.queue.size", 512);
        conf.setInt("hbase.regionserver.hfilecleaner.small.queue.size", 512);
        DummyServer server = new DummyServer();
        Path archivedHfileDir = new Path(UTIL.getDataTestDirOnTestFS(), "archive");
        DistributedFileSystem fs = UTIL.getDFSCluster().getFileSystem();
        final HFileCleaner cleaner = new HFileCleaner(1000, (Stoppable)server, conf, (FileSystem)fs, archivedHfileDir);
        Assert.assertEquals((long)524288L, (long)cleaner.getThrottlePoint());
        Assert.assertEquals((long)512L, (long)cleaner.getLargeQueueInitSize());
        Assert.assertEquals((long)512L, (long)cleaner.getSmallQueueInitSize());
        Assert.assertEquals((long)60000L, (long)cleaner.getCleanerThreadTimeoutMsec());
        Assert.assertEquals((long)1000L, (long)cleaner.getCleanerThreadCheckIntervalMsec());
        fs.delete(archivedHfileDir, true);
        fs.mkdirs(archivedHfileDir);
        this.createFilesForTesting(5, 20, (FileSystem)fs, archivedHfileDir);
        Thread t = new Thread(){

            @Override
            public void run() {
                cleaner.chore();
            }
        };
        t.setDaemon(true);
        t.start();
        while (cleaner.getNumOfDeletedSmallFiles() == 0L) {
            Thread.yield();
        }
        Configuration newConf = new Configuration(conf);
        newConf.setInt("hbase.regionserver.thread.hfilecleaner.throttle", 1024);
        newConf.setInt("hbase.regionserver.hfilecleaner.large.queue.size", 1024);
        newConf.setInt("hbase.regionserver.hfilecleaner.small.queue.size", 1024);
        newConf.setInt("hbase.regionserver.hfilecleaner.large.thread.count", 2);
        newConf.setInt("hbase.regionserver.hfilecleaner.small.thread.count", 4);
        newConf.setLong("hbase.regionserver.hfilecleaner.thread.timeout.msec", 30000L);
        newConf.setLong("hbase.regionserver.hfilecleaner.thread.check.interval.msec", 500L);
        LOG.debug("File deleted from large queue: " + cleaner.getNumOfDeletedLargeFiles() + "; from small queue: " + cleaner.getNumOfDeletedSmallFiles());
        cleaner.onConfigurationChange(newConf);
        Assert.assertEquals((long)1024L, (long)cleaner.getThrottlePoint());
        Assert.assertEquals((long)1024L, (long)cleaner.getLargeQueueInitSize());
        Assert.assertEquals((long)1024L, (long)cleaner.getSmallQueueInitSize());
        Assert.assertEquals((long)6L, (long)cleaner.getCleanerThreads().size());
        Assert.assertEquals((long)30000L, (long)cleaner.getCleanerThreadTimeoutMsec());
        Assert.assertEquals((long)500L, (long)cleaner.getCleanerThreadCheckIntervalMsec());
        List oldThreads = cleaner.getCleanerThreads();
        cleaner.onConfigurationChange(newConf);
        List newThreads = cleaner.getCleanerThreads();
        Assert.assertArrayEquals((Object[])oldThreads.toArray(), (Object[])newThreads.toArray());
        t.join();
        LOG.debug("File deleted from large queue: " + cleaner.getNumOfDeletedLargeFiles() + "; from small queue: " + cleaner.getNumOfDeletedSmallFiles());
        Assert.assertTrue((String)("Should delete more than 5 files from large queue but actually " + cleaner.getNumOfDeletedLargeFiles()), (cleaner.getNumOfDeletedLargeFiles() > 5L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Should delete less than 20 files from small queue but actually " + cleaner.getNumOfDeletedSmallFiles()), (cleaner.getNumOfDeletedSmallFiles() < 20L ? 1 : 0) != 0);
    }

    private void createFilesForTesting(int largeFileNum, int smallFileNum, FileSystem fs, Path archivedHfileDir) throws IOException {
        FSDataOutputStream out;
        int i;
        Random rand = new Random();
        byte[] large = new byte[0x100000];
        for (int i2 = 0; i2 < large.length; ++i2) {
            large[i2] = (byte)rand.nextInt(128);
        }
        byte[] small = new byte[1024];
        for (i = 0; i < small.length; ++i) {
            small[i] = (byte)rand.nextInt(128);
        }
        for (i = 1; i <= largeFileNum; ++i) {
            out = fs.create(new Path(archivedHfileDir, "large-file-" + i));
            out.write(large);
            out.close();
        }
        for (i = 1; i <= smallFileNum; ++i) {
            out = fs.create(new Path(archivedHfileDir, "small-file-" + i));
            out.write(small);
            out.close();
        }
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        public Configuration getConfiguration() {
            return UTIL.getConfiguration();
        }

        public ZKWatcher getZooKeeper() {
            try {
                return new ZKWatcher(this.getConfiguration(), "dummy server", (Abortable)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)"regionserver,60020,000000");
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }
}

