/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.assignment.MockMasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RecoverMetaProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRecoverMetaProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(TestRecoverMetaProcedure.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecoverMetaProcedure.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @Test
    public void testPrepare() throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException, IOException {
        RecoverMetaProcedure rmp = new RecoverMetaProcedure();
        MasterProcedureEnv env = (MasterProcedureEnv)Mockito.mock(MasterProcedureEnv.class);
        MockMasterServices masterServices = new MockMasterServices(UTIL.getConfiguration(), null);
        Mockito.when((Object)env.getMasterServices()).thenReturn((Object)masterServices);
        Assert.assertEquals((Object)StateMachineProcedure.Flow.HAS_MORE_STATE, (Object)rmp.executeFromState(env, rmp.getInitialState()));
        int stateId = rmp.getCurrentStateId();
        Assert.assertEquals((long)1L, (long)rmp.getCurrentStateId());
    }

    @Test
    public void testPrepareWithMasterStopping() throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException, IOException {
        RecoverMetaProcedure rmp = new RecoverMetaProcedure();
        MasterProcedureEnv env = (MasterProcedureEnv)Mockito.mock(MasterProcedureEnv.class);
        MockMasterServices masterServices = new MockMasterServices(UTIL.getConfiguration(), null){

            @Override
            public boolean isStopping() {
                return true;
            }
        };
        Mockito.when((Object)env.getMasterServices()).thenReturn((Object)masterServices);
        Assert.assertEquals((Object)StateMachineProcedure.Flow.NO_MORE_STATE, (Object)rmp.executeFromState(env, rmp.getInitialState()));
    }

    @Test
    public void testPrepareWithNoCluster() throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException, IOException {
        RecoverMetaProcedure rmp = new RecoverMetaProcedure();
        MasterProcedureEnv env = (MasterProcedureEnv)Mockito.mock(MasterProcedureEnv.class);
        MockMasterServices masterServices = new MockMasterServices(UTIL.getConfiguration(), null){

            @Override
            public boolean isClusterUp() {
                return false;
            }
        };
        Mockito.when((Object)env.getMasterServices()).thenReturn((Object)masterServices);
        Assert.assertEquals((Object)StateMachineProcedure.Flow.NO_MORE_STATE, (Object)rmp.executeFromState(env, rmp.getInitialState()));
    }
}

