/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.procedure.TestServerCrashProcedure;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestServerCrashProcedureWithReplicas
extends TestServerCrashProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerCrashProcedureWithReplicas.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestServerCrashProcedureWithReplicas.class);

    @Override
    protected void startMiniCluster() throws Exception {
        this.util.startMiniCluster(4);
    }

    @Override
    protected Table createTable(TableName tableName) throws IOException {
        Table t = this.util.createTable(tableName, HBaseTestingUtility.COLUMNS, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE, 3);
        return t;
    }

    @Override
    protected void assertReplicaDistributed(Table t) {
        ArrayList<RegionInfo> regionInfos = new ArrayList<RegionInfo>();
        for (JVMClusterUtil.RegionServerThread rs : this.util.getMiniHBaseCluster().getRegionServerThreads()) {
            regionInfos.clear();
            for (Region r : rs.getRegionServer().getRegions(t.getName())) {
                LOG.info("The region is " + r.getRegionInfo() + " the location is " + rs.getRegionServer().getServerName());
                if (this.contains(regionInfos, r.getRegionInfo())) {
                    LOG.error("Am exiting");
                    Assert.fail((String)"Crashed replica regions should not be assigned to same region server");
                    continue;
                }
                regionInfos.add(r.getRegionInfo());
            }
        }
    }

    private boolean contains(List<RegionInfo> regionInfos, RegionInfo regionInfo) {
        for (RegionInfo info : regionInfos) {
            if (!RegionReplicaUtil.isReplicasForSameRegion((RegionInfo)info, (RegionInfo)regionInfo)) continue;
            return true;
        }
        return false;
    }
}

