/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestHRegionInfo {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHRegionInfo.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testPb() throws DeserializationException {
        HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
        byte[] bytes = hri.toByteArray();
        HRegionInfo pbhri = HRegionInfo.parseFrom((byte[])bytes);
        Assert.assertTrue((boolean)hri.equals((Object)pbhri));
    }

    @Test
    public void testReadAndWriteHRegionInfoFile() throws IOException, InterruptedException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
        Path basedir = htu.getDataTestDir();
        FSTableDescriptors fsTableDescriptors = new FSTableDescriptors(htu.getConfiguration());
        HRegion r = HBaseTestingUtility.createRegionAndWAL((RegionInfo)hri, basedir, htu.getConfiguration(), fsTableDescriptors.get(TableName.META_TABLE_NAME));
        long modtime = this.getModTime(r);
        HBaseTestingUtility.closeRegionAndWAL(r);
        Thread.sleep(1001L);
        r = HRegion.openHRegion((Path)basedir, (RegionInfo)hri, (TableDescriptor)fsTableDescriptors.get(TableName.META_TABLE_NAME), null, (Configuration)htu.getConfiguration());
        long modtime2 = this.getModTime(r);
        Assert.assertEquals((long)modtime, (long)modtime2);
        RegionInfo deserializedHri = HRegionFileSystem.loadRegionInfoFileContent((FileSystem)r.getRegionFileSystem().getFileSystem(), (Path)r.getRegionFileSystem().getRegionDir());
        Assert.assertTrue((RegionInfo.COMPARATOR.compare(hri, deserializedHri) == 0 ? 1 : 0) != 0);
        HBaseTestingUtility.closeRegionAndWAL(r);
    }

    long getModTime(HRegion r) throws IOException {
        FileStatus[] statuses = r.getRegionFileSystem().getFileSystem().listStatus(new Path(r.getRegionFileSystem().getRegionDir(), ".regioninfo"));
        Assert.assertTrue((statuses != null && statuses.length == 1 ? 1 : 0) != 0);
        return statuses[0].getModificationTime();
    }

    @Test
    public void testCreateHRegionInfoName() throws Exception {
        String tableName = this.name.getMethodName();
        TableName tn = TableName.valueOf((String)tableName);
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = HRegionInfo.createRegionName((TableName)tn, (byte[])sk, (String)id, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id), (Object)nameStr);
        String md5HashInHex = MD5Hash.getMD5AsHex((byte[])name);
        Assert.assertEquals((long)32L, (long)md5HashInHex.length());
        name = HRegionInfo.createRegionName((TableName)tn, (byte[])sk, (String)id, (boolean)true);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "." + md5HashInHex + "."), (Object)nameStr);
    }

    @Test
    public void testContainsRange() {
        HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HRegionInfo hri = new HRegionInfo(tableDesc.getTableName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g"));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"a")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"c")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"g"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"z")));
        try {
            hri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"a"));
            Assert.fail((String)"Invalid range did not throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLastRegionCompare() {
        HRegionInfo hric;
        HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HRegionInfo hrip = new HRegionInfo(tableDesc.getTableName(), Bytes.toBytes((String)"a"), new byte[0]);
        Assert.assertTrue((hrip.compareTo(hric = new HRegionInfo(tableDesc.getTableName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"))) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetaTables() {
        Assert.assertTrue((boolean)HRegionInfo.FIRST_META_REGIONINFO.isMetaRegion());
    }

    @Test
    public void testComparator() {
        HRegionInfo newer;
        byte[] empty;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HRegionInfo older = new HRegionInfo(tableName, empty = new byte[0], empty, false, 0L);
        Assert.assertTrue((older.compareTo(newer = new HRegionInfo(tableName, empty, empty, false, 1L)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((newer.compareTo(older) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)older.compareTo(older));
        Assert.assertEquals((long)0L, (long)newer.compareTo(newer));
        HRegionInfo a = new HRegionInfo(TableName.valueOf((String)"a"), null, null);
        HRegionInfo b = new HRegionInfo(TableName.valueOf((String)"b"), null, null);
        Assert.assertNotEquals((long)0L, (long)a.compareTo(b));
        HTableDescriptor t = new HTableDescriptor(TableName.valueOf((String)"t"));
        byte[] midway = Bytes.toBytes((String)"midway");
        a = new HRegionInfo(t.getTableName(), null, midway);
        b = new HRegionInfo(t.getTableName(), midway, null);
        Assert.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.compareTo(a) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)a, (Object)a);
        Assert.assertEquals((long)0L, (long)a.compareTo(a));
        a = new HRegionInfo(t.getTableName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"d"));
        b = new HRegionInfo(t.getTableName(), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"g"));
        Assert.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
        a = new HRegionInfo(t.getTableName(), Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"dddd"));
        b = new HRegionInfo(t.getTableName(), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"g"));
        Assert.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
        a = new HRegionInfo(t.getTableName(), Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"dddd"));
        b = new HRegionInfo(t.getTableName(), Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eeee"));
        Assert.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegionNameForRegionReplicas() throws Exception {
        String tableName = this.name.getMethodName();
        TableName tn = TableName.valueOf((String)tableName);
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = HRegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)0, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id), (Object)nameStr);
        name = HRegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)1, (boolean)false);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "_" + String.format("%04X", 1)), (Object)nameStr);
        name = HRegionInfo.createRegionName((TableName)tn, (byte[])sk, (byte[])Bytes.toBytes((String)id), (int)65535, (boolean)false);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "_" + String.format("%04X", 65535)), (Object)nameStr);
    }

    @Test
    public void testParseName() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] startKey = Bytes.toBytes((String)"startKey");
        long regionId = System.currentTimeMillis();
        int replicaId = 42;
        byte[] regionName = HRegionInfo.createRegionName((TableName)tableName, (byte[])startKey, (long)regionId, (boolean)false);
        byte[][] fields = HRegionInfo.parseRegionName((byte[])regionName);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[0]), (byte[])tableName.getName(), (byte[])fields[0]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[1]), (byte[])startKey, (byte[])fields[1]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[2]), (byte[])Bytes.toBytes((String)Long.toString(regionId)), (byte[])fields[2]);
        Assert.assertEquals((long)3L, (long)fields.length);
        regionName = HRegionInfo.createRegionName((TableName)tableName, (byte[])startKey, (long)regionId, (int)replicaId, (boolean)false);
        fields = HRegionInfo.parseRegionName((byte[])regionName);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[0]), (byte[])tableName.getName(), (byte[])fields[0]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[1]), (byte[])startKey, (byte[])fields[1]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[2]), (byte[])Bytes.toBytes((String)Long.toString(regionId)), (byte[])fields[2]);
        Assert.assertArrayEquals((String)Bytes.toString((byte[])fields[3]), (byte[])Bytes.toBytes((String)String.format("%04X", replicaId)), (byte[])fields[3]);
    }

    @Test
    public void testConvert() {
        TableName tableName = TableName.valueOf((String)("ns1:" + this.name.getMethodName()));
        byte[] startKey = Bytes.toBytes((String)"startKey");
        byte[] endKey = Bytes.toBytes((String)"endKey");
        boolean split = false;
        long regionId = System.currentTimeMillis();
        int replicaId = 42;
        HRegionInfo hri = new HRegionInfo(tableName, startKey, endKey, split, regionId, replicaId);
        HRegionInfo convertedHri = HRegionInfo.convert((HBaseProtos.RegionInfo)HRegionInfo.convert((HRegionInfo)hri));
        Assert.assertEquals((Object)hri, (Object)convertedHri);
        HBaseProtos.RegionInfo info = HBaseProtos.RegionInfo.newBuilder().setTableName(HBaseProtos.TableName.newBuilder().setQualifier(UnsafeByteOperations.unsafeWrap((byte[])tableName.getQualifier())).setNamespace(UnsafeByteOperations.unsafeWrap((byte[])tableName.getNamespace())).build()).setStartKey(UnsafeByteOperations.unsafeWrap((byte[])startKey)).setEndKey(UnsafeByteOperations.unsafeWrap((byte[])endKey)).setSplit(split).setRegionId(regionId).build();
        convertedHri = HRegionInfo.convert((HBaseProtos.RegionInfo)info);
        HRegionInfo expectedHri = new HRegionInfo(tableName, startKey, endKey, split, regionId, 0);
        Assert.assertEquals((Object)expectedHri, (Object)convertedHri);
    }
}

