/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.hbase.zookeeper.EmptyWatcher;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ConnectStringParser;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class Canary
implements Tool {
    private static final int USAGE_EXIT_CODE = 1;
    private static final int INIT_ERROR_EXIT_CODE = 2;
    private static final int TIMEOUT_ERROR_EXIT_CODE = 3;
    private static final int ERROR_EXIT_CODE = 4;
    private static final int FAILURE_EXIT_CODE = 5;
    private static final long DEFAULT_INTERVAL = 60000L;
    private static final long DEFAULT_TIMEOUT = 600000L;
    private static final int MAX_THREADS_NUM = 16;
    private static final Logger LOG = LoggerFactory.getLogger(Canary.class);
    public static final TableName DEFAULT_WRITE_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"canary");
    private static final String CANARY_TABLE_FAMILY_NAME = "Test";
    private Configuration conf = null;
    private long interval = 0L;
    private Sink sink = null;
    private boolean useRegExp;
    private long timeout = 600000L;
    private boolean failOnError = true;
    private boolean regionServerMode = false;
    private boolean zookeeperMode = false;
    private long permittedFailures = 0L;
    private boolean regionServerAllRegions = false;
    private boolean writeSniffing = false;
    private long configuredWriteTableTimeout = 600000L;
    private boolean treatFailureAsError = false;
    private TableName writeTableName = DEFAULT_WRITE_TABLE_NAME;
    private HashMap<String, Long> configuredReadTableTimeouts = new HashMap();
    private ExecutorService executor;

    public Canary() {
        this(new ScheduledThreadPoolExecutor(1));
    }

    public Canary(ExecutorService executor) {
        this(executor, null);
    }

    @VisibleForTesting
    Canary(ExecutorService executor, Sink sink) {
        this.executor = executor;
        this.sink = sink;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    private int parseArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.startsWith("-")) {
                if (index >= 0) {
                    System.err.println("Invalid command line options");
                    this.printUsageAndExit();
                }
                if (cmd.equals("-help") || cmd.equals("-h")) {
                    this.printUsageAndExit();
                    continue;
                }
                if (cmd.equals("-daemon") && this.interval == 0L) {
                    this.interval = 60000L;
                    continue;
                }
                if (cmd.equals("-interval")) {
                    if (++i == args.length) {
                        System.err.println("-interval takes a numeric seconds value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.interval = Long.parseLong(args[i]) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-interval needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                if (cmd.equals("-zookeeper")) {
                    this.zookeeperMode = true;
                    continue;
                }
                if (cmd.equals("-regionserver")) {
                    this.regionServerMode = true;
                    continue;
                }
                if (cmd.equals("-allRegions")) {
                    this.regionServerAllRegions = true;
                    continue;
                }
                if (cmd.equals("-writeSniffing")) {
                    this.writeSniffing = true;
                    continue;
                }
                if (cmd.equals("-treatFailureAsError") || cmd.equals("-failureAsError")) {
                    this.treatFailureAsError = true;
                    continue;
                }
                if (cmd.equals("-e")) {
                    this.useRegExp = true;
                    continue;
                }
                if (cmd.equals("-t")) {
                    if (++i == args.length) {
                        System.err.println("-t takes a numeric milliseconds value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.timeout = Long.parseLong(args[i]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-t takes a numeric milliseconds value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                if (cmd.equals("-writeTableTimeout")) {
                    if (++i == args.length) {
                        System.err.println("-writeTableTimeout takes a numeric milliseconds value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.configuredWriteTableTimeout = Long.parseLong(args[i]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-writeTableTimeout takes a numeric milliseconds value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                if (cmd.equals("-writeTable")) {
                    if (++i == args.length) {
                        System.err.println("-writeTable takes a string tablename value argument.");
                        this.printUsageAndExit();
                    }
                    this.writeTableName = TableName.valueOf((String)args[i]);
                    continue;
                }
                if (cmd.equals("-f")) {
                    if (++i == args.length) {
                        System.err.println("-f needs a boolean value argument (true|false).");
                        this.printUsageAndExit();
                    }
                    this.failOnError = Boolean.parseBoolean(args[i]);
                    continue;
                }
                if (cmd.equals("-readTableTimeouts")) {
                    String[] tableTimeouts;
                    if (++i == args.length) {
                        System.err.println("-readTableTimeouts needs a comma-separated list of read millisecond timeouts per table (without spaces).");
                        this.printUsageAndExit();
                    }
                    for (String tT : tableTimeouts = args[i].split(",")) {
                        String[] nameTimeout = tT.split("=");
                        if (nameTimeout.length < 2) {
                            System.err.println("Each -readTableTimeouts argument must be of the form <tableName>=<read timeout> (without spaces).");
                            this.printUsageAndExit();
                        }
                        long timeoutVal = 0L;
                        try {
                            timeoutVal = Long.parseLong(nameTimeout[1]);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("-readTableTimeouts read timeout for each table must be a numeric value argument.");
                            this.printUsageAndExit();
                        }
                        this.configuredReadTableTimeouts.put(nameTimeout[0], timeoutVal);
                    }
                    continue;
                }
                if (cmd.equals("-permittedZookeeperFailures")) {
                    if (++i == args.length) {
                        System.err.println("-permittedZookeeperFailures needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    try {
                        this.permittedFailures = Long.parseLong(args[i]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("-permittedZookeeperFailures needs a numeric value argument.");
                        this.printUsageAndExit();
                    }
                    continue;
                }
                System.err.println(cmd + " options is invalid.");
                this.printUsageAndExit();
                continue;
            }
            if (index >= 0) continue;
            index = i;
        }
        if (this.regionServerAllRegions && !this.regionServerMode) {
            System.err.println("-allRegions can only be specified in regionserver mode.");
            this.printUsageAndExit();
        }
        if (this.zookeeperMode && (this.regionServerMode || this.regionServerAllRegions || this.writeSniffing)) {
            System.err.println("-zookeeper is exclusive and cannot be combined with other modes.");
            this.printUsageAndExit();
        }
        if (this.permittedFailures != 0L && !this.zookeeperMode) {
            System.err.println("-permittedZookeeperFailures requires -zookeeper mode.");
            this.printUsageAndExit();
        }
        if (!this.configuredReadTableTimeouts.isEmpty() && (this.regionServerMode || this.zookeeperMode)) {
            System.err.println("-readTableTimeouts can only be configured in region mode.");
            this.printUsageAndExit();
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] args) throws Exception {
        int index = this.parseArgs(args);
        ChoreService choreService = null;
        ScheduledChore authChore = AuthUtil.getAuthChore((Configuration)this.conf);
        if (authChore != null) {
            choreService = new ChoreService("CANARY_TOOL");
            choreService.scheduleChore(authChore);
        }
        Monitor monitor = null;
        Thread monitorThread = null;
        long startTime = 0L;
        long currentTimeLength = 0L;
        try (Connection connection = ConnectionFactory.createConnection((Configuration)this.conf);){
            do {
                try {
                    monitor = this.newMonitor(connection, index, args);
                    monitorThread = new Thread((Runnable)monitor, "CanaryMonitor-" + System.currentTimeMillis());
                    startTime = System.currentTimeMillis();
                    monitorThread.start();
                    while (!monitor.isDone()) {
                        Thread.sleep(1000L);
                        if (this.failOnError && monitor.hasError()) {
                            monitorThread.interrupt();
                            if (monitor.initialized) {
                                int n = monitor.errorCode;
                                return n;
                            }
                            int n = 2;
                            return n;
                        }
                        currentTimeLength = System.currentTimeMillis() - startTime;
                        if (currentTimeLength <= this.timeout) continue;
                        LOG.error("The monitor is running too long (" + currentTimeLength + ") after timeout limit:" + this.timeout + " will be killed itself !!");
                        if (monitor.initialized) {
                            int n = 3;
                            return n;
                        }
                        int n = 2;
                        return n;
                    }
                    if (this.failOnError && monitor.finalCheckForErrors()) {
                        monitorThread.interrupt();
                        int n = monitor.errorCode;
                        return n;
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                Thread.sleep(this.interval);
            } while (this.interval > 0L);
        }
        if (choreService == null) return monitor.errorCode;
        choreService.shutdown();
        return monitor.errorCode;
    }

    public Map<String, String> getReadFailures() {
        return this.sink.getReadFailures();
    }

    public Map<String, String> getWriteFailures() {
        return this.sink.getWriteFailures();
    }

    private void printUsageAndExit() {
        System.err.println("Usage: canary [OPTIONS] [<TABLE1> [<TABLE2]...] | [<REGIONSERVER1> [<REGIONSERVER2]..]");
        System.err.println("Where [OPTIONS] are:");
        System.err.println(" -h,-help        show this help and exit.");
        System.err.println(" -regionserver   set 'regionserver mode'; gets row from random region on server");
        System.err.println(" -allRegions     get from ALL regions when 'regionserver mode', not just random one.");
        System.err.println(" -zookeeper      set 'zookeeper mode'; grab zookeeper.znode.parent on each ensemble member");
        System.err.println(" -daemon         continuous check at defined intervals.");
        System.err.println(" -interval <N>   interval between checks in seconds");
        System.err.println(" -e              consider table/regionserver argument as regular expression");
        System.err.println(" -f <B>          exit on first error; default=true");
        System.err.println(" -failureAsError treat read/write failure as error");
        System.err.println(" -t <N>          timeout for canary-test run; default=600000ms");
        System.err.println(" -writeSniffing  enable write sniffing");
        System.err.println(" -writeTable     the table used for write sniffing; default=hbase:canary");
        System.err.println(" -writeTableTimeout <N>  timeout for writeTable; default=600000ms");
        System.err.println(" -readTableTimeouts <tableName>=<read timeout>,<tableName>=<read timeout>,...");
        System.err.println("                comma-separated list of table read timeouts (no spaces);");
        System.err.println("                logs 'ERROR' if takes longer. default=600000ms");
        System.err.println(" -permittedZookeeperFailures <N>  Ignore first N failures attempting to ");
        System.err.println("                connect to individual zookeeper nodes in ensemble");
        System.err.println("");
        System.err.println(" -D<configProperty>=<value> to assign or override configuration params");
        System.err.println(" -Dhbase.canary.read.raw.enabled=<true/false> Set to enable/disable raw scan; default=false");
        System.err.println("");
        System.err.println("Canary runs in one of three modes: region (default), regionserver, or zookeeper.");
        System.err.println("To sniff/probe all regions, pass no arguments.");
        System.err.println("To sniff/probe all regions of a table, pass tablename.");
        System.err.println("To sniff/probe regionservers, pass -regionserver, etc.");
        System.err.println("See http://hbase.apache.org/book.html#_canary for Canary documentation.");
        System.exit(1);
    }

    Sink getSink(Configuration configuration, Class clazz) {
        return this.sink != null ? this.sink : (Sink)ReflectionUtils.newInstance((Class)configuration.getClass("hbase.canary.sink.class", clazz, Sink.class), (Object[])new Object[0]);
    }

    public Monitor newMonitor(Connection connection, int index, String[] args) {
        Monitor monitor = null;
        String[] monitorTargets = null;
        if (index >= 0) {
            int length = args.length - index;
            monitorTargets = new String[length];
            System.arraycopy(args, index, monitorTargets, 0, length);
        }
        monitor = this.regionServerMode ? new RegionServerMonitor(connection, monitorTargets, this.useRegExp, this.getSink(connection.getConfiguration(), RegionServerStdOutSink.class), this.executor, this.regionServerAllRegions, this.treatFailureAsError, this.permittedFailures) : (this.zookeeperMode ? new ZookeeperMonitor(connection, monitorTargets, this.useRegExp, this.getSink(connection.getConfiguration(), ZookeeperStdOutSink.class), this.executor, this.treatFailureAsError, this.permittedFailures) : new RegionMonitor(connection, monitorTargets, this.useRegExp, this.getSink(connection.getConfiguration(), RegionStdOutSink.class), this.executor, this.writeSniffing, this.writeTableName, this.treatFailureAsError, this.configuredReadTableTimeouts, this.configuredWriteTableTimeout, this.permittedFailures));
        return monitor;
    }

    private static List<Future<Void>> sniff(Admin admin, Sink sink, String tableName, ExecutorService executor, RegionTask.TaskType taskType, boolean rawScanEnabled, LongAdder readLatency) throws Exception {
        LOG.debug("Checking table is enabled and getting table descriptor for table {}", (Object)tableName);
        if (admin.isTableEnabled(TableName.valueOf((String)tableName))) {
            return Canary.sniff(admin, sink, admin.getDescriptor(TableName.valueOf((String)tableName)), executor, taskType, rawScanEnabled, readLatency);
        }
        LOG.warn("Table {} is not enabled", (Object)tableName);
        return new LinkedList<Future<Void>>();
    }

    /*
     * Exception decompiling
     */
    private static List<Future<Void>> sniff(Admin admin, Sink sink, TableDescriptor tableDesc, ExecutorService executor, RegionTask.TaskType taskType, boolean rawScanEnabled, LongAdder rwLatency) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        new GenericOptionsParser(conf, args);
        int numThreads = conf.getInt("hbase.canary.threads.num", 16);
        LOG.info("Execution thread count={}", (Object)numThreads);
        int exitCode = 0;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(numThreads);
        try {
            exitCode = ToolRunner.run((Configuration)conf, (Tool)new Canary(executor), (String[])args);
        }
        finally {
            executor.shutdown();
        }
        System.exit(exitCode);
    }

    private static class RegionServerMonitor
    extends Monitor {
        private boolean allRegions;

        public RegionServerMonitor(Connection connection, String[] monitorTargets, boolean useRegExp, Sink sink, ExecutorService executor, boolean allRegions, boolean treatFailureAsError, long allowedFailures) {
            super(connection, monitorTargets, useRegExp, sink, executor, treatFailureAsError, allowedFailures);
            this.allRegions = allRegions;
        }

        private RegionServerStdOutSink getSink() {
            if (!(this.sink instanceof RegionServerStdOutSink)) {
                throw new RuntimeException("Can only write to regionserver sink");
            }
            return (RegionServerStdOutSink)this.sink;
        }

        @Override
        public void run() {
            if (this.initAdmin() && this.checkNoTableNames()) {
                RegionServerStdOutSink regionServerSink = null;
                try {
                    regionServerSink = this.getSink();
                }
                catch (RuntimeException e) {
                    LOG.error("Run RegionServerMonitor failed!", (Throwable)e);
                    this.errorCode = 4;
                }
                Map<String, List<RegionInfo>> rsAndRMap = this.filterRegionServerByName();
                this.initialized = true;
                this.monitorRegionServers(rsAndRMap, regionServerSink);
            }
            this.done = true;
        }

        private boolean checkNoTableNames() {
            ArrayList<String> foundTableNames = new ArrayList<String>();
            TableName[] tableNames = null;
            LOG.debug("Reading list of tables");
            try {
                tableNames = this.admin.listTableNames();
            }
            catch (IOException e) {
                LOG.error("Get listTableNames failed", (Throwable)e);
                this.errorCode = 2;
                return false;
            }
            if (this.targets == null || this.targets.length == 0) {
                return true;
            }
            for (String target : this.targets) {
                for (TableName tableName : tableNames) {
                    if (!target.equals(tableName.getNameAsString())) continue;
                    foundTableNames.add(target);
                }
            }
            if (foundTableNames.size() > 0) {
                System.err.println("Cannot pass a tablename when using the -regionserver option, tablenames:" + ((Object)foundTableNames).toString());
                this.errorCode = 1;
            }
            return foundTableNames.isEmpty();
        }

        private void monitorRegionServers(Map<String, List<RegionInfo>> rsAndRMap, RegionServerStdOutSink regionServerSink) {
            String serverName;
            ArrayList<RegionServerTask> tasks = new ArrayList<RegionServerTask>();
            HashMap<String, AtomicLong> successMap = new HashMap<String, AtomicLong>();
            Random rand = new Random();
            for (Map.Entry<String, List<RegionInfo>> entry : rsAndRMap.entrySet()) {
                serverName = entry.getKey();
                AtomicLong successes = new AtomicLong(0L);
                successMap.put(serverName, successes);
                if (entry.getValue().isEmpty()) {
                    LOG.error("Regionserver not serving any regions - {}", (Object)serverName);
                    continue;
                }
                if (this.allRegions) {
                    for (RegionInfo region : entry.getValue()) {
                        tasks.add(new RegionServerTask(this.connection, serverName, region, regionServerSink, successes));
                    }
                    continue;
                }
                RegionInfo region = entry.getValue().get(rand.nextInt(entry.getValue().size()));
                tasks.add(new RegionServerTask(this.connection, serverName, region, regionServerSink, successes));
            }
            try {
                for (Future future : this.executor.invokeAll(tasks)) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        LOG.error("Sniff regionserver failed!", (Throwable)e);
                        this.errorCode = 4;
                    }
                }
                if (this.allRegions) {
                    for (Map.Entry entry : rsAndRMap.entrySet()) {
                        serverName = (String)entry.getKey();
                        LOG.info("Successfully read {} regions out of {} on regionserver {}", new Object[]{successMap.get(serverName), ((List)entry.getValue()).size(), serverName});
                    }
                }
            }
            catch (InterruptedException e) {
                this.errorCode = 4;
                LOG.error("Sniff regionserver interrupted!", (Throwable)e);
            }
        }

        private Map<String, List<RegionInfo>> filterRegionServerByName() {
            Map<String, List<RegionInfo>> regionServerAndRegionsMap = this.getAllRegionServerByName();
            regionServerAndRegionsMap = this.doFilterRegionServerByName(regionServerAndRegionsMap);
            return regionServerAndRegionsMap;
        }

        private Map<String, List<RegionInfo>> getAllRegionServerByName() {
            HashMap<String, List<RegionInfo>> rsAndRMap = new HashMap<String, List<RegionInfo>>();
            try {
                LOG.debug("Reading list of tables and locations");
                List tableDescs = this.admin.listTableDescriptors();
                List<RegionInfo> regions = null;
                for (TableDescriptor tableDesc : tableDescs) {
                    RegionLocator regionLocator = this.admin.getConnection().getRegionLocator(tableDesc.getTableName());
                    Throwable throwable = null;
                    try {
                        for (HRegionLocation location : regionLocator.getAllRegionLocations()) {
                            ServerName rs = location.getServerName();
                            String rsName = rs.getHostname();
                            RegionInfo r = location.getRegion();
                            if (rsAndRMap.containsKey(rsName)) {
                                regions = (List)rsAndRMap.get(rsName);
                            } else {
                                regions = new ArrayList();
                                rsAndRMap.put(rsName, regions);
                            }
                            regions.add(r);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (regionLocator == null) continue;
                        if (throwable != null) {
                            try {
                                regionLocator.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        regionLocator.close();
                    }
                }
                for (ServerName rs : this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
                    String rsName = rs.getHostname();
                    if (rsAndRMap.containsKey(rsName)) continue;
                    rsAndRMap.put(rsName, Collections.emptyList());
                }
            }
            catch (IOException e) {
                LOG.error("Get HTables info failed", (Throwable)e);
                this.errorCode = 2;
            }
            return rsAndRMap;
        }

        private Map<String, List<RegionInfo>> doFilterRegionServerByName(Map<String, List<RegionInfo>> fullRsAndRMap) {
            Map<String, List<RegionInfo>> filteredRsAndRMap = null;
            if (this.targets != null && this.targets.length > 0) {
                filteredRsAndRMap = new HashMap<String, List<RegionInfo>>();
                Pattern pattern = null;
                Matcher matcher = null;
                boolean regExpFound = false;
                for (String rsName : this.targets) {
                    if (this.useRegExp) {
                        regExpFound = false;
                        pattern = Pattern.compile(rsName);
                        for (Map.Entry<String, List<RegionInfo>> entry : fullRsAndRMap.entrySet()) {
                            matcher = pattern.matcher(entry.getKey());
                            if (!matcher.matches()) continue;
                            filteredRsAndRMap.put(entry.getKey(), entry.getValue());
                            regExpFound = true;
                        }
                        if (regExpFound) continue;
                        LOG.info("No RegionServerInfo found, regionServerPattern {}", (Object)rsName);
                        continue;
                    }
                    if (fullRsAndRMap.containsKey(rsName)) {
                        filteredRsAndRMap.put(rsName, fullRsAndRMap.get(rsName));
                        continue;
                    }
                    LOG.info("No RegionServerInfo found, regionServerName {}", (Object)rsName);
                }
            } else {
                filteredRsAndRMap = fullRsAndRMap;
            }
            return filteredRsAndRMap;
        }
    }

    private static class ZookeeperMonitor
    extends Monitor {
        private List<String> hosts;
        private final String znode;
        private final int timeout;

        protected ZookeeperMonitor(Connection connection, String[] monitorTargets, boolean useRegExp, Sink sink, ExecutorService executor, boolean treatFailureAsError, long allowedFailures) {
            super(connection, monitorTargets, useRegExp, sink, executor, treatFailureAsError, allowedFailures);
            Configuration configuration = connection.getConfiguration();
            this.znode = configuration.get("zookeeper.znode.parent", "/hbase");
            this.timeout = configuration.getInt("zookeeper.session.timeout", 90000);
            ConnectStringParser parser = new ConnectStringParser(ZKConfig.getZKQuorumServersString((Configuration)configuration));
            this.hosts = Lists.newArrayList();
            for (InetSocketAddress server : parser.getServerAddresses()) {
                this.hosts.add(server.toString());
            }
            if (allowedFailures > (long)((this.hosts.size() - 1) / 2)) {
                LOG.warn("Confirm allowable number of failed ZooKeeper nodes, as quorum will already be lost. Setting of {} failures is unexpected for {} ensemble size.", (Object)allowedFailures, (Object)this.hosts.size());
            }
        }

        @Override
        public void run() {
            ArrayList tasks = Lists.newArrayList();
            ZookeeperStdOutSink zkSink = null;
            try {
                zkSink = this.getSink();
            }
            catch (RuntimeException e) {
                LOG.error("Run ZooKeeperMonitor failed!", (Throwable)e);
                this.errorCode = 4;
            }
            this.initialized = true;
            for (String string : this.hosts) {
                tasks.add(new ZookeeperTask(this.connection, string, this.znode, this.timeout, zkSink));
            }
            try {
                for (Future future : this.executor.invokeAll(tasks)) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        LOG.error("Sniff zookeeper failed!", (Throwable)e);
                        this.errorCode = 4;
                    }
                }
            }
            catch (InterruptedException e) {
                this.errorCode = 4;
                Thread.currentThread().interrupt();
                LOG.error("Sniff zookeeper interrupted!", (Throwable)e);
            }
            this.done = true;
        }

        private ZookeeperStdOutSink getSink() {
            if (!(this.sink instanceof ZookeeperStdOutSink)) {
                throw new RuntimeException("Can only write to zookeeper sink");
            }
            return (ZookeeperStdOutSink)this.sink;
        }
    }

    private static class RegionMonitor
    extends Monitor {
        private static final int DEFAULT_WRITE_TABLE_CHECK_PERIOD = 600000;
        private static final int DEFAULT_WRITE_DATA_TTL = 86400;
        private long lastCheckTime = -1L;
        private boolean writeSniffing;
        private TableName writeTableName;
        private int writeDataTTL;
        private float regionsLowerLimit;
        private float regionsUpperLimit;
        private int checkPeriod;
        private boolean rawScanEnabled;
        private HashMap<String, Long> configuredReadTableTimeouts;
        private long configuredWriteTableTimeout;

        public RegionMonitor(Connection connection, String[] monitorTargets, boolean useRegExp, Sink sink, ExecutorService executor, boolean writeSniffing, TableName writeTableName, boolean treatFailureAsError, HashMap<String, Long> configuredReadTableTimeouts, long configuredWriteTableTimeout, long allowedFailures) {
            super(connection, monitorTargets, useRegExp, sink, executor, treatFailureAsError, allowedFailures);
            Configuration conf = connection.getConfiguration();
            this.writeSniffing = writeSniffing;
            this.writeTableName = writeTableName;
            this.writeDataTTL = conf.getInt("hbase.canary.write.data.ttl", 86400);
            this.regionsLowerLimit = conf.getFloat("hbase.canary.write.perserver.regions.lowerLimit", 1.0f);
            this.regionsUpperLimit = conf.getFloat("hbase.canary.write.perserver.regions.upperLimit", 1.5f);
            this.checkPeriod = conf.getInt("hbase.canary.write.table.check.period", 600000);
            this.rawScanEnabled = conf.getBoolean("hbase.canary.read.raw.enabled", false);
            this.configuredReadTableTimeouts = new HashMap<String, Long>(configuredReadTableTimeouts);
            this.configuredWriteTableTimeout = configuredWriteTableTimeout;
        }

        private RegionStdOutSink getSink() {
            if (!(this.sink instanceof RegionStdOutSink)) {
                throw new RuntimeException("Can only write to Region sink");
            }
            return (RegionStdOutSink)this.sink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.initAdmin()) {
                try {
                    LinkedList<Future<Void>> taskFutures = new LinkedList<Future<Void>>();
                    RegionStdOutSink regionSink = this.getSink();
                    if (this.targets != null && this.targets.length > 0) {
                        String[] tables = this.generateMonitorTables(this.targets);
                        if (!new HashSet<String>(Arrays.asList(tables)).containsAll(this.configuredReadTableTimeouts.keySet())) {
                            LOG.error("-readTableTimeouts can only specify read timeouts for monitor targets passed via command line.");
                            this.errorCode = 1;
                            return;
                        }
                        this.initialized = true;
                        for (String table : tables) {
                            LongAdder readLatency = regionSink.initializeAndGetReadLatencyForTable(table);
                            taskFutures.addAll(Canary.sniff(this.admin, regionSink, table, this.executor, RegionTask.TaskType.READ, this.rawScanEnabled, readLatency));
                        }
                    } else {
                        taskFutures.addAll(this.sniff(RegionTask.TaskType.READ, regionSink));
                    }
                    if (this.writeSniffing) {
                        if (EnvironmentEdgeManager.currentTime() - this.lastCheckTime > (long)this.checkPeriod) {
                            try {
                                this.checkWriteTableDistribution();
                            }
                            catch (IOException e) {
                                LOG.error("Check canary table distribution failed!", (Throwable)e);
                            }
                            this.lastCheckTime = EnvironmentEdgeManager.currentTime();
                        }
                        regionSink.initializeWriteLatency();
                        LongAdder writeTableLatency = regionSink.getWriteLatency();
                        taskFutures.addAll(Canary.sniff(this.admin, regionSink, this.admin.getDescriptor(this.writeTableName), this.executor, RegionTask.TaskType.WRITE, this.rawScanEnabled, writeTableLatency));
                    }
                    for (Future future : taskFutures) {
                        try {
                            future.get();
                        }
                        catch (ExecutionException executionException) {
                            LOG.error("Sniff region failed!", (Throwable)executionException);
                        }
                    }
                    Map<String, LongAdder> actualReadTableLatency = regionSink.getReadLatencyMap();
                    for (Map.Entry<String, Long> entry : this.configuredReadTableTimeouts.entrySet()) {
                        String tableName = entry.getKey();
                        if (actualReadTableLatency.containsKey(tableName)) {
                            Long actual = actualReadTableLatency.get(tableName).longValue();
                            Long configured = entry.getValue();
                            if (actual > configured) {
                                LOG.error("Read operation for {} took {}ms (Configured read timeout {}ms.", new Object[]{tableName, actual, configured});
                                continue;
                            }
                            LOG.info("Read operation for {} took {}ms (Configured read timeout {}ms.", new Object[]{tableName, actual, configured});
                            continue;
                        }
                        LOG.error("Read operation for {} failed!", (Object)tableName);
                    }
                    if (this.writeSniffing) {
                        String string = this.writeTableName.getNameAsString();
                        long l = regionSink.getWriteLatency().longValue();
                        LOG.info("Write operation for {} took {}ms. Configured write timeout {}ms.", new Object[]{string, l, this.configuredWriteTableTimeout});
                        if (l > this.configuredWriteTableTimeout) {
                            LOG.error("Write operation for {} exceeded the configured write timeout.", (Object)string);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("Run regionMonitor failed", (Throwable)e);
                    this.errorCode = 4;
                }
                finally {
                    this.done = true;
                }
            }
            this.done = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String[] generateMonitorTables(String[] monitorTargets) throws IOException {
            String[] returnTables = null;
            if (!this.useRegExp) return monitorTargets;
            Pattern pattern = null;
            HTableDescriptor[] tds = null;
            TreeSet<String> tmpTables = new TreeSet<String>();
            try {
                LOG.debug(String.format("reading list of tables", new Object[0]));
                tds = this.admin.listTables(pattern);
                if (tds == null) {
                    tds = new TableDescriptor[]{};
                }
                for (String monitorTarget : monitorTargets) {
                    pattern = Pattern.compile(monitorTarget);
                    for (HTableDescriptor td : tds) {
                        if (!pattern.matcher(td.getTableName().getNameAsString()).matches()) continue;
                        tmpTables.add(td.getTableName().getNameAsString());
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Communicate with admin failed", (Throwable)e);
                throw e;
            }
            if (tmpTables.size() > 0) {
                return tmpTables.toArray(new String[tmpTables.size()]);
            }
            String msg = "No HTable found, tablePattern:" + Arrays.toString(monitorTargets);
            LOG.error(msg);
            this.errorCode = 2;
            throw new TableNotFoundException(msg);
        }

        private List<Future<Void>> sniff(RegionTask.TaskType taskType, RegionStdOutSink regionSink) throws Exception {
            LOG.debug("Reading list of tables");
            LinkedList<Future<Void>> taskFutures = new LinkedList<Future<Void>>();
            for (TableDescriptor td : this.admin.listTableDescriptors()) {
                if (!this.admin.isTableEnabled(td.getTableName()) || td.getTableName().equals((Object)this.writeTableName)) continue;
                LongAdder readLatency = regionSink.initializeAndGetReadLatencyForTable(td.getTableName().getNameAsString());
                taskFutures.addAll(Canary.sniff(this.admin, this.sink, td, this.executor, taskType, this.rawScanEnabled, readLatency));
            }
            return taskFutures;
        }

        private void checkWriteTableDistribution() throws IOException {
            List pairs;
            int numberOfRegions;
            if (!this.admin.tableExists(this.writeTableName)) {
                int numberOfServers = this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().size();
                if (numberOfServers == 0) {
                    throw new IllegalStateException("No live regionservers");
                }
                this.createWriteTable(numberOfServers);
            }
            if (!this.admin.isTableEnabled(this.writeTableName)) {
                this.admin.enableTable(this.writeTableName);
            }
            ClusterMetrics status = this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS, ClusterMetrics.Option.MASTER));
            int numberOfServers = status.getLiveServerMetrics().size();
            if (status.getLiveServerMetrics().containsKey(status.getMasterName())) {
                --numberOfServers;
            }
            if ((float)(numberOfRegions = (pairs = MetaTableAccessor.getTableRegionsAndLocations((Connection)this.connection, (TableName)this.writeTableName)).size()) < (float)numberOfServers * this.regionsLowerLimit || (float)numberOfRegions > (float)numberOfServers * this.regionsUpperLimit) {
                this.admin.disableTable(this.writeTableName);
                this.admin.deleteTable(this.writeTableName);
                this.createWriteTable(numberOfServers);
            }
            HashSet<Object> serverSet = new HashSet<Object>();
            for (Pair pair : pairs) {
                serverSet.add(pair.getSecond());
            }
            int numberOfCoveredServers = serverSet.size();
            if (numberOfCoveredServers < numberOfServers) {
                this.admin.balancer();
            }
        }

        private void createWriteTable(int numberOfServers) throws IOException {
            int numberOfRegions = (int)((float)numberOfServers * this.regionsLowerLimit);
            LOG.info("Number of live regionservers {}, pre-splitting the canary table into {} regions (current lower limit of regions per server is {} and you can change it with config {}).", new Object[]{numberOfServers, numberOfRegions, Float.valueOf(this.regionsLowerLimit), "hbase.canary.write.perserver.regions.lowerLimit"});
            HTableDescriptor desc = new HTableDescriptor(this.writeTableName);
            HColumnDescriptor family = new HColumnDescriptor(Canary.CANARY_TABLE_FAMILY_NAME);
            family.setMaxVersions(1);
            family.setTimeToLive(this.writeDataTTL);
            desc.addFamily(family);
            byte[][] splits = new RegionSplitter.HexStringSplit().split(numberOfRegions);
            this.admin.createTable((TableDescriptor)desc, splits);
        }
    }

    public static abstract class Monitor
    implements Runnable,
    Closeable {
        protected Connection connection;
        protected Admin admin;
        protected String[] targets;
        protected boolean useRegExp;
        protected boolean treatFailureAsError;
        protected boolean initialized = false;
        protected boolean done = false;
        protected int errorCode = 0;
        protected long allowedFailures = 0L;
        protected Sink sink;
        protected ExecutorService executor;

        public boolean isDone() {
            return this.done;
        }

        public boolean hasError() {
            return this.errorCode != 0;
        }

        public boolean finalCheckForErrors() {
            if (this.errorCode != 0) {
                return true;
            }
            if (this.treatFailureAsError && (this.sink.getReadFailureCount() > this.allowedFailures || this.sink.getWriteFailureCount() > this.allowedFailures)) {
                LOG.error("Too many failures detected, treating failure as error, failing the Canary.");
                this.errorCode = 5;
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            if (this.admin != null) {
                this.admin.close();
            }
        }

        protected Monitor(Connection connection, String[] monitorTargets, boolean useRegExp, Sink sink, ExecutorService executor, boolean treatFailureAsError, long allowedFailures) {
            if (null == connection) {
                throw new IllegalArgumentException("connection shall not be null");
            }
            this.connection = connection;
            this.targets = monitorTargets;
            this.useRegExp = useRegExp;
            this.treatFailureAsError = treatFailureAsError;
            this.sink = sink;
            this.executor = executor;
            this.allowedFailures = allowedFailures;
        }

        @Override
        public abstract void run();

        protected boolean initAdmin() {
            if (null == this.admin) {
                try {
                    this.admin = this.connection.getAdmin();
                }
                catch (Exception e) {
                    LOG.error("Initial HBaseAdmin failed...", (Throwable)e);
                    this.errorCode = 2;
                }
            } else if (this.admin.isAborted()) {
                LOG.error("HBaseAdmin aborted");
                this.errorCode = 2;
            }
            return !this.hasError();
        }
    }

    static class RegionServerTask
    implements Callable<Void> {
        private Connection connection;
        private String serverName;
        private RegionInfo region;
        private RegionServerStdOutSink sink;
        private AtomicLong successes;

        RegionServerTask(Connection connection, String serverName, RegionInfo region, RegionServerStdOutSink sink, AtomicLong successes) {
            this.connection = connection;
            this.serverName = serverName;
            this.region = region;
            this.sink = sink;
            this.successes = successes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            TableName tableName = null;
            Table table = null;
            Get get = null;
            byte[] startKey = null;
            Scan scan = null;
            StopWatch stopWatch = new StopWatch();
            stopWatch.reset();
            try {
                tableName = this.region.getTable();
                table = this.connection.getTable(tableName);
                startKey = this.region.getStartKey();
                LOG.debug("Reading from {} {} {} {}", new Object[]{this.serverName, this.region.getTable(), this.region.getRegionNameAsString(), Bytes.toStringBinary((byte[])startKey)});
                if (startKey.length > 0) {
                    get = new Get(startKey);
                    get.setCacheBlocks(false);
                    get.setFilter((Filter)new FirstKeyOnlyFilter());
                    stopWatch.start();
                    table.get(get);
                    stopWatch.stop();
                } else {
                    scan = new Scan();
                    scan.setCacheBlocks(false);
                    scan.setFilter((Filter)new FirstKeyOnlyFilter());
                    scan.setCaching(1);
                    scan.setMaxResultSize(1L);
                    scan.setOneRowLimit();
                    stopWatch.start();
                    ResultScanner s = table.getScanner(scan);
                    s.next();
                    s.close();
                    stopWatch.stop();
                }
                this.successes.incrementAndGet();
                this.sink.publishReadTiming(tableName.getNameAsString(), this.serverName, stopWatch.getTime());
            }
            catch (TableNotFoundException tnfe) {
                LOG.error("Table may be deleted", (Throwable)tnfe);
            }
            catch (TableNotEnabledException tnee) {
                this.successes.incrementAndGet();
                LOG.debug("The targeted table was disabled.  Assuming success.");
            }
            catch (DoNotRetryIOException dnrioe) {
                this.sink.publishReadFailure(tableName.getNameAsString(), this.serverName);
                LOG.error(dnrioe.toString(), (Throwable)dnrioe);
            }
            catch (IOException e) {
                this.sink.publishReadFailure(tableName.getNameAsString(), this.serverName);
                LOG.error(e.toString(), (Throwable)e);
            }
            finally {
                if (table != null) {
                    try {
                        table.close();
                    }
                    catch (IOException e) {
                        LOG.error("Close table failed", (Throwable)e);
                    }
                }
                scan = null;
                get = null;
                startKey = null;
            }
            return null;
        }
    }

    static class RegionTask
    implements Callable<Void> {
        private Connection connection;
        private RegionInfo region;
        private RegionStdOutSink sink;
        private TaskType taskType;
        private boolean rawScanEnabled;
        private ServerName serverName;
        private LongAdder readWriteLatency;

        RegionTask(Connection connection, RegionInfo region, ServerName serverName, RegionStdOutSink sink, TaskType taskType, boolean rawScanEnabled, LongAdder rwLatency) {
            this.connection = connection;
            this.region = region;
            this.serverName = serverName;
            this.sink = sink;
            this.taskType = taskType;
            this.rawScanEnabled = rawScanEnabled;
            this.readWriteLatency = rwLatency;
        }

        @Override
        public Void call() {
            switch (this.taskType) {
                case READ: {
                    return this.read();
                }
                case WRITE: {
                    return this.write();
                }
            }
            return this.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void read() {
            Table table = null;
            TableDescriptor tableDesc = null;
            try {
                LOG.debug("Reading table descriptor for table {}", (Object)this.region.getTable());
                table = this.connection.getTable(this.region.getTable());
                tableDesc = table.getDescriptor();
            }
            catch (IOException e) {
                LOG.debug("sniffRegion {} of {} failed", (Object)this.region.getEncodedName(), (Object)e);
                this.sink.publishReadFailure(this.serverName, this.region, e);
                if (table != null) {
                    try {
                        table.close();
                    }
                    catch (IOException ioe) {
                        LOG.error("Close table failed", (Throwable)e);
                    }
                }
                return null;
            }
            byte[] startKey = null;
            Get get = null;
            Scan scan = null;
            ResultScanner rs = null;
            StopWatch stopWatch = new StopWatch();
            for (ColumnFamilyDescriptor column : tableDesc.getColumnFamilies()) {
                stopWatch.reset();
                startKey = this.region.getStartKey();
                if (startKey.length > 0) {
                    get = new Get(startKey);
                    get.setCacheBlocks(false);
                    get.setFilter((Filter)new FirstKeyOnlyFilter());
                    get.addFamily(column.getName());
                } else {
                    scan = new Scan();
                    LOG.debug("rawScan {} for {}", (Object)this.rawScanEnabled, (Object)tableDesc.getTableName());
                    scan.setRaw(this.rawScanEnabled);
                    scan.setCaching(1);
                    scan.setCacheBlocks(false);
                    scan.setFilter((Filter)new FirstKeyOnlyFilter());
                    scan.addFamily(column.getName());
                    scan.setMaxResultSize(1L);
                    scan.setOneRowLimit();
                }
                LOG.debug("Reading from {} {} {} {}", new Object[]{tableDesc.getTableName(), this.region.getRegionNameAsString(), column.getNameAsString(), Bytes.toStringBinary((byte[])startKey)});
                try {
                    stopWatch.start();
                    if (startKey.length > 0) {
                        table.get(get);
                    } else {
                        rs = table.getScanner(scan);
                        rs.next();
                    }
                    stopWatch.stop();
                    this.readWriteLatency.add(stopWatch.getTime());
                    this.sink.publishReadTiming(this.serverName, this.region, column, stopWatch.getTime());
                }
                catch (Exception e) {
                    this.sink.publishReadFailure(this.serverName, this.region, column, e);
                    this.sink.updateReadFailures(this.region.getRegionNameAsString(), this.serverName.getHostname());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    scan = null;
                    get = null;
                }
            }
            try {
                table.close();
            }
            catch (IOException e) {
                LOG.error("Close table failed", (Throwable)e);
            }
            return null;
        }

        private Void write() {
            Table table = null;
            TableDescriptor tableDesc = null;
            try {
                table = this.connection.getTable(this.region.getTable());
                tableDesc = table.getDescriptor();
                byte[] rowToCheck = this.region.getStartKey();
                if (rowToCheck.length == 0) {
                    rowToCheck = new byte[]{0};
                }
                int writeValueSize = this.connection.getConfiguration().getInt("hbase.canary.write.value.size", 10);
                for (ColumnFamilyDescriptor column : tableDesc.getColumnFamilies()) {
                    Put put = new Put(rowToCheck);
                    byte[] value = new byte[writeValueSize];
                    Bytes.random((byte[])value);
                    put.addColumn(column.getName(), HConstants.EMPTY_BYTE_ARRAY, value);
                    LOG.debug("Writing to {} {} {} {}", new Object[]{tableDesc.getTableName(), this.region.getRegionNameAsString(), column.getNameAsString(), Bytes.toStringBinary((byte[])rowToCheck)});
                    try {
                        long startTime = System.currentTimeMillis();
                        table.put(put);
                        long time = System.currentTimeMillis() - startTime;
                        this.readWriteLatency.add(time);
                        this.sink.publishWriteTiming(this.serverName, this.region, column, time);
                    }
                    catch (Exception e) {
                        this.sink.publishWriteFailure(this.serverName, this.region, column, e);
                    }
                }
                table.close();
            }
            catch (IOException e) {
                this.sink.publishWriteFailure(this.serverName, this.region, e);
                this.sink.updateWriteFailures(this.region.getRegionNameAsString(), this.serverName.getHostname());
            }
            return null;
        }

        public static enum TaskType {
            READ,
            WRITE;

        }
    }

    static class ZookeeperTask
    implements Callable<Void> {
        private final Connection connection;
        private final String host;
        private String znode;
        private final int timeout;
        private ZookeeperStdOutSink sink;

        public ZookeeperTask(Connection connection, String host, String znode, int timeout, ZookeeperStdOutSink sink) {
            this.connection = connection;
            this.host = host;
            this.znode = znode;
            this.timeout = timeout;
            this.sink = sink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try (ZooKeeper zooKeeper = null;){
                zooKeeper = new ZooKeeper(this.host, this.timeout, (Watcher)EmptyWatcher.instance);
                Stat exists = zooKeeper.exists(this.znode, false);
                StopWatch stopwatch = new StopWatch();
                stopwatch.start();
                zooKeeper.getData(this.znode, false, exists);
                stopwatch.stop();
                this.sink.publishReadTiming(this.znode, this.host, stopwatch.getTime());
            }
            return null;
        }
    }

    public static class RegionStdOutSink
    extends StdOutSink {
        private Map<String, LongAdder> perTableReadLatency = new HashMap<String, LongAdder>();
        private LongAdder writeLatency = new LongAdder();

        public void publishReadFailure(ServerName serverName, RegionInfo region, Exception e) {
            this.incReadFailureCount();
            LOG.error("Read from {} on {} failed", new Object[]{region.getRegionNameAsString(), serverName, e});
        }

        public void publishReadFailure(ServerName serverName, RegionInfo region, ColumnFamilyDescriptor column, Exception e) {
            this.incReadFailureCount();
            LOG.error("Read from {} on {} {} failed", new Object[]{region.getRegionNameAsString(), serverName, column.getNameAsString(), e});
        }

        public void publishReadTiming(ServerName serverName, RegionInfo region, ColumnFamilyDescriptor column, long msTime) {
            LOG.info("Read from {} on {} {} in {}ms", new Object[]{region.getRegionNameAsString(), serverName, column.getNameAsString(), msTime});
        }

        public void publishWriteFailure(ServerName serverName, RegionInfo region, Exception e) {
            this.incWriteFailureCount();
            LOG.error("Write to {} on {} failed", new Object[]{region.getRegionNameAsString(), serverName, e});
        }

        public void publishWriteFailure(ServerName serverName, RegionInfo region, ColumnFamilyDescriptor column, Exception e) {
            this.incWriteFailureCount();
            LOG.error("Write to {} on {} {} failed", new Object[]{region.getRegionNameAsString(), serverName, column.getNameAsString(), e});
        }

        public void publishWriteTiming(ServerName serverName, RegionInfo region, ColumnFamilyDescriptor column, long msTime) {
            LOG.info("Write to {} on {} {} in {}ms", new Object[]{region.getRegionNameAsString(), serverName, column.getNameAsString(), msTime});
        }

        public Map<String, LongAdder> getReadLatencyMap() {
            return this.perTableReadLatency;
        }

        public LongAdder initializeAndGetReadLatencyForTable(String tableName) {
            LongAdder initLatency = new LongAdder();
            this.perTableReadLatency.put(tableName, initLatency);
            return initLatency;
        }

        public void initializeWriteLatency() {
            this.writeLatency.reset();
        }

        public LongAdder getWriteLatency() {
            return this.writeLatency;
        }
    }

    public static class ZookeeperStdOutSink
    extends StdOutSink {
        public void publishReadFailure(String znode, String server) {
            this.incReadFailureCount();
            LOG.error("Read from {} on {}", (Object)znode, (Object)server);
        }

        public void publishReadTiming(String znode, String server, long msTime) {
            LOG.info("Read from {} on {} in {}ms", new Object[]{znode, server, msTime});
        }
    }

    public static class RegionServerStdOutSink
    extends StdOutSink {
        public void publishReadFailure(String table, String server) {
            this.incReadFailureCount();
            LOG.error("Read from {} on {}", (Object)table, (Object)server);
        }

        public void publishReadTiming(String table, String server, long msTime) {
            LOG.info("Read from {} on {} in {}ms", new Object[]{table, server, msTime});
        }
    }

    public static class StdOutSink
    implements Sink {
        private AtomicLong readFailureCount = new AtomicLong(0L);
        private AtomicLong writeFailureCount = new AtomicLong(0L);
        private Map<String, String> readFailures = new ConcurrentHashMap<String, String>();
        private Map<String, String> writeFailures = new ConcurrentHashMap<String, String>();

        @Override
        public long getReadFailureCount() {
            return this.readFailureCount.get();
        }

        @Override
        public long incReadFailureCount() {
            return this.readFailureCount.incrementAndGet();
        }

        @Override
        public Map<String, String> getReadFailures() {
            return this.readFailures;
        }

        @Override
        public void updateReadFailures(String regionName, String serverName) {
            this.readFailures.put(regionName, serverName);
        }

        @Override
        public long getWriteFailureCount() {
            return this.writeFailureCount.get();
        }

        @Override
        public long incWriteFailureCount() {
            return this.writeFailureCount.incrementAndGet();
        }

        @Override
        public Map<String, String> getWriteFailures() {
            return this.writeFailures;
        }

        @Override
        public void updateWriteFailures(String regionName, String serverName) {
            this.writeFailures.put(regionName, serverName);
        }
    }

    public static interface Sink {
        public long getReadFailureCount();

        public long incReadFailureCount();

        public Map<String, String> getReadFailures();

        public void updateReadFailures(String var1, String var2);

        public long getWriteFailureCount();

        public long incWriteFailureCount();

        public Map<String, String> getWriteFailures();

        public void updateWriteFailures(String var1, String var2);
    }
}

