/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, SmallTests.class})
public class TestFSTableDescriptorForceCreation {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSTableDescriptorForceCreation.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @Test
    public void testShouldCreateNewTableDescriptorIfForcefulCreationIsFalse() throws IOException {
        String name = this.name.getMethodName();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), name);
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        Assert.assertTrue((String)"Should create new table descriptor", (boolean)fstd.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)name)).build(), false));
    }

    @Test
    public void testShouldNotCreateTheSameTableDescriptorIfForcefulCreationIsFalse() throws IOException {
        String name = this.name.getMethodName();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), name);
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)name)).build();
        fstd.add(htd);
        Assert.assertFalse((String)"Should not create new table descriptor", (boolean)fstd.createTableDescriptor(htd, false));
    }

    @Test
    public void testShouldAllowForcefulCreationOfAlreadyExistingTableDescriptor() throws Exception {
        String name = this.name.getMethodName();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), name);
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)name)).build();
        fstd.createTableDescriptor(htd, false);
        Assert.assertTrue((String)"Should create new table descriptor", (boolean)fstd.createTableDescriptor(htd, true));
    }
}

