/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasMasterServices;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.MockMasterServices;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={CoprocessorTests.class, SmallTests.class})
public class TestCoreMasterCoprocessor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoreMasterCoprocessor.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility HTU = HBaseTestingUtility.createLocalHTU();
    private MasterServices ms;
    private MasterCoprocessorHost mch;

    @Before
    public void before() throws IOException {
        String methodName = this.name.getMethodName();
        this.ms = new MockMasterServices(HTU.getConfiguration(), null);
        this.mch = new MasterCoprocessorHost(this.ms, HTU.getConfiguration());
        this.mch.preMasterInitialization();
    }

    @After
    public void after() throws IOException {
        this.mch.preStopMaster();
    }

    @Test
    public void testCoreRegionCoprocessor() throws IOException {
        MasterCoprocessorEnvironment env = (MasterCoprocessorEnvironment)this.mch.load(null, NotCoreMasterCoprocessor.class.getName(), 0, HTU.getConfiguration());
        Assert.assertFalse((boolean)(env instanceof HasMasterServices));
        env = (MasterCoprocessorEnvironment)this.mch.load(null, CoreMasterCoprocessor.class.getName(), 1, HTU.getConfiguration());
        Assert.assertTrue((boolean)(env instanceof HasMasterServices));
        Assert.assertEquals((Object)this.ms, (Object)((HasMasterServices)env).getMasterServices());
    }

    @CoreCoprocessor
    public static class CoreMasterCoprocessor
    implements MasterCoprocessor {
    }

    public static class NotCoreMasterCoprocessor
    implements MasterCoprocessor {
    }
}

