/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestDeadServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDeadServer.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    final ServerName hostname123 = ServerName.valueOf((String)"127.0.0.1", (int)123, (long)3L);
    final ServerName hostname123_2 = ServerName.valueOf((String)"127.0.0.1", (int)123, (long)4L);
    final ServerName hostname1234 = ServerName.valueOf((String)"127.0.0.2", (int)1234, (long)4L);
    final ServerName hostname12345 = ServerName.valueOf((String)"127.0.0.2", (int)12345, (long)4L);

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testIsDead() {
        DeadServer ds = new DeadServer();
        ds.add(this.hostname123);
        ds.notifyServer(this.hostname123);
        Assert.assertTrue((boolean)ds.areDeadServersInProgress());
        ds.finish(this.hostname123);
        Assert.assertFalse((boolean)ds.areDeadServersInProgress());
        ds.add(this.hostname1234);
        ds.notifyServer(this.hostname1234);
        Assert.assertTrue((boolean)ds.areDeadServersInProgress());
        ds.finish(this.hostname1234);
        Assert.assertFalse((boolean)ds.areDeadServersInProgress());
        ds.add(this.hostname12345);
        ds.notifyServer(this.hostname12345);
        Assert.assertTrue((boolean)ds.areDeadServersInProgress());
        ds.finish(this.hostname12345);
        Assert.assertFalse((boolean)ds.areDeadServersInProgress());
        ServerName deadServer = ServerName.valueOf((String)"127.0.0.1", (int)9090, (long)112321L);
        Assert.assertFalse((boolean)ds.cleanPreviousInstance(deadServer));
        ds.add(deadServer);
        Assert.assertTrue((boolean)ds.isDeadServer(deadServer));
        Set deadServerNames = ds.copyServerNames();
        for (ServerName eachDeadServer : deadServerNames) {
            Assert.assertNotNull((Object)ds.getTimeOfDeath(eachDeadServer));
        }
        ServerName deadServerHostComingAlive = ServerName.valueOf((String)"127.0.0.1", (int)9090, (long)223341L);
        Assert.assertTrue((boolean)ds.cleanPreviousInstance(deadServerHostComingAlive));
        Assert.assertFalse((boolean)ds.isDeadServer(deadServer));
        Assert.assertFalse((boolean)ds.cleanPreviousInstance(deadServerHostComingAlive));
    }

    @Test
    public void testCrashProcedureReplay() {
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        ProcedureExecutor pExecutor = master.getMasterProcedureExecutor();
        ServerCrashProcedure proc = new ServerCrashProcedure((MasterProcedureEnv)pExecutor.getEnvironment(), this.hostname123, false, false);
        ProcedureTestingUtility.submitAndWait((ProcedureExecutor)pExecutor, (Procedure)proc);
        Assert.assertFalse((boolean)master.getServerManager().getDeadServers().areDeadServersInProgress());
    }

    @Test
    public void testSortExtract() {
        ManualEnvironmentEdge mee = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)mee);
        mee.setValue(1L);
        DeadServer d = new DeadServer();
        d.add(this.hostname123);
        mee.incValue(1L);
        d.add(this.hostname1234);
        mee.incValue(1L);
        d.add(this.hostname12345);
        List copy = d.copyDeadServersSince(2L);
        Assert.assertEquals((long)2L, (long)copy.size());
        Assert.assertEquals((Object)this.hostname1234, (Object)((Pair)copy.get(0)).getFirst());
        Assert.assertEquals((Object)new Long(2L), (Object)((Pair)copy.get(0)).getSecond());
        Assert.assertEquals((Object)this.hostname12345, (Object)((Pair)copy.get(1)).getFirst());
        Assert.assertEquals((Object)new Long(3L), (Object)((Pair)copy.get(1)).getSecond());
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testClean() {
        DeadServer d = new DeadServer();
        d.add(this.hostname123);
        d.cleanPreviousInstance(this.hostname12345);
        Assert.assertFalse((boolean)d.isEmpty());
        d.cleanPreviousInstance(this.hostname1234);
        Assert.assertFalse((boolean)d.isEmpty());
        d.cleanPreviousInstance(this.hostname123_2);
        Assert.assertTrue((boolean)d.isEmpty());
    }

    @Test
    public void testClearDeadServer() {
        DeadServer d = new DeadServer();
        d.add(this.hostname123);
        d.add(this.hostname1234);
        Assert.assertEquals((long)2L, (long)d.size());
        d.finish(this.hostname123);
        d.removeDeadServer(this.hostname123);
        Assert.assertEquals((long)1L, (long)d.size());
        d.finish(this.hostname1234);
        d.removeDeadServer(this.hostname1234);
        Assert.assertTrue((boolean)d.isEmpty());
        d.add(this.hostname1234);
        Assert.assertFalse((boolean)d.removeDeadServer(this.hostname123_2));
        Assert.assertEquals((long)1L, (long)d.size());
        d.finish(this.hostname1234);
        Assert.assertTrue((boolean)d.removeDeadServer(this.hostname1234));
        Assert.assertTrue((boolean)d.isEmpty());
    }
}

