/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestLogRolling;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestLogRollAbort {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLogRollAbort.class);
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestLogRolling.class);
    private static MiniDFSCluster dfsCluster;
    private static Admin admin;
    private static MiniHBaseCluster cluster;
    protected static final HBaseTestingUtility TEST_UTIL;
    private static final Path HBASEDIR;
    private static final Path HBASELOGDIR;
    private static final Path OLDLOGDIR;
    private Configuration conf;
    private FileSystem fs;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.logroll.errors.tolerated", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 10000);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 5000L);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.write.retries", 10);
        TEST_UTIL.getConfiguration().set("hbase.wal.provider", "filesystem");
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        cluster = TEST_UTIL.getHBaseCluster();
        dfsCluster = TEST_UTIL.getDFSCluster();
        admin = TEST_UTIL.getAdmin();
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        cluster.getMaster().balanceSwitch(false);
        FSUtils.setRootDir((Configuration)this.conf, (Path)HBASEDIR);
        FSUtils.setWALRootDir((Configuration)this.conf, (Path)HBASELOGDIR);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRSAbortWithUnflushedEdits() throws Exception {
        LOG.info("Starting testRSAbortWithUnflushedEdits()");
        TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME).close();
        TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HConstants.CATALOG_FAMILY)).build();
        admin.createTable(desc);
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            HRegionServer server = TEST_UTIL.getRSForFirstRegionInTable(tableName);
            WAL log = server.getWAL(null);
            Put p = new Put(Bytes.toBytes((String)"row2001"));
            p.addColumn(HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"col"), Bytes.toBytes((int)2001));
            table.put(p);
            log.sync();
            p = new Put(Bytes.toBytes((String)"row2002"));
            p.addColumn(HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"col"), Bytes.toBytes((int)2002));
            table.put(p);
            dfsCluster.restartDataNodes();
            LOG.info("Restarted datanodes");
            try {
                log.rollWriter(true);
            }
            catch (FailedLogCloseException failedLogCloseException) {
            }
            catch (Throwable t) {
                LOG.error(HBaseMarkers.FATAL, "FAILED TEST: Got wrong exception", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogRollAfterSplitStart() throws IOException {
        block9: {
            LOG.info("Verify wal roll after split starts will fail.");
            String logName = ServerName.valueOf((String)"testLogRollAfterSplitStart", (int)16010, (long)System.currentTimeMillis()).toString();
            Path thisTestsDir = new Path(HBASELOGDIR, AbstractFSWALProvider.getWALDirectoryName((String)logName));
            WALFactory wals = new WALFactory(this.conf, logName);
            try {
                TableName tableName = TableName.valueOf((String)this.getClass().getName());
                RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
                WAL log = wals.getWAL(regionInfo);
                MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl(1L);
                int total = 20;
                for (int i = 0; i < total; ++i) {
                    WALEdit kvs = new WALEdit();
                    kvs.add((Cell)new KeyValue(Bytes.toBytes((int)i), tableName.getName(), tableName.getName()));
                    TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
                    scopes.put(Bytes.toBytes((String)"column"), 0);
                    log.appendData(regionInfo, new WALKeyImpl(regionInfo.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), mvcc, scopes), kvs);
                }
                log.sync();
                ((AbstractFSWAL)log).replaceWriter(((FSHLog)log).getOldPath(), null, null);
                Path rsSplitDir = thisTestsDir.suffix("-splitting");
                if (!this.fs.rename(thisTestsDir, rsSplitDir)) {
                    throw new IOException("Failed fs.rename for log split: " + thisTestsDir);
                }
                LOG.debug("Renamed region directory: " + rsSplitDir);
                LOG.debug("Processing the old log files.");
                WALSplitter.split((Path)HBASELOGDIR, (Path)rsSplitDir, (Path)OLDLOGDIR, (FileSystem)this.fs, (Configuration)this.conf, (WALFactory)wals);
                LOG.debug("Trying to roll the WAL.");
                try {
                    log.rollWriter();
                    Assert.fail((String)"rollWriter() did not throw any exception.");
                }
                catch (IOException ioe) {
                    if (ioe.getCause() instanceof FileNotFoundException) {
                        LOG.info("Got the expected exception: ", ioe.getCause());
                        break block9;
                    }
                    Assert.fail((String)("Unexpected exception: " + ioe));
                }
            }
            finally {
                wals.close();
                if (this.fs.exists(thisTestsDir)) {
                    this.fs.delete(thisTestsDir, true);
                }
            }
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        HBASEDIR = new Path("/hbase");
        HBASELOGDIR = new Path("/hbaselog");
        OLDLOGDIR = new Path(HBASELOGDIR, "oldWALs");
    }
}

