/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestUsersOperationsWithSecureHadoop {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestUsersOperationsWithSecureHadoop.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final File KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
    private static MiniKdc KDC;
    private static String HOST;
    private static String PRINCIPAL;
    private static String CLIENT_NAME;

    @BeforeClass
    public static void setUp() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        PRINCIPAL = "hbase/" + HOST;
        CLIENT_NAME = "foo";
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL, CLIENT_NAME});
        HBaseKerberosUtils.setPrincipalForTesting(PRINCIPAL + "@" + KDC.getRealm());
        HBaseKerberosUtils.setKeytabFileForTesting(KEYTAB_FILE.getAbsolutePath());
        HBaseKerberosUtils.setClientPrincipalForTesting(CLIENT_NAME + "@" + KDC.getRealm());
        HBaseKerberosUtils.setClientKeytabForTesting(KEYTAB_FILE.getAbsolutePath());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (KDC != null) {
            KDC.stop();
        }
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testUserLoginInSecureHadoop() throws Exception {
        UserGroupInformation defaultLogin = UserGroupInformation.getCurrentUser();
        String nnKeyTab = HBaseKerberosUtils.getKeytabFileForTesting();
        String dnPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        Assert.assertNotNull((String)"KerberosKeytab was not specified", (Object)nnKeyTab);
        Assert.assertNotNull((String)"KerberosPrincipal was not specified", (Object)dnPrincipal);
        Configuration conf = HBaseKerberosUtils.getSecuredConfiguration();
        UserGroupInformation.setConfiguration((Configuration)conf);
        User.login((Configuration)conf, (String)"hbase.regionserver.keytab.file", (String)"hbase.regionserver.kerberos.principal", (String)"localhost");
        UserGroupInformation successLogin = UserGroupInformation.getLoginUser();
        Assert.assertFalse((String)"ugi should be different in in case success login", (boolean)defaultLogin.equals((Object)successLogin));
    }

    @Test
    public void testLoginWithUserKeytabAndPrincipal() throws Exception {
        String clientKeytab = HBaseKerberosUtils.getClientKeytabForTesting();
        String clientPrincipal = HBaseKerberosUtils.getClientPrincipalForTesting();
        Assert.assertNotNull((String)"Path for client keytab is not specified.", (Object)clientKeytab);
        Assert.assertNotNull((String)"Client principal is not specified.", (Object)clientPrincipal);
        Configuration conf = HBaseKerberosUtils.getSecuredConfiguration();
        conf.set("hbase.client.keytab.file", clientKeytab);
        conf.set("hbase.client.keytab.principal", clientPrincipal);
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserProvider provider = UserProvider.instantiate((Configuration)conf);
        Assert.assertTrue((String)"Client principal or keytab is empty", (boolean)provider.shouldLoginFromKeytab());
        provider.login("hbase.client.keytab.file", "hbase.client.keytab.principal");
        User loginUser = provider.getCurrent();
        Assert.assertEquals((Object)CLIENT_NAME, (Object)loginUser.getShortName());
        Assert.assertEquals((Object)HBaseKerberosUtils.getClientPrincipalForTesting(), (Object)loginUser.getName());
    }

    @Test
    public void testAuthUtilLogin() throws Exception {
        String clientKeytab = HBaseKerberosUtils.getClientKeytabForTesting();
        String clientPrincipal = HBaseKerberosUtils.getClientPrincipalForTesting();
        Configuration conf = HBaseKerberosUtils.getSecuredConfiguration();
        conf.set("hbase.client.keytab.file", clientKeytab);
        conf.set("hbase.client.keytab.principal", clientPrincipal);
        UserGroupInformation.setConfiguration((Configuration)conf);
        User user = AuthUtil.loginClient((Configuration)conf);
        Assert.assertTrue((boolean)user.isLoginFromKeytab());
        Assert.assertEquals((Object)CLIENT_NAME, (Object)user.getShortName());
        Assert.assertEquals((Object)HBaseKerberosUtils.getClientPrincipalForTesting(), (Object)user.getName());
    }

    static {
        HOST = "localhost";
    }
}

