/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MultiThreadedWriterBase;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadedUpdater
extends MultiThreadedWriterBase {
    private static final Logger LOG = LoggerFactory.getLogger(MultiThreadedUpdater.class);
    protected Set<HBaseUpdaterThread> updaters = new HashSet<HBaseUpdaterThread>();
    private MultiThreadedWriterBase writer = null;
    private boolean isBatchUpdate = false;
    private boolean ignoreNonceConflicts = false;
    private final double updatePercent;

    public MultiThreadedUpdater(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName, double updatePercent) throws IOException {
        super(dataGen, conf, tableName, "U");
        this.updatePercent = updatePercent;
    }

    public void setBatchUpdate(boolean isBatchUpdate) {
        this.isBatchUpdate = isBatchUpdate;
    }

    public void linkToWriter(MultiThreadedWriterBase writer) {
        this.writer = writer;
        writer.setTrackWroteKeys(true);
    }

    @Override
    public void start(long startKey, long endKey, int numThreads) throws IOException {
        super.start(startKey, endKey, numThreads);
        if (this.verbose) {
            LOG.debug("Updating keys [" + startKey + ", " + endKey + ")");
        }
        this.addUpdaterThreads(numThreads);
        this.startThreads(this.updaters);
    }

    protected void addUpdaterThreads(int numThreads) throws IOException {
        for (int i = 0; i < numThreads; ++i) {
            HBaseUpdaterThread updater = new HBaseUpdaterThread(i);
            this.updaters.add(updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextKeyToUpdate() {
        if (this.writer == null) {
            return this.nextKeyToWrite.getAndIncrement();
        }
        MultiThreadedUpdater multiThreadedUpdater = this;
        synchronized (multiThreadedUpdater) {
            if (this.nextKeyToWrite.get() >= this.endKey) {
                return this.endKey;
            }
            while (this.nextKeyToWrite.get() > this.writer.wroteUpToKey()) {
                Threads.sleepWithoutInterrupt((long)100L);
            }
            long k = this.nextKeyToWrite.getAndIncrement();
            if (this.writer.failedToWriteKey(k)) {
                this.failedKeySet.add(k);
                return this.getNextKeyToUpdate();
            }
            return k;
        }
    }

    @Override
    public void waitForFinish() {
        super.waitForFinish();
        System.out.println("Failed to update keys: " + this.failedKeySet.size());
        for (Long key : this.failedKeySet) {
            System.out.println("Failed to update key: " + key);
        }
    }

    public void mutate(Table table, Mutation m, long keyBase) {
        this.mutate(table, m, keyBase, null, null, null, null);
    }

    public void mutate(Table table, Mutation m, long keyBase, byte[] row, byte[] cf, byte[] q, byte[] v) {
        long start = System.currentTimeMillis();
        try {
            m = this.dataGenerator.beforeMutate(keyBase, m);
            if (m instanceof Increment) {
                table.increment((Increment)m);
            } else if (m instanceof Append) {
                table.append((Append)m);
            } else if (m instanceof Put) {
                table.checkAndMutate(row, cf).qualifier(q).ifEquals(v).thenPut((Put)m);
            } else if (m instanceof Delete) {
                table.checkAndMutate(row, cf).qualifier(q).ifEquals(v).thenDelete((Delete)m);
            } else {
                throw new IllegalArgumentException("unsupported mutation " + m.getClass().getSimpleName());
            }
            this.totalOpTimeMs.addAndGet(System.currentTimeMillis() - start);
        }
        catch (IOException e) {
            String exceptionInfo;
            this.failedKeySet.add(keyBase);
            if (e instanceof RetriesExhaustedWithDetailsException) {
                RetriesExhaustedWithDetailsException aggEx = (RetriesExhaustedWithDetailsException)((Object)e);
                exceptionInfo = aggEx.getExhaustiveDescription();
            } else {
                StringWriter stackWriter = new StringWriter();
                PrintWriter pw = new PrintWriter(stackWriter);
                e.printStackTrace(pw);
                pw.flush();
                exceptionInfo = StringUtils.stringifyException((Throwable)e);
            }
            LOG.error("Failed to mutate: " + keyBase + " after " + (System.currentTimeMillis() - start) + "ms; region information: " + this.getRegionDebugInfoSafe(table, m.getRow()) + "; errors: " + exceptionInfo);
        }
    }

    public void setIgnoreNonceConflicts(boolean value) {
        this.ignoreNonceConflicts = value;
    }

    protected class HBaseUpdaterThread
    extends Thread {
        protected final Table table;

        public HBaseUpdaterThread(int updaterId) throws IOException {
            this.setName(this.getClass().getSimpleName() + "_" + updaterId);
            this.table = this.createTable();
        }

        protected Table createTable() throws IOException {
            return MultiThreadedUpdater.this.connection.getTable(MultiThreadedUpdater.this.tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long rowKeyBase;
                StringBuilder buf = new StringBuilder();
                byte[][] columnFamilies = MultiThreadedUpdater.this.dataGenerator.getColumnFamilies();
                while ((rowKeyBase = MultiThreadedUpdater.this.getNextKeyToUpdate()) < MultiThreadedUpdater.this.endKey) {
                    if ((double)RandomUtils.nextInt((int)0, (int)100) < MultiThreadedUpdater.this.updatePercent) {
                        byte[] rowKey = MultiThreadedUpdater.this.dataGenerator.getDeterministicUniqueKey(rowKeyBase);
                        Increment inc = new Increment(rowKey);
                        Append app = new Append(rowKey);
                        MultiThreadedUpdater.this.numKeys.addAndGet(1L);
                        int columnCount = 0;
                        for (byte[] cf : columnFamilies) {
                            NavigableMap columnValues;
                            long cfHash = Arrays.hashCode(cf);
                            inc.addColumn(cf, LoadTestDataGenerator.INCREMENT, cfHash);
                            buf.setLength(0);
                            buf.append("#").append(Bytes.toString((byte[])LoadTestDataGenerator.INCREMENT));
                            buf.append(":").append(ClientProtos.MutationProto.MutationType.INCREMENT.getNumber());
                            app.addColumn(cf, LoadTestDataGenerator.MUTATE_INFO, Bytes.toBytes((String)buf.toString()));
                            ++columnCount;
                            if (!MultiThreadedUpdater.this.isBatchUpdate) {
                                this.mutate(this.table, (Mutation)inc, rowKeyBase);
                                MultiThreadedUpdater.this.numCols.addAndGet(1L);
                                inc = new Increment(rowKey);
                                this.mutate(this.table, (Mutation)app, rowKeyBase);
                                MultiThreadedUpdater.this.numCols.addAndGet(1L);
                                app = new Append(rowKey);
                            }
                            Get get = new Get(rowKey);
                            get.addFamily(cf);
                            try {
                                get = MultiThreadedUpdater.this.dataGenerator.beforeGet(rowKeyBase, get);
                            }
                            catch (Exception e) {
                                LOG.warn("Failed to modify the get from the load generator  = [" + Bytes.toString((byte[])get.getRow()) + "], column family = [" + Bytes.toString((byte[])cf) + "]", (Throwable)e);
                            }
                            Result result = this.getRow(get, rowKeyBase, cf);
                            NavigableMap navigableMap = columnValues = result != null ? result.getFamilyMap(cf) : null;
                            if (columnValues == null) {
                                int specialPermCellInsertionFactor = Integer.parseInt(MultiThreadedUpdater.this.dataGenerator.getArgs()[2]);
                                if ((int)rowKeyBase % specialPermCellInsertionFactor == 0) {
                                    LOG.info("Null result expected for the rowkey " + Bytes.toString((byte[])rowKey));
                                } else {
                                    MultiThreadedUpdater.this.failedKeySet.add(rowKeyBase);
                                    LOG.error("Failed to update the row with key = [" + Bytes.toString((byte[])rowKey) + "], since we could not get the original row");
                                }
                            }
                            if (columnValues == null) continue;
                            for (byte[] column : columnValues.keySet()) {
                                if (Bytes.equals((byte[])column, (byte[])LoadTestDataGenerator.INCREMENT) || Bytes.equals((byte[])column, (byte[])LoadTestDataGenerator.MUTATE_INFO)) continue;
                                ClientProtos.MutationProto.MutationType mt = ClientProtos.MutationProto.MutationType.valueOf((int)RandomUtils.nextInt((int)0, (int)ClientProtos.MutationProto.MutationType.values().length));
                                long columnHash = Arrays.hashCode(column);
                                long hashCode = cfHash + columnHash;
                                byte[] hashCodeBytes = Bytes.toBytes((long)hashCode);
                                byte[] checkedValue = HConstants.EMPTY_BYTE_ARRAY;
                                if (hashCode % 2L == 0L) {
                                    Cell kv = result.getColumnLatestCell(cf, column);
                                    checkedValue = kv != null ? CellUtil.cloneValue((Cell)kv) : null;
                                    Preconditions.checkNotNull((Object)checkedValue, (Object)"Column value to be checked should not be null");
                                }
                                buf.setLength(0);
                                buf.append("#").append(Bytes.toString((byte[])column)).append(":");
                                ++columnCount;
                                switch (mt) {
                                    case PUT: {
                                        Put put = new Put(rowKey);
                                        put.addColumn(cf, column, hashCodeBytes);
                                        this.mutate(this.table, (Mutation)put, rowKeyBase, rowKey, cf, column, checkedValue);
                                        buf.append(ClientProtos.MutationProto.MutationType.PUT.getNumber());
                                        break;
                                    }
                                    case DELETE: {
                                        Delete delete = new Delete(rowKey);
                                        delete.addColumns(cf, column);
                                        this.mutate(this.table, (Mutation)delete, rowKeyBase, rowKey, cf, column, checkedValue);
                                        buf.append(ClientProtos.MutationProto.MutationType.DELETE.getNumber());
                                        break;
                                    }
                                    default: {
                                        buf.append(ClientProtos.MutationProto.MutationType.APPEND.getNumber());
                                        app.addColumn(cf, column, hashCodeBytes);
                                    }
                                }
                                app.addColumn(cf, LoadTestDataGenerator.MUTATE_INFO, Bytes.toBytes((String)buf.toString()));
                                if (MultiThreadedUpdater.this.isBatchUpdate) continue;
                                this.mutate(this.table, (Mutation)app, rowKeyBase);
                                MultiThreadedUpdater.this.numCols.addAndGet(1L);
                                app = new Append(rowKey);
                            }
                        }
                        if (MultiThreadedUpdater.this.isBatchUpdate) {
                            if (MultiThreadedUpdater.this.verbose) {
                                LOG.debug("Preparing increment and append for key = [" + Bytes.toString((byte[])rowKey) + "], " + columnCount + " columns");
                            }
                            this.mutate(this.table, (Mutation)inc, rowKeyBase);
                            this.mutate(this.table, (Mutation)app, rowKeyBase);
                            MultiThreadedUpdater.this.numCols.addAndGet(columnCount);
                        }
                    }
                    if (!MultiThreadedUpdater.this.trackWroteKeys) continue;
                    MultiThreadedUpdater.this.wroteKeys.add(rowKeyBase);
                }
            }
            finally {
                this.closeHTable();
                MultiThreadedUpdater.this.numThreadsWorking.decrementAndGet();
            }
        }

        protected void closeHTable() {
            try {
                if (this.table != null) {
                    this.table.close();
                }
            }
            catch (IOException e) {
                LOG.error("Error closing table", (Throwable)e);
            }
        }

        protected Result getRow(Get get, long rowKeyBase, byte[] cf) {
            Result result = null;
            try {
                result = this.table.get(get);
            }
            catch (IOException ie) {
                LOG.warn("Failed to get the row for key = [" + Bytes.toString((byte[])get.getRow()) + "], column family = [" + Bytes.toString((byte[])cf) + "]", (Throwable)ie);
            }
            return result;
        }

        public void mutate(Table table, Mutation m, long keyBase) {
            this.mutate(table, m, keyBase, null, null, null, null);
        }

        public void mutate(Table table, Mutation m, long keyBase, byte[] row, byte[] cf, byte[] q, byte[] v) {
            long start = System.currentTimeMillis();
            try {
                m = MultiThreadedUpdater.this.dataGenerator.beforeMutate(keyBase, m);
                if (m instanceof Increment) {
                    table.increment((Increment)m);
                } else if (m instanceof Append) {
                    table.append((Append)m);
                } else if (m instanceof Put) {
                    table.checkAndMutate(row, cf).qualifier(q).ifEquals(v).thenPut((Put)m);
                } else if (m instanceof Delete) {
                    table.checkAndMutate(row, cf).qualifier(q).ifEquals(v).thenDelete((Delete)m);
                } else {
                    throw new IllegalArgumentException("unsupported mutation " + m.getClass().getSimpleName());
                }
                MultiThreadedUpdater.this.totalOpTimeMs.addAndGet(System.currentTimeMillis() - start);
            }
            catch (IOException e) {
                String exceptionInfo;
                if (MultiThreadedUpdater.this.ignoreNonceConflicts) {
                    LOG.info("Detected nonce conflict, ignoring: " + e.getMessage());
                    MultiThreadedUpdater.this.totalOpTimeMs.addAndGet(System.currentTimeMillis() - start);
                    return;
                }
                MultiThreadedUpdater.this.failedKeySet.add(keyBase);
                if (e instanceof RetriesExhaustedWithDetailsException) {
                    RetriesExhaustedWithDetailsException aggEx = (RetriesExhaustedWithDetailsException)((Object)e);
                    exceptionInfo = aggEx.getExhaustiveDescription();
                } else {
                    exceptionInfo = StringUtils.stringifyException((Throwable)e);
                }
                LOG.error("Failed to mutate: " + keyBase + " after " + (System.currentTimeMillis() - start) + "ms; region information: " + MultiThreadedUpdater.this.getRegionDebugInfoSafe(table, m.getRow()) + "; errors: " + exceptionInfo);
            }
        }
    }
}

