/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSink;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationLoad {
    public static final ReplicationLoad EMPTY_REPLICATIONLOAD = new ReplicationLoad();
    private List<MetricsSource> sourceMetricsList;
    private MetricsSink sinkMetrics;
    private List<ClusterStatusProtos.ReplicationLoadSource> replicationLoadSourceList;
    private ClusterStatusProtos.ReplicationLoadSink replicationLoadSink;

    public void buildReplicationLoad(List<MetricsSource> srMetricsList, MetricsSink skMetrics) {
        this.sourceMetricsList = srMetricsList;
        this.sinkMetrics = skMetrics;
        ClusterStatusProtos.ReplicationLoadSink.Builder rLoadSinkBuild = ClusterStatusProtos.ReplicationLoadSink.newBuilder();
        rLoadSinkBuild.setAgeOfLastAppliedOp(this.sinkMetrics.getAgeOfLastAppliedOp());
        rLoadSinkBuild.setTimeStampsOfLastAppliedOp(this.sinkMetrics.getTimestampOfLastAppliedOp());
        this.replicationLoadSink = rLoadSinkBuild.build();
        HashMap<String, ClusterStatusProtos.ReplicationLoadSource> replicationLoadSourceMap = new HashMap<String, ClusterStatusProtos.ReplicationLoadSource>();
        for (MetricsSource sm : this.sourceMetricsList) {
            String peerId = sm.getPeerID();
            String[] parts = peerId.split("-", 2);
            peerId = parts.length != 1 ? parts[0] : peerId;
            long ageOfLastShippedOp = sm.getAgeOfLastShippedOp();
            int sizeOfLogQueue = sm.getSizeOfLogQueue();
            long timeStampOfLastShippedOp = sm.getTimestampOfLastShippedOp();
            long replicationLag = ReplicationLoad.calculateReplicationDelay(ageOfLastShippedOp, timeStampOfLastShippedOp, sizeOfLogQueue);
            ClusterStatusProtos.ReplicationLoadSource rLoadSource = (ClusterStatusProtos.ReplicationLoadSource)replicationLoadSourceMap.get(peerId);
            if (rLoadSource != null) {
                ageOfLastShippedOp = Math.max(rLoadSource.getAgeOfLastShippedOp(), ageOfLastShippedOp);
                sizeOfLogQueue += rLoadSource.getSizeOfLogQueue();
                timeStampOfLastShippedOp = Math.min(rLoadSource.getTimeStampOfLastShippedOp(), timeStampOfLastShippedOp);
                replicationLag = Math.max(rLoadSource.getReplicationLag(), replicationLag);
            }
            ClusterStatusProtos.ReplicationLoadSource.Builder rLoadSourceBuild = ClusterStatusProtos.ReplicationLoadSource.newBuilder();
            rLoadSourceBuild.setPeerID(peerId);
            rLoadSourceBuild.setAgeOfLastShippedOp(ageOfLastShippedOp);
            rLoadSourceBuild.setSizeOfLogQueue(sizeOfLogQueue);
            rLoadSourceBuild.setTimeStampOfLastShippedOp(timeStampOfLastShippedOp);
            rLoadSourceBuild.setReplicationLag(replicationLag);
            replicationLoadSourceMap.put(peerId, rLoadSourceBuild.build());
        }
        this.replicationLoadSourceList = new ArrayList(replicationLoadSourceMap.values());
    }

    static long calculateReplicationDelay(long ageOfLastShippedOp, long timeStampOfLastShippedOp, int sizeOfLogQueue) {
        if (timeStampOfLastShippedOp == 0L) {
            return Long.MAX_VALUE;
        }
        long timePassedAfterLastShippedOp = EnvironmentEdgeManager.currentTime() - timeStampOfLastShippedOp;
        long replicationLag = sizeOfLogQueue > 1 ? Math.max(ageOfLastShippedOp, timePassedAfterLastShippedOp) : (timePassedAfterLastShippedOp < 2L * ageOfLastShippedOp ? ageOfLastShippedOp : 0L);
        return replicationLag;
    }

    public String sourceToString() {
        if (this.sourceMetricsList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ClusterStatusProtos.ReplicationLoadSource rls : this.replicationLoadSourceList) {
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"\n           PeerID", (Object)rls.getPeerID());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"AgeOfLastShippedOp", (Object)rls.getAgeOfLastShippedOp());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"SizeOfLogQueue", (Object)rls.getSizeOfLogQueue());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"TimestampsOfLastShippedOp", (Object)new Date(rls.getTimeStampOfLastShippedOp()).toString());
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"Replication Lag", (Object)rls.getReplicationLag());
        }
        return sb.toString();
    }

    public String sinkToString() {
        if (this.replicationLoadSink == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"AgeOfLastAppliedOp", (Object)this.replicationLoadSink.getAgeOfLastAppliedOp());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"TimestampsOfLastAppliedOp", (Object)new Date(this.replicationLoadSink.getTimeStampsOfLastAppliedOp()).toString());
        return sb.toString();
    }

    public ClusterStatusProtos.ReplicationLoadSink getReplicationLoadSink() {
        return this.replicationLoadSink;
    }

    public List<ClusterStatusProtos.ReplicationLoadSource> getReplicationLoadSourceList() {
        return this.replicationLoadSourceList;
    }

    public String toString() {
        return this.sourceToString() + System.getProperty("line.separator") + this.sinkToString();
    }
}

