// Autogenerated Jamon implementation
// /home/relocate/hbase-source/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 32, 1
import java.util.*;
// 33, 1
import java.io.IOException;
// 34, 1
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
// 35, 1
import org.apache.hadoop.hbase.client.RegionInfo;
// 36, 1
import org.apache.hadoop.hbase.client.TableDescriptor;
// 37, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
// 38, 1
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
// 39, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 40, 1
import org.apache.hadoop.hbase.HConstants;
// 41, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 42, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 43, 1
import org.apache.hadoop.hbase.ServerName;
// 44, 1
import org.apache.hadoop.hbase.TableName;
// 45, 1
import org.apache.hadoop.hbase.client.Admin;
// 46, 1
import org.apache.hadoop.hbase.client.MasterSwitchType;
// 47, 1
import org.apache.hadoop.hbase.client.TableState;
// 48, 1
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
// 49, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 50, 1
import org.apache.hadoop.hbase.master.HMaster;
// 51, 1
import org.apache.hadoop.hbase.master.RegionState;
// 52, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 53, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 54, 1
import org.apache.hadoop.hbase.quotas.QuotaUtil;
// 55, 1
import org.apache.hadoop.hbase.security.access.AccessControlLists;
// 56, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 57, 1
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos.SnapshotDescription;
// 58, 1
import org.apache.hadoop.hbase.tool.CanaryTool;
// 59, 1
import org.apache.hadoop.hbase.util.Bytes;
// 60, 1
import org.apache.hadoop.hbase.util.FSUtils;
// 61, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 62, 1
import org.apache.hadoop.util.StringUtils;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final AssignmentManager assignmentManager;
  private final boolean catalogJanitorEnabled;
  private final Set<ServerName> deadServers;
  private final String filter;
  private final String format;
  private final Map<String,Integer> frags;
  private final ServerName metaLocation;
  private final ServerManager serverManager;
  private final List<ServerName> servers;
  // 74, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  // 101, 1
  
  public static String getUserTables(HMaster master, List<TableDescriptor> tables){
    if (master.isInitialized()){
      try {
        Map<String, TableDescriptor> descriptorMap = master.getTableDescriptors().getAll();
        if (descriptorMap != null) {
          for (TableDescriptor desc : descriptorMap.values()) {
            if (!desc.getTableName().isSystemTable()) {
             tables.add(desc);
            }
          }
        }
      } catch (IOException e) {
        return "Got user tables error, " + e.getMessage();
      }
    }
    return null;
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    assignmentManager = p_implData.getAssignmentManager();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    deadServers = p_implData.getDeadServers();
    filter = p_implData.getFilter();
    format = p_implData.getFormat();
    frags = p_implData.getFrags();
    metaLocation = p_implData.getMetaLocation();
    serverManager = p_implData.getServerManager();
    servers = p_implData.getServers();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 65, 1
    if (format.equals("json") )
    {
      // 65, 30
      jamonWriter.write("\n  ");
      // 66, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_7 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_7.setFilter(filter);
        __jamon__var_7.setFormat("json" );
        __jamon__var_7.renderNoFlush(jamonWriter);
      }
      // 66, 68
      jamonWriter.write("\n  ");
      // 67, 3
      return; 
    }
    // 68, 7
    jamonWriter.write("\n");
    // 69, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 121, 1
    jamonWriter.write("<!DOCTYPE html>\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>");
    // 126, 12
    if (master.isActiveMaster() )
    {
      // 126, 43
      jamonWriter.write("Master: ");
    }
    // 126, 51
    else
    {
      // 126, 58
      jamonWriter.write("Backup Master: ");
    }
    // 126, 79
    jamonWriter.write("\n    ");
    // 127, 5
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 127, 47
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/master-status\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                ");
    // 151, 17
    if (master.isActiveMaster() )
    {
      // 151, 48
      jamonWriter.write("\n                    <li><a href=\"/procedures.jsp\">Procedures &amp; Locks</a></li>\n                    <li><a href=\"/hbck.jsp\">HBCK Report</a></li>\n                    ");
      // 154, 21
      if (master.getConfiguration().getBoolean(QuotaUtil.QUOTA_CONF_KEY, false) )
      {
        // 154, 98
        jamonWriter.write("\n                        <li><a href=\"/quotas.jsp\">Quotas</a></li>\n                    ");
      }
      // 156, 27
      jamonWriter.write("\n                ");
    }
    // 157, 23
    jamonWriter.write("\n                <li><a href=\"/processMaster.jsp\">Process Metrics</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/prof\">Profiler</a></li>\n                ");
    // 164, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 164, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 166, 23
    jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container-fluid content\">\n\t");
    // 173, 2
    if (master.isActiveMaster() )
    {
      // 173, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 176, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 176, 77
      jamonWriter.write("</small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 182, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 182, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 184, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 184, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://hbase.apache.org/book.html#trouble.log.gc\">HBase Reference Guide</a>\n          for details.\n          </div>\n        ");
      }
      // 189, 15
      jamonWriter.write("\n        ");
      // 190, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 190, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 195, 15
      jamonWriter.write("\n        ");
      // 196, 9
      if (master.isInMaintenanceMode() )
      {
        // 196, 45
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n          Your Master is in maintenance mode. This is because hbase.master.maintenance_mode is\n          set to true. Under the maintenance mode, no quota or no Master coprocessor is loaded.\n          </div>\n        ");
      }
      // 201, 15
      jamonWriter.write("\n        ");
      // 202, 9
      if (!master.isBalancerOn() )
      {
        // 202, 39
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
      }
      // 208, 15
      jamonWriter.write("\n        ");
      // 209, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.SPLIT) )
      {
        // 209, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region splits are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable splits from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 215, 15
      jamonWriter.write("\n        ");
      // 216, 9
      if (!master.isSplitOrMergeEnabled(MasterSwitchType.MERGE) )
      {
        // 216, 70
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region merges are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable merges from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 222, 15
      jamonWriter.write("\n        ");
      // 223, 9
      if (master.getAssignmentManager() != null )
      {
        // 223, 54
        jamonWriter.write("\n          ");
        // 224, 11
        {
          org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_8 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
          __jamon__var_8.renderNoFlush(jamonWriter, master.getAssignmentManager());
        }
        // 224, 92
        jamonWriter.write("\n        ");
      }
      // 225, 15
      jamonWriter.write("\n        ");
      // 226, 9
      if (!master.isInMaintenanceMode() )
      {
        // 226, 46
        jamonWriter.write("\n          ");
        // 227, 11
        if (master.getMasterCoprocessorHost().findCoprocessor("RSGroupAdminEndpoint") != null &&
            serverManager.getOnlineServersList().size() > 0 )
        {
          // 228, 63
          jamonWriter.write("\n            <section>\n              <h2><a name=\"rsgroup\">RSGroup</a></h2>\n              ");
          // 231, 15
          {
            org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl __jamon__var_9 = new org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl(this.getTemplateManager());
            __jamon__var_9.renderNoFlush(jamonWriter, master, serverManager);
          }
          // 231, 81
          jamonWriter.write("\n            </section>\n          ");
        }
        // 233, 17
        jamonWriter.write("\n        ");
      }
      // 234, 15
      jamonWriter.write("\n        <section>\n            <h2><a name=\"regionservers\">Region Servers</a></h2>\n            ");
      // 237, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_10 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_10.setServers(servers );
        __jamon__var_10.renderNoFlush(jamonWriter, master);
      }
      // 237, 74
      jamonWriter.write("\n\n            ");
      // 239, 13
      if ((deadServers != null) )
      {
        // 239, 42
        jamonWriter.write("\n                ");
        // 240, 17
        {
          // 240, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 240, 40
        jamonWriter.write("\n            ");
      }
      // 241, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 244, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_11 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_11.renderNoFlush(jamonWriter, master );
      }
      // 244, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2><a name=\"tables\">Tables</a></h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 262, 25
      if ((metaLocation != null) )
      {
        // 262, 55
        jamonWriter.write("\n                            ");
        // 263, 29
        {
          // 263, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 263, 45
        jamonWriter.write("\n                        ");
      }
      // 264, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 267, 25
      if ((metaLocation != null) )
      {
        // 267, 55
        jamonWriter.write("\n                            ");
        // 268, 29
        {
          // 268, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 268, 48
        jamonWriter.write("\n                        ");
      }
      // 269, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
      // 272, 25
      {
        // 272, 25
        __jamon_innerUnit__userSnapshots(jamonWriter);
      }
      // 272, 44
      jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        <section>\n            <h2><a name=\"peers\">Peers</a></h2>\n            ");
      // 279, 13
      {
        // 279, 13
        __jamon_innerUnit__peerConfigs(jamonWriter);
      }
      // 279, 30
      jamonWriter.write("\n        </section>\n\t");
    }
    // 281, 2
    else
    {
      // 281, 9
      jamonWriter.write("\n        <section>\n            ");
      // 283, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_12 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_12.renderNoFlush(jamonWriter, master );
      }
      // 283, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 285, 8
    jamonWriter.write("\n\n\n        <section>\n            ");
    // 289, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_13 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_13.setFilter(filter);
      __jamon__var_13.setParent("/master-status" );
      __jamon__var_13.renderNoFlush(jamonWriter);
    }
    // 289, 88
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2><a name=\"attributes\">Software Attributes</a></h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 302, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 302, 84
    jamonWriter.write(", revision=");
    // 302, 95
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 302, 155
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 306, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 306, 81
    jamonWriter.write(", ");
    // 306, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 306, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
    // 311, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 311, 88
    jamonWriter.write("</td>\n                    <td>HBase source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 316, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 316, 78
    jamonWriter.write(", revision=");
    // 316, 89
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 316, 143
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 321, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 321, 75
    jamonWriter.write(", ");
    // 321, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 321, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
    // 326, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 326, 82
    jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
    // 331, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 331, 72
    jamonWriter.write(", revision=");
    // 331, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevision()), jamonWriter);
    // 331, 131
    jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
    // 336, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 336, 74
    jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Quorum</td>\n                    <td> ");
    // 342, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 342, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Base Path</td>\n                    <td> ");
    // 347, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 347, 79
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>Cluster Key</td>\n                    <td> ");
    // 352, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 352, 48
    jamonWriter.write(":");
    // 352, 49
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getZNodePaths().baseZNode), jamonWriter);
    // 352, 102
    jamonWriter.write("</td>\n                    <td>Key to add this cluster as a peer for replication. Use 'help \"add_peer\"' in the shell for details.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 357, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(FSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 357, 87
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 362, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 362, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 365, 17
    if (master.isActiveMaster() )
    {
      // 365, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 368, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 368, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 373, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 373, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 378, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager() == null ? "0.00" :
	                      StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 379, 98
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 382, 18
      if (frags != null )
      {
        // 382, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 385, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 385, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 388, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 391, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getMasterCoprocessorHost() == null ? "[]" :
	                      java.util.Arrays.toString(master.getMasterCoprocessors())), jamonWriter);
      // 392, 84
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
      // 397, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getLoadBalancerClassName()), jamonWriter);
      // 397, 65
      jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
    }
    // 400, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jqSpager.js\" type=\"text/javascript\"></script>\n    <script>\n    $(document).ready(function()\n        {\n            $(\"#baseStatsTable\").tablesorter();\n            $(\"#memoryStatsTable\").tablesorter();\n            $(\"#requestStatsTable\").tablesorter();\n            $(\"#storeStatsTable\").tablesorter();\n            $(\"#compactionStatsTable\").tablesorter();\n\n            $(\"#userTables\").tablesorter();\n\n            function showRitPages() {\n                if (!$(\"#rit_page_num\")) {\n                  return;\n                }\n                var ritTotalNum = parseInt($(\"#rit_page_num\").val());\n                if (!ritTotalNum || ritTotalNum < 1) {\n                  return;\n                }\n\n                 $(\"#rit_pagination\").sPage({\n                      page:1,\n                      total:ritTotalNum,\n                      pageSize:5,\n                      noData: false,\n                      showPN:true,\n                      prevPage:\"prev\",\n                      nextPage:\"next\",\n                      fastForward: 5,\n                      backFun:function(page){\n                          $(\"div[id^='tab_rits']\").removeClass('active');\n                          $(\"#tab_rits\"+page).addClass('active');\n                      }\n                  });\n\n            }\n            showRitPages();\n\n        }\n    );\n    </script>\n  </body>\n</html>\n\n");
  }
  
  
  // 455, 1
  private void __jamon_innerUnit__catalogTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 456, 1
    
 List<TableDescriptor> sysTables = master.isInitialized() ?
   master.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;

    // 460, 1
    if ((sysTables != null && sysTables.size() > 0))
    {
      // 460, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
      // 464, 5
      if ((frags != null) )
      {
        // 464, 28
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
      }
      // 466, 11
      jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
      // 469, 1
      for (TableDescriptor systemTable : sysTables)
      {
        // 469, 48
        jamonWriter.write("\n<tr>\n");
        // 471, 1
        TableName tableName = systemTable.getTableName();
        // 472, 5
        jamonWriter.write("<td><a href=\"table.jsp?name=");
        // 472, 33
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 472, 48
        jamonWriter.write("\">");
        // 472, 50
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 472, 65
        jamonWriter.write("</a></td>\n    ");
        // 473, 5
        if ((frags != null))
        {
          // 473, 27
          jamonWriter.write("\n        <td align=\"center\">");
          // 474, 28
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
          // 475, 37
          jamonWriter.write("</td>\n    ");
        }
        // 476, 11
        jamonWriter.write("\n    ");
        // 477, 5
        String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions.";
        } else if (tableName.equals(CanaryTool.DEFAULT_WRITE_TABLE_NAME)){
            description = "The hbase:canary table is used to sniff the write availbility of"
              + " each regionserver.";
        } else if (tableName.equals(AccessControlLists.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl.";
        } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
            description = "The hbase:labels table holds information about visibility labels.";
        } else if (tableName.equals(TableName.NAMESPACE_TABLE_NAME)){
            description = "The hbase:namespace table holds information about namespaces.";
        } else if (tableName.equals(QuotaUtil.QUOTA_TABLE_NAME)){
            description = "The hbase:quota table holds quota information about number" +
            " or size of requests in a given time frame.";
        } else if (tableName.equals(TableName.valueOf("hbase:rsgroup"))){
            description = "The hbase:rsgroup table holds information about regionserver groups.";
        } else if (tableName.equals(TableName.valueOf("hbase:replication"))) {
            description = "The hbase:replication table tracks cross cluster replication through " +
            "WAL file offsets.";
        }
    
        // 499, 5
        jamonWriter.write("<td>");
        // 499, 9
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
        // 499, 26
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 501, 8
      jamonWriter.write("\n</table>\n");
    }
    // 503, 7
    jamonWriter.write("\n");
  }
  
  
  // 619, 1
  private void __jamon_innerUnit__deadRegionServers(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 621, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 621, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 629, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
    
      // 635, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 637, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 637, 33
      jamonWriter.write("</td>\n        <td>");
      // 638, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 638, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 640, 5
      
        }
    
      // 643, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 645, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 645, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 649, 7
    jamonWriter.write("\n");
  }
  
  
  // 652, 1
  private void __jamon_innerUnit__peerConfigs(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 653, 1
    
    List<ReplicationPeerDescription> peers = null;
    if (master.getReplicationPeerManager() != null) {
        peers = master.getReplicationPeerManager().listPeers(null);
    }

    // 659, 1
    jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Peer Id</th>\n        <th>Cluster Key</th>\n        <th>Endpoint</th>\n        <th>State</th>\n        <th>IsSerial</th>\n        <th>Bandwidth</th>\n        <th>ReplicateAll</th>\n        <th>Namespaces</th>\n        <th>Exclude Namespaces</th>\n        <th>Table Cfs</th>\n        <th>Exclude Table Cfs</th>\n    </tr>\n");
    // 673, 1
    if ((peers != null && peers.size() > 0))
    {
      // 673, 43
      jamonWriter.write("\n    ");
      // 674, 5
      for (ReplicationPeerDescription peer : peers )
      {
        // 674, 53
        jamonWriter.write("\n    ");
        // 675, 5
        
        String peerId = peer.getPeerId();
        ReplicationPeerConfig peerConfig = peer.getPeerConfig();
    
        // 679, 5
        jamonWriter.write("<tr>\n        <td>");
        // 680, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerId), jamonWriter);
        // 680, 25
        jamonWriter.write("</td>\n        <td>");
        // 681, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getClusterKey()), jamonWriter);
        // 681, 45
        jamonWriter.write("</td>\n        <td>");
        // 682, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getReplicationEndpointImpl()), jamonWriter);
        // 682, 58
        jamonWriter.write("</td>\n        <td>");
        // 683, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peer.isEnabled() ? "ENABLED" : "DISABLED"), jamonWriter);
        // 683, 60
        jamonWriter.write("</td>\n        <td>");
        // 684, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.isSerial()), jamonWriter);
        // 684, 40
        jamonWriter.write("</td>\n        <td>");
        // 685, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getBandwidth() == 0? "UNLIMITED" : StringUtils.humanReadableInt(peerConfig.getBandwidth())), jamonWriter);
        // 685, 120
        jamonWriter.write("</td>\n        <td>");
        // 686, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.replicateAllUserTables()), jamonWriter);
        // 686, 54
        jamonWriter.write("</td>\n        <td>\n           ");
        // 688, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getNamespaces()).replaceAll(";", "; ")), jamonWriter);
        // 688, 151
        jamonWriter.write("\n        </td>\n        <td>\n            ");
        // 691, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getExcludeNamespaces() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeNamespaces()).replaceAll(";", "; ")), jamonWriter);
        // 691, 166
        jamonWriter.write("\n        </td>\n        <td>\n           ");
        // 694, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 694, 153
        jamonWriter.write("\n        </td>\n        <td>\n           ");
        // 697, 12
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(peerConfig.getExcludeTableCFsMap() == null ? "" : ReplicationPeerConfigUtil.convertToString(peerConfig.getExcludeTableCFsMap()).replaceAll(";", "; ")), jamonWriter);
        // 697, 167
        jamonWriter.write("\n        </td>\n    </tr>\n    ");
      }
      // 700, 12
      jamonWriter.write("\n");
    }
    // 701, 7
    jamonWriter.write("\n<tr><td>Total: ");
    // 702, 16
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf((peers != null) ? peers.size() : 0), jamonWriter);
    // 702, 56
    jamonWriter.write("</td></tr>\n</table>\n");
  }
  
  
  // 590, 1
  private void __jamon_innerUnit__userSnapshots(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 591, 1
    
   List<SnapshotDescription> snapshots = master.isInitialized() ?
     master.getSnapshotManager().getCompletedSnapshots() : null;

    // 595, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 595, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
      // 602, 5
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 602, 57
        jamonWriter.write("\n    ");
        // 603, 5
        
        TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
    
        // 606, 5
        jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
        // 607, 40
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 607, 68
        jamonWriter.write("\">");
        // 607, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 607, 98
        jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
        // 608, 37
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 608, 74
        jamonWriter.write("\">");
        // 608, 76
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 608, 113
        jamonWriter.write("</a>\n        </td>\n        <td>");
        // 610, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 610, 59
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 612, 12
      jamonWriter.write("\n    <p>");
      // 613, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 613, 30
      jamonWriter.write(" snapshot(s) in set. [<a href=\"/snapshotsStats.jsp\">Snapshot Storefile stats</a>]</p>\n</table>\n");
    }
    // 615, 7
    jamonWriter.write("\n");
  }
  
  
  // 506, 1
  private void __jamon_innerUnit__userTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 507, 1
    
   List<TableDescriptor> tables = new ArrayList<TableDescriptor>();
   String errorMessage = getUserTables(master, tables);

    // 511, 1
    if ((tables.size() == 0 && errorMessage != null))
    {
      // 511, 52
      jamonWriter.write("\n<p> ");
      // 512, 5
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(errorMessage), jamonWriter);
      // 512, 23
      jamonWriter.write(" </p>\n");
    }
    // 513, 7
    jamonWriter.write("\n\n");
    // 515, 1
    if ((tables != null && tables.size() > 0))
    {
      // 515, 45
      jamonWriter.write("\n<table id=\"userTables\" class=\"tablesorter table table-striped\">\n<thead>\n    <tr>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Namespace</th>\n        <th style=\"vertical-align: middle;\" rowspan=\"2\">Name</th>\n        ");
      // 521, 9
      if ((frags != null) )
      {
        // 521, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 523, 15
      jamonWriter.write("\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">State</th>\n        <th style=\"text-align: center\" colspan=\"8\">Regions</th>\n        <th style=\"vertical-align:middle;\" rowspan=\"2\">Description</th>\n    </tr>\n    <tr>\n        <th>OPEN</th>\n        <th>OPENING</th>\n        <th>CLOSED</th>\n        <th>CLOSING</th>\n        <th>OFFLINE</th>\n        <th>FAILED</th>\n        <th>SPLIT</th>\n        <th>Other</th>\n    </tr>\n</thead>\n<tbody>\n    ");
      // 540, 5
      for (TableDescriptor desc : tables)
      {
        // 540, 42
        jamonWriter.write("\n    ");
        // 541, 5
        
      HTableDescriptor htDesc = new HTableDescriptor(desc);
      TableName tableName = htDesc.getTableName();
      TableState tableState = master.getTableStateManager().getTableState(tableName);
      Map<RegionState.State, List<RegionInfo>> tableRegions =
          master.getAssignmentManager().getRegionStates()
            .getRegionByStateOfTable(tableName);
      int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
      int openingRegionsCount = tableRegions.get(RegionState.State.OPENING).size();
      int closedRegionsCount = tableRegions.get(RegionState.State.CLOSED).size();
      int closingRegionsCount = tableRegions.get(RegionState.State.CLOSING).size();
      int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
      int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
      int failedRegionsCount = tableRegions.get(RegionState.State.FAILED_OPEN).size()
             + tableRegions.get(RegionState.State.FAILED_CLOSE).size();
      int otherRegionsCount = 0;
      for (List<RegionInfo> list: tableRegions.values()) {
         otherRegionsCount += list.size();
      }
      // now subtract known states
      otherRegionsCount = otherRegionsCount - openRegionsCount
                     - failedRegionsCount - offlineRegionsCount
                     - splitRegionsCount - openingRegionsCount
                     - closedRegionsCount - closingRegionsCount;
    
        // 566, 5
        jamonWriter.write("<tr>\n        <td>");
        // 567, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNamespaceAsString()), jamonWriter);
        // 567, 51
        jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
        // 568, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
        // 568, 69
        jamonWriter.write(">");
        // 568, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getQualifierAsString()), jamonWriter);
        // 568, 108
        jamonWriter.write("</a> </td>\n        ");
        // 569, 9
        if ((frags != null) )
        {
          // 569, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 570, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 570, 150
          jamonWriter.write("</td>\n        ");
        }
        // 571, 15
        jamonWriter.write("\n        <td>");
        // 572, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableState.getState()), jamonWriter);
        // 572, 40
        jamonWriter.write("</td>\n        <td>");
        // 573, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openRegionsCount), jamonWriter);
        // 573, 35
        jamonWriter.write("</td>\n        ");
        // 574, 9
        if ((openingRegionsCount > 0) )
        {
          // 574, 42
          jamonWriter.write(" <td><a href=\"/rits.jsp?table=");
          // 574, 72
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
          // 574, 105
          jamonWriter.write("&state=OPENING\">");
          // 574, 121
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
          // 574, 146
          jamonWriter.write("</td> ");
        }
        // 574, 152
        else
        {
          // 574, 159
          jamonWriter.write("<td>");
          // 574, 163
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openingRegionsCount), jamonWriter);
          // 574, 188
          jamonWriter.write("</td> ");
        }
        // 574, 200
        jamonWriter.write("\n        <td>");
        // 575, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closedRegionsCount), jamonWriter);
        // 575, 37
        jamonWriter.write("</td>\n        ");
        // 576, 9
        if ((closingRegionsCount > 0) )
        {
          // 576, 42
          jamonWriter.write(" <td><a href=\"/rits.jsp?table=");
          // 576, 72
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
          // 576, 105
          jamonWriter.write("&state=CLOSING\">");
          // 576, 121
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
          // 576, 146
          jamonWriter.write("</td> ");
        }
        // 576, 152
        else
        {
          // 576, 159
          jamonWriter.write("<td>");
          // 576, 163
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(closingRegionsCount), jamonWriter);
          // 576, 188
          jamonWriter.write("</td> ");
        }
        // 576, 200
        jamonWriter.write("\n        <td>");
        // 577, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
        // 577, 38
        jamonWriter.write("</td>\n        <td>");
        // 578, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(failedRegionsCount), jamonWriter);
        // 578, 37
        jamonWriter.write("</td>\n        <td>");
        // 579, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
        // 579, 36
        jamonWriter.write("</td>\n        <td>");
        // 580, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
        // 580, 36
        jamonWriter.write("</td>\n        <td>");
        // 581, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 581, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 583, 12
      jamonWriter.write("\n    <p>");
      // 584, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.size()), jamonWriter);
      // 584, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</tbody>\n</table>\n");
    }
    // 587, 7
    jamonWriter.write("\n");
  }
  
  
}
